/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.utils;

import java.util.Locale;
import org.arquillian.cube.docker.impl.client.utils.NumberConversion;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NumberConversionTest {
    private static final Long TEN_MEGABYTES = 9999800L;
    private static final Long ONE_KIKIBYTE = 1024L;
    private static final Long NEGATIVE_ONE_KIKIBYTE = -1024L;
    private static final Long ONE_TERABYTES = 1000000000000L;
    private static final Long HUNDRED_GIGABYTES = 100000000000L;
    private static final Long ONE_EXBIBYTE = 0x1000000000000000L;
    private static final Long ONE_PEBIBYTE = 0x4000000000000L;

    @Before
    public void set_locale() {
        Locale.setDefault(Locale.ENGLISH);
    }

    @Test
    public void should_be_convert_byte_to_long() {
        Assert.assertThat((Object)NumberConversion.convertToLong((Object)127), (Matcher)CoreMatchers.is((Object)127L));
    }

    @Test
    public void should_be_convert_short_to_long() {
        Assert.assertThat((Object)NumberConversion.convertToLong((Object)Short.MAX_VALUE), (Matcher)CoreMatchers.is((Object)32767L));
    }

    @Test
    public void should_be_convert_integer_to_long() {
        Assert.assertThat((Object)NumberConversion.convertToLong((Object)Integer.MAX_VALUE), (Matcher)CoreMatchers.is((Object)Integer.MAX_VALUE));
    }

    @Test
    public void should_be_convert_hex_to_long() {
        Assert.assertThat((Object)NumberConversion.convertToLong((Object)16), (Matcher)CoreMatchers.is((Object)16L));
    }

    @Test
    public void should_be_return_zero_to_null() {
        Assert.assertThat((Object)NumberConversion.convertToLong(null), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void should_be_possible_to_show_null_as_zero_bytes_in_human_readable_form() {
        Assert.assertThat((Object)NumberConversion.humanReadableByteCount(null, (boolean)true), (Matcher)CoreMatchers.is((Object)"0 B"));
    }

    @Test
    public void should_be_possible_to_show_megabytes_in_human_readable_form() {
        Assert.assertThat((Object)NumberConversion.humanReadableByteCount((Long)TEN_MEGABYTES, (boolean)true), (Matcher)CoreMatchers.is((Object)"10.00 MB"));
    }

    @Test
    public void should_be_possible_to_show_gigabytes_in_human_readable_form() {
        Assert.assertThat((Object)NumberConversion.humanReadableByteCount((Long)HUNDRED_GIGABYTES, (boolean)true), (Matcher)CoreMatchers.is((Object)"100.00 GB"));
    }

    @Test
    public void should_be_possible_to_show_terabytes_in_human_readable_form() {
        Assert.assertThat((Object)NumberConversion.humanReadableByteCount((Long)ONE_TERABYTES, (boolean)true), (Matcher)CoreMatchers.is((Object)"1.00 TB"));
    }

    @Test
    public void should_be_possible_to_show_kikibytes_in_human_readable_form() {
        Assert.assertThat((Object)NumberConversion.humanReadableByteCount((Long)ONE_KIKIBYTE, (boolean)false), (Matcher)CoreMatchers.is((Object)"1.00 KiB"));
    }

    @Test
    public void should_be_possible_to_show_pebibytes_in_human_readable_form() {
        Assert.assertThat((Object)NumberConversion.humanReadableByteCount((Long)ONE_PEBIBYTE, (boolean)false), (Matcher)CoreMatchers.is((Object)"1.00 PiB"));
    }

    @Test
    public void should_be_possible_to_show_exabytes_in_human_readable_form() {
        Assert.assertThat((Object)NumberConversion.humanReadableByteCount((Long)ONE_EXBIBYTE, (boolean)false), (Matcher)CoreMatchers.is((Object)"1.00 EiB"));
    }

    @Test
    public void should_be_possible_to_show_negative_kikibytes_in_human_readable_form() {
        Assert.assertThat((Object)NumberConversion.humanReadableByteCount((Long)NEGATIVE_ONE_KIKIBYTE, (boolean)false), (Matcher)CoreMatchers.is((Object)"- 1.00 KiB"));
    }
}

