/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.restassured;

import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.util.SinglePortBindResolver;
import org.arquillian.cube.docker.restassured.RestAssuredConfiguration;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.api.event.ManagerStopping;

public class RestAssuredCustomizer {
    @Inject
    Instance<CubeDockerConfiguration> cubeDockerConfigurationInstance;
    @Inject
    @ApplicationScoped
    InstanceProducer<RequestSpecBuilder> requestSpecBuilderInstanceProducer;

    public void configure(@Observes RestAssuredConfiguration restAssuredConfiguration) {
        CubeDockerConfiguration cubeDockerConfiguration = (CubeDockerConfiguration)this.cubeDockerConfigurationInstance.get();
        RequestSpecBuilder requestSpecBuilder = new RequestSpecBuilder();
        this.configureRequestSpecBuilder(restAssuredConfiguration, cubeDockerConfiguration, requestSpecBuilder);
        this.requestSpecBuilderInstanceProducer.set((Object)requestSpecBuilder);
    }

    void configureRequestSpecBuilder(@Observes RestAssuredConfiguration restAssuredConfiguration, CubeDockerConfiguration cubeDockerConfiguration, RequestSpecBuilder requestSpecBuilder) {
        if (restAssuredConfiguration.isBaseUriSet()) {
            requestSpecBuilder.setBaseUri(restAssuredConfiguration.getBaseUri());
        } else {
            requestSpecBuilder.setBaseUri(restAssuredConfiguration.getSchema() + "://" + cubeDockerConfiguration.getDockerServerIp());
        }
        if (restAssuredConfiguration.isPortSet()) {
            requestSpecBuilder.setPort(SinglePortBindResolver.resolveBindPort((CubeDockerConfiguration)cubeDockerConfiguration, (int)restAssuredConfiguration.getPort(), (String[])restAssuredConfiguration.getExclusionContainers()));
        } else {
            requestSpecBuilder.setPort(SinglePortBindResolver.resolveBindPort((CubeDockerConfiguration)cubeDockerConfiguration, (String[])restAssuredConfiguration.getExclusionContainers()));
        }
        if (restAssuredConfiguration.isBasePathSet()) {
            requestSpecBuilder.setBasePath(restAssuredConfiguration.getBasePath());
        }
        if (restAssuredConfiguration.isAuthenticationSchemeSet()) {
            requestSpecBuilder.setAuth(restAssuredConfiguration.getAuthenticationScheme());
        }
        if (restAssuredConfiguration.isUseRelaxedHttpsValidationSet()) {
            if (restAssuredConfiguration.isUseRelaxedHttpsValidationInAllProtocols()) {
                requestSpecBuilder.setRelaxedHTTPSValidation();
            } else {
                requestSpecBuilder.setRelaxedHTTPSValidation(restAssuredConfiguration.getUseRelaxedHttpsValidation());
            }
        }
    }

    public void resetRestAssuredConfiguration(@Observes ManagerStopping event) {
        RestAssured.reset();
    }
}

