/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.restassured;

import io.restassured.authentication.AuthenticationScheme;
import io.restassured.authentication.BasicAuthScheme;
import io.restassured.authentication.CertAuthScheme;
import io.restassured.authentication.FormAuthScheme;
import io.restassured.authentication.OAuthScheme;
import io.restassured.authentication.PreemptiveBasicAuthScheme;
import io.restassured.authentication.PreemptiveOAuth2HeaderScheme;
import org.arquillian.cube.docker.restassured.AuthenticationSchemeFactory;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class AuthenticateSchemeFactoryTest {
    @Test
    public void should_create_basic_auth() {
        AuthenticationScheme authenticationScheme = AuthenticationSchemeFactory.create((String)"basic:username:password");
        Assertions.assertThat((Object)authenticationScheme).isInstanceOf(BasicAuthScheme.class);
        BasicAuthScheme basicAuthScheme = (BasicAuthScheme)authenticationScheme;
        Assertions.assertThat((String)basicAuthScheme.getUserName()).isEqualTo("username");
        Assertions.assertThat((String)basicAuthScheme.getPassword()).isEqualTo("password");
    }

    @Test
    public void should_create_form_auth() {
        AuthenticationScheme authenticationScheme = AuthenticationSchemeFactory.create((String)"form:username:password");
        Assertions.assertThat((Object)authenticationScheme).isInstanceOf(FormAuthScheme.class);
        FormAuthScheme authScheme = (FormAuthScheme)authenticationScheme;
        Assertions.assertThat((Object)authScheme.getUserName()).isEqualTo((Object)"username");
        Assertions.assertThat((Object)authScheme.getPassword()).isEqualTo((Object)"password");
    }

    @Test
    public void should_create_preemptive_auth() {
        AuthenticationScheme authenticationScheme = AuthenticationSchemeFactory.create((String)"preemptive:username:password");
        Assertions.assertThat((Object)authenticationScheme).isInstanceOf(PreemptiveBasicAuthScheme.class);
        PreemptiveBasicAuthScheme authScheme = (PreemptiveBasicAuthScheme)authenticationScheme;
        Assertions.assertThat((String)authScheme.getUserName()).isEqualTo("username");
        Assertions.assertThat((String)authScheme.getPassword()).isEqualTo("password");
    }

    @Test
    public void should_create_certificate_auth() {
        AuthenticationScheme authenticationScheme = AuthenticationSchemeFactory.create((String)"certificate:file:///url:password");
        Assertions.assertThat((Object)authenticationScheme).isInstanceOf(CertAuthScheme.class);
        CertAuthScheme authScheme = (CertAuthScheme)authenticationScheme;
        Assertions.assertThat((String)authScheme.getTrustStorePassword()).isEqualTo("password");
        Assertions.assertThat((Object)authScheme.getPathToTrustStore()).isEqualTo((Object)"///url");
    }

    @Test
    public void should_create_digest_auth() {
        AuthenticationScheme authenticationScheme = AuthenticationSchemeFactory.create((String)"digest:username:password");
        Assertions.assertThat((Object)authenticationScheme).isInstanceOf(BasicAuthScheme.class);
        BasicAuthScheme authScheme = (BasicAuthScheme)authenticationScheme;
        Assertions.assertThat((String)authScheme.getUserName()).isEqualTo("username");
        Assertions.assertThat((String)authScheme.getPassword()).isEqualTo("password");
    }

    @Test
    public void should_create_oauth_auth() {
        AuthenticationScheme authenticationScheme = AuthenticationSchemeFactory.create((String)"oauth:consumerKey:consumerSecret:accessToken:secretToken");
        Assertions.assertThat((Object)authenticationScheme).isInstanceOf(OAuthScheme.class);
        OAuthScheme authScheme = (OAuthScheme)authenticationScheme;
        Assertions.assertThat((String)authScheme.getAccessToken()).isEqualTo("accessToken");
        Assertions.assertThat((String)authScheme.getConsumerKey()).isEqualTo("consumerKey");
        Assertions.assertThat((String)authScheme.getConsumerSecret()).isEqualTo("consumerSecret");
        Assertions.assertThat((String)authScheme.getSecretToken()).isEqualTo("secretToken");
    }

    @Test
    public void should_create_oauth_auth2() {
        AuthenticationScheme authenticationScheme = AuthenticationSchemeFactory.create((String)"oauth2:accessToken");
        Assertions.assertThat((Object)authenticationScheme).isInstanceOf(PreemptiveOAuth2HeaderScheme.class);
        PreemptiveOAuth2HeaderScheme authScheme = (PreemptiveOAuth2HeaderScheme)authenticationScheme;
        Assertions.assertThat((String)authScheme.getAccessToken()).isEqualTo("accessToken");
    }
}

