/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.restassured;

import io.restassured.builder.RequestSpecBuilder;
import java.util.HashMap;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.util.ConfigUtil;
import org.arquillian.cube.docker.restassured.RestAssuredConfiguration;
import org.arquillian.cube.docker.restassured.RestAssuredCustomizer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RestAssuredCustomizerTest {
    private static final String SIMPLE_SCENARIO = "helloworld:\n  image: dockercloud/hello-world\n  portBindings: [8080->80/tcp]";
    @Mock
    CubeDockerConfiguration cubeDockerConfiguration;
    @Mock
    RequestSpecBuilder requestSpecBuilder;

    @Before
    public void setup() {
        Mockito.when((Object)this.cubeDockerConfiguration.getDockerServerIp()).thenReturn((Object)"192.168.99.100");
        Mockito.when((Object)this.cubeDockerConfiguration.getDockerContainersContent()).thenReturn((Object)ConfigUtil.load((String)SIMPLE_SCENARIO));
    }

    @Test
    public void should_autoresolve_base_uri() {
        RestAssuredCustomizer restAssuredCustomizer = new RestAssuredCustomizer();
        HashMap conf = new HashMap();
        RestAssuredConfiguration restAssuredConfiguration = RestAssuredConfiguration.fromMap(conf);
        restAssuredCustomizer.configureRequestSpecBuilder(restAssuredConfiguration, this.cubeDockerConfiguration, this.requestSpecBuilder);
        ((RequestSpecBuilder)Mockito.verify((Object)this.requestSpecBuilder)).setBaseUri("http://192.168.99.100");
    }

    @Test
    public void should_autoresolve_base_uri_with_schema_if_set() {
        RestAssuredCustomizer restAssuredCustomizer = new RestAssuredCustomizer();
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("schema", "https");
        RestAssuredConfiguration restAssuredConfiguration = RestAssuredConfiguration.fromMap(conf);
        restAssuredCustomizer.configureRequestSpecBuilder(restAssuredConfiguration, this.cubeDockerConfiguration, this.requestSpecBuilder);
        ((RequestSpecBuilder)Mockito.verify((Object)this.requestSpecBuilder)).setBaseUri("https://192.168.99.100");
    }

    @Test
    public void should_use_base_uri() {
        RestAssuredCustomizer restAssuredCustomizer = new RestAssuredCustomizer();
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("baseUri", "http://localhost");
        RestAssuredConfiguration restAssuredConfiguration = RestAssuredConfiguration.fromMap(conf);
        restAssuredCustomizer.configureRequestSpecBuilder(restAssuredConfiguration, this.cubeDockerConfiguration, this.requestSpecBuilder);
        ((RequestSpecBuilder)Mockito.verify((Object)this.requestSpecBuilder)).setBaseUri("http://localhost");
    }

    @Test
    public void should_autoresolve_port() {
        RestAssuredCustomizer restAssuredCustomizer = new RestAssuredCustomizer();
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("baseUri", "http://localhost");
        RestAssuredConfiguration restAssuredConfiguration = RestAssuredConfiguration.fromMap(conf);
        restAssuredCustomizer.configureRequestSpecBuilder(restAssuredConfiguration, this.cubeDockerConfiguration, this.requestSpecBuilder);
        ((RequestSpecBuilder)Mockito.verify((Object)this.requestSpecBuilder)).setPort(8080);
    }

    @Test
    public void should_resolve_exposed_port() {
        RestAssuredCustomizer restAssuredCustomizer = new RestAssuredCustomizer();
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("baseUri", "http://localhost");
        conf.put("port", "80");
        RestAssuredConfiguration restAssuredConfiguration = RestAssuredConfiguration.fromMap(conf);
        restAssuredCustomizer.configureRequestSpecBuilder(restAssuredConfiguration, this.cubeDockerConfiguration, this.requestSpecBuilder);
        ((RequestSpecBuilder)Mockito.verify((Object)this.requestSpecBuilder)).setPort(8080);
    }

    @Test
    public void should_resolve_exposed_port_as_bind_port_if_no_definitions() {
        RestAssuredCustomizer restAssuredCustomizer = new RestAssuredCustomizer();
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("baseUri", "http://localhost");
        conf.put("port", "8081");
        RestAssuredConfiguration restAssuredConfiguration = RestAssuredConfiguration.fromMap(conf);
        restAssuredCustomizer.configureRequestSpecBuilder(restAssuredConfiguration, this.cubeDockerConfiguration, this.requestSpecBuilder);
        ((RequestSpecBuilder)Mockito.verify((Object)this.requestSpecBuilder)).setPort(8081);
    }

    @Test
    public void should_set_relaxed_https_validation_in_all_protocols() {
        RestAssuredCustomizer restAssuredCustomizer = new RestAssuredCustomizer();
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("baseUri", "http://localhost");
        conf.put("port", "8081");
        conf.put("useRelaxedHttpsValidation", null);
        RestAssuredConfiguration restAssuredConfiguration = RestAssuredConfiguration.fromMap(conf);
        restAssuredCustomizer.configureRequestSpecBuilder(restAssuredConfiguration, this.cubeDockerConfiguration, this.requestSpecBuilder);
        ((RequestSpecBuilder)Mockito.verify((Object)this.requestSpecBuilder)).setRelaxedHTTPSValidation();
    }
}

