/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.restassured;

import io.restassured.builder.RequestSpecBuilder;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.cube.DockerUrl;
import org.arquillian.cube.HostIpContext;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.metadata.HasPortBindings;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;

public class RequestSpecBuilderResourceProvider
implements ResourceProvider {
    private static final Logger logger = Logger.getLogger(RequestSpecBuilderResourceProvider.class.getName());
    @Inject
    Instance<CubeRegistry> cubeRegistryInstance;
    @Inject
    Instance<HostIpContext> hostUriContext;
    @Inject
    private Instance<RequestSpecBuilder> requestSpecBuilderInstance;

    public boolean canProvide(Class<?> type) {
        return RequestSpecBuilder.class.isAssignableFrom(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        RequestSpecBuilder requestSpecBuilder = (RequestSpecBuilder)this.requestSpecBuilderInstance.get();
        if (requestSpecBuilder == null) {
            throw new IllegalStateException("RequestSpecBuilder was not found.");
        }
        Optional<DockerUrl> dockerUrlAnnotation = this.getDockerUrlAnnotation(qualifiers);
        if (dockerUrlAnnotation.isPresent()) {
            int exposedPort;
            String containerName;
            int bindPort;
            DockerUrl dockerUrl = dockerUrlAnnotation.get();
            if ("https".equals(dockerUrl.protocol())) {
                requestSpecBuilder.setBaseUri(dockerUrl.protocol() + "://" + this.getHost());
            }
            if ((bindPort = this.getBindingPort(containerName = dockerUrl.containerName(), exposedPort = dockerUrl.exposedPort())) > 0) {
                requestSpecBuilder.setPort(bindPort);
            } else {
                logger.log(Level.WARNING, String.format("There is no container with id %s.", containerName));
            }
            requestSpecBuilder.setBasePath(dockerUrl.context());
        }
        return requestSpecBuilder;
    }

    private Optional<DockerUrl> getDockerUrlAnnotation(Annotation[] annotations) {
        return Arrays.stream(annotations).filter(annotation -> DockerUrl.class.equals(annotation.annotationType())).map(annotation -> (DockerUrl)annotation).findFirst();
    }

    String getHost() {
        HostIpContext hostIpContext = (HostIpContext)this.hostUriContext.get();
        return hostIpContext.getHost();
    }

    private int getBindingPort(String cubeId, int exposedPort) {
        HasPortBindings portBindings;
        HasPortBindings.PortAddress mappedAddress;
        int bindPort = -1;
        Cube cube = this.getCube(cubeId);
        if (cube != null && (mappedAddress = (portBindings = (HasPortBindings)cube.getMetadata(HasPortBindings.class)).getMappedAddress(exposedPort)) != null) {
            bindPort = mappedAddress.getPort();
        }
        return bindPort;
    }

    private Cube getCube(String cubeId) {
        return ((CubeRegistry)this.cubeRegistryInstance.get()).getCube(cubeId);
    }
}

