/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.SystemUtils;
import org.arquillian.cube.docker.impl.client.CubeDockerConfigurator;
import org.arquillian.cube.docker.impl.util.Boot2Docker;
import org.arquillian.cube.docker.impl.util.CommandLineExecutor;
import org.arquillian.cube.docker.impl.util.DockerMachine;
import org.arquillian.cube.docker.impl.util.OperatingSystemFamily;
import org.arquillian.cube.docker.impl.util.Top;
import org.arquillian.cube.spi.CubeConfiguration;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsMapContaining;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.test.AbstractManagerTestBase;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class CubeConfiguratorTest
extends AbstractManagerTestBase {
    @Mock
    CommandLineExecutor commandLineExecutor;
    @Mock
    ArquillianDescriptor arquillianDescriptor;
    @Mock
    ExtensionDef extensionDef;
    @Mock
    Top top;

    protected void addExtensions(List<Class<?>> extensions) {
        extensions.add(CubeDockerConfigurator.class);
        super.addExtensions(extensions);
    }

    @Before
    public void setup() {
        this.bind(ApplicationScoped.class, Boot2Docker.class, new Boot2Docker(this.commandLineExecutor));
        this.bind(ApplicationScoped.class, DockerMachine.class, new DockerMachine(this.commandLineExecutor));
        this.bind(ApplicationScoped.class, ArquillianDescriptor.class, this.arquillianDescriptor);
        this.bind(ApplicationScoped.class, Top.class, this.top);
        Mockito.when((Object)this.top.isSpinning()).thenReturn((Object)false);
    }

    @Test
    public void shouldChangeServerUriInCaseOfRunningDockerInsideDocker() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serverUri", "https://dockerHost:22222");
        Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
        Mockito.when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
        Mockito.when((Object)this.commandLineExecutor.execCommand(new String[]{"boot2docker", "ip"})).thenReturn((Object)"192.168.0.1");
        Mockito.when((Object)this.top.isSpinning()).thenReturn((Object)true);
        this.fire(new CubeConfiguration());
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"serverUri", (Object)OperatingSystemFamily.DIND.getServerUri()));
    }

    @Test
    public void shouldNotChangeServerUriInCaseODockerInsideDockerIfItIsDisabled() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serverUri", "https://dockerHost:22222");
        config.put("dockerInsideDockerResolution", "false");
        Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
        Mockito.when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
        Mockito.when((Object)this.commandLineExecutor.execCommand(new String[]{"boot2docker", "ip"})).thenReturn((Object)"192.168.0.1");
        Mockito.when((Object)this.top.isSpinning()).thenReturn((Object)true);
        this.fire(new CubeConfiguration());
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"serverUri", (Object)"https://192.168.0.1:22222"));
    }

    @Test
    public void shouldUseBoot2DockerIfDockerHostIsSetOnServerURIByDefault() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serverUri", "https://dockerHost:22222");
        Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
        Mockito.when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
        Mockito.when((Object)this.commandLineExecutor.execCommand(new String[]{"boot2docker", "ip"})).thenReturn((Object)"192.168.0.1");
        this.fire(new CubeConfiguration());
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"serverUri", (Object)"https://192.168.0.1:22222"));
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)"certPath"), (Matcher)CoreMatchers.endsWith((String)(File.separator + ".boot2docker" + File.separator + "certs" + File.separator + "boot2docker-vm"))));
    }

    @Test
    public void shouldUseDockerMachineIfDockerHostIsSetOnServerURIAndMachineNameIsSet() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serverUri", "https://dockerHost:22222");
        config.put("machineName", "dev");
        Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
        Mockito.when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
        Mockito.when((Object)this.commandLineExecutor.execCommandAsArray(new String[]{"docker-machine", "ls", "--filter", "name=dev"})).thenReturn(Arrays.asList("NAME   ACTIVE   DRIVER       STATE     URL                         SWARM", "dev    *        virtualbox   Running   tcp://192.168.0.2:222222     "));
        Mockito.when((Object)this.commandLineExecutor.execCommand(new String[]{"docker-machine", "ip", "dev"})).thenReturn((Object)"192.168.0.2");
        this.fire(new CubeConfiguration());
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"serverUri", (Object)"https://192.168.0.2:22222"));
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)"certPath"), (Matcher)CoreMatchers.endsWith((String)(File.separator + ".docker" + File.separator + "machine" + File.separator + "machines" + File.separator + (String)config.get("machineName")))));
    }

    @Test
    public void shouldStartDockerMachineIfItIsStoppedAndMachineNameIsSet() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serverUri", "https://dockerHost:22222");
        config.put("machineName", "dev");
        Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
        Mockito.when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
        Mockito.when((Object)this.commandLineExecutor.execCommandAsArray(new String[]{"docker-machine", "ls", "--filter", "name=dev"})).thenReturn(Arrays.asList("NAME   ACTIVE   DRIVER       STATE     URL                         SWARM", "dev    *        virtualbox   Stopped   tcp://192.168.0.2:222222     "));
        Mockito.when((Object)this.commandLineExecutor.execCommand(new String[]{"docker-machine", "ip", "dev"})).thenReturn((Object)"192.168.0.2");
        this.fire(new CubeConfiguration());
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"serverUri", (Object)"https://192.168.0.2:22222"));
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)"certPath"), (Matcher)CoreMatchers.endsWith((String)(File.separator + ".docker" + File.separator + "machine" + File.separator + "machines" + File.separator + (String)config.get("machineName")))));
        ((CommandLineExecutor)Mockito.verify((Object)this.commandLineExecutor, (VerificationMode)Mockito.times((int)1))).execCommand(new String[]{"docker-machine", "start", "dev"});
    }

    @Test
    public void shouldUseDockerMachineIfDockerHostIsNotSetAndOnlyOneMachineIsRunning() {
        HashMap config = new HashMap();
        Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
        Mockito.when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
        Mockito.when((Object)this.commandLineExecutor.execCommand(new String[]{"docker-machine", "ip", "dev"})).thenReturn((Object)"192.168.99.100");
        Mockito.when((Object)this.commandLineExecutor.execCommandAsArray(new String[]{"docker-machine", "ls", "--filter", "state=Running"})).thenReturn(Arrays.asList("NAME   ACTIVE   DRIVER       STATE     URL                         SWARM", "dev    *        virtualbox   Running   tcp://192.168.99.100:2376     "));
        Mockito.when((Object)this.commandLineExecutor.execCommand(new String[]{"docker-machine"})).thenReturn((Object)"Usage: docker-machine [OPTIONS] COMMAND [arg...]");
        this.fire(new CubeConfiguration());
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"serverUri", (Object)"tcp://192.168.99.100:2376"));
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)"certPath"), (Matcher)CoreMatchers.endsWith((String)(File.separator + ".docker" + File.separator + "machine" + File.separator + "machines" + File.separator + (String)config.get("machineName")))));
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"machineName", (Object)"dev"));
    }

    @Test
    public void shouldNotUseDockerMachineIfDockerHostIsNotSetNotDockerMachineAndTwoMachineIsRunning() {
        Assume.assumeTrue((SystemUtils.IS_OS_MAC_OSX || SystemUtils.IS_OS_WINDOWS ? 1 : 0) != 0);
        HashMap config = new HashMap();
        Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
        Mockito.when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
        Mockito.when((Object)this.commandLineExecutor.execCommand(new String[]{"docker-machine", "ip", "dev"})).thenReturn((Object)"192.168.99.100");
        Mockito.when((Object)this.commandLineExecutor.execCommandAsArray(new String[]{"docker-machine", "ls", "--filter", "state=Running"})).thenReturn(Arrays.asList("NAME   ACTIVE   DRIVER       STATE     URL                         SWARM", "dev    *        virtualbox   Running   tcp://192.168.99.100:2376     ", "dev2   *        virtualbox   Running   tcp://192.168.99.100:2376     "));
        Mockito.when((Object)this.commandLineExecutor.execCommand(new String[]{"boot2docker", "ip"})).thenReturn((Object)"192.168.0.1");
        Mockito.when((Object)this.commandLineExecutor.execCommand(new String[]{"docker-machine"})).thenReturn((Object)"Usage: docker-machine [OPTIONS] COMMAND [arg...]");
        this.fire(new CubeConfiguration());
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"serverUri", (Object)"tcp://192.168.0.1:2376"));
    }

    @Test
    public void shouldUseDefaultsInCaseOfNotHavingDockerMachineInstalledAndNoDockerUriNorMachineName() {
        Assume.assumeTrue((SystemUtils.IS_OS_MAC_OSX || SystemUtils.IS_OS_WINDOWS ? 1 : 0) != 0);
        HashMap config = new HashMap();
        Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
        Mockito.when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
        Mockito.when((Object)this.commandLineExecutor.execCommand(new String[]{"boot2docker", "ip"})).thenReturn((Object)"192.168.0.1");
        Mockito.when((Object)this.commandLineExecutor.execCommand(new String[]{"docker-machine"})).thenThrow(new Throwable[]{new IllegalArgumentException()});
        this.fire(new CubeConfiguration());
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"serverUri", (Object)"tcp://192.168.0.1:2376"));
    }

    @Test
    public void shouldUseHostEnvIfDockerHostIsSetOnServerURIAndSystemEnvironmentVarIsSet() {
        String originalVar = System.getProperty("DOCKER_HOST");
        try {
            System.setProperty("DOCKER_HOST", "tcp://127.0.0.1:22222");
            HashMap config = new HashMap();
            Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
            Mockito.when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
            this.fire(new CubeConfiguration());
            Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"serverUri", (Object)"tcp://127.0.0.1:22222"));
            Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"dockerServerIp", (Object)"127.0.0.1"));
        }
        finally {
            if (originalVar != null) {
                System.setProperty("DOCKER_HOST", originalVar);
            } else {
                System.clearProperty("DOCKER_HOST");
            }
        }
    }

    @Test
    public void dockerUriTcpShouldBeReplacedToHttpsInCaseOfDockerMachine() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serverUri", "tcp://dockerHost:22222");
        config.put("machineName", "dev");
        Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
        Mockito.when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
        Mockito.when((Object)this.commandLineExecutor.execCommand(new String[]{"docker-machine", "ip", "dev"})).thenReturn((Object)"192.168.0.2");
        Mockito.when((Object)this.commandLineExecutor.execCommandAsArray(new String[]{"docker-machine", "ls", "--filter", "name=dev"})).thenReturn(Arrays.asList("NAME   ACTIVE   DRIVER       STATE     URL                         SWARM", "dev    *        virtualbox   Running   tcp://192.168.0.2:222222     "));
        this.fire(new CubeConfiguration());
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"serverUri", (Object)"tcp://192.168.0.2:22222"));
    }

    @Test
    public void dockerUriTcpShouldBeReplacedToHttpInCaseOfSingleHost() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serverUri", "tcp://192.168.0.2:22222");
        Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
        Mockito.when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
        this.fire(new CubeConfiguration());
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"serverUri", (Object)"tcp://192.168.0.2:22222"));
    }

    @Test
    public void dockerUriTcpShouldBeReplacedToHttpsInCaseOfDockerHostTagPresent() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serverUri", "tcp://dockerHost:22222");
        Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
        Mockito.when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
        Mockito.when((Object)this.commandLineExecutor.execCommand(new String[]{"boot2docker", "ip"})).thenReturn((Object)"192.168.0.2");
        this.fire(new CubeConfiguration());
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"serverUri", (Object)"tcp://192.168.0.2:22222"));
    }

    @Test
    public void dockerUriTcpShouldBeReplacedToHttpsInCaseOfCertPathPresent() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serverUri", "tcp://dockerHost:22222");
        config.put("certPath", "~/.ssh");
        Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
        Mockito.when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
        Mockito.when((Object)this.commandLineExecutor.execCommand(new String[]{"boot2docker", "ip"})).thenReturn((Object)"192.168.0.2");
        this.fire(new CubeConfiguration());
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"serverUri", (Object)"tcp://192.168.0.2:22222"));
    }

    @Test
    public void dockerUriConfigurationParameterShouldTakePrecedenceOverSystemEnv() {
        String originalVar = System.getProperty("DOCKER_HOST");
        try {
            System.setProperty("DOCKER_HOST", "tcp://127.0.0.1:22222");
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("serverUri", "https://dockerHost:22222");
            Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
            Mockito.when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
            Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
            Mockito.when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
            Mockito.when((Object)this.commandLineExecutor.execCommand(new String[]{"boot2docker", "ip"})).thenReturn((Object)"192.168.0.1");
            this.fire(new CubeConfiguration());
            Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"serverUri", (Object)"https://192.168.0.1:22222"));
            Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Matcher)CoreMatchers.is((Object)"certPath"), (Matcher)CoreMatchers.endsWith((String)(File.separator + ".boot2docker" + File.separator + "certs" + File.separator + "boot2docker-vm"))));
            Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"dockerServerIp", (Object)"192.168.0.1"));
        }
        finally {
            if (originalVar != null) {
                System.setProperty("DOCKER_HOST", originalVar);
            } else {
                System.clearProperty("DOCKER_HOST");
            }
        }
    }

    @Test
    public void shouldDumpCubeConfiguration() throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serverUri", "https://dockerHost:22222");
        Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
        Mockito.when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
        Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
        Mockito.when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
        Mockito.when((Object)this.commandLineExecutor.execCommand(new String[]{"boot2docker", "ip"})).thenReturn((Object)"192.168.0.1");
        PrintStream old = System.out;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        System.setOut(new PrintStream(baos));
        CubeConfiguration cubeConfiguration = new CubeConfiguration();
        this.fire(cubeConfiguration);
        System.out.flush();
        System.setOut(old);
        Assert.assertThat((Object)baos.toString(), (Matcher)CoreMatchers.containsString((String)"CubeDockerConfiguration:"));
    }
}

