/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.docker.compose;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.CubeContainers;
import org.arquillian.cube.docker.impl.client.config.Link;
import org.arquillian.cube.docker.impl.client.config.PortBinding;
import org.arquillian.cube.docker.impl.docker.compose.DockerComposeConverter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.Assert;
import org.junit.Test;

public class DockerComposeConverterTest {
    @Test
    public void shouldTransformSimpleDockerComposeFormat() throws URISyntaxException, IOException {
        URI simpleDockerCompose = DockerComposeConverterTest.class.getResource("/simple-docker-compose.yml").toURI();
        DockerComposeConverter dockerComposeConverter = DockerComposeConverter.create((Path)Paths.get(simpleDockerCompose));
        CubeContainers convert = dockerComposeConverter.convert();
        CubeContainer webapp = convert.get("webapp");
        Assert.assertThat((Object)webapp.getBuildImage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)webapp.getPortBindings(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Collection ports = webapp.getPortBindings();
        Assert.assertThat((Object)ports, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new PortBinding[]{PortBinding.valueOf((String)"8000->8000")}));
        Assert.assertThat((Object)webapp.getDevices(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)webapp.getVolumes(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Collection volumes = webapp.getVolumes();
        Assert.assertThat((Object)volumes, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"/data"}));
        CubeContainer webapp2 = convert.get("webapp2");
        Assert.assertThat((Object)webapp2.getImage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)webapp2.getPortBindings(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)webapp2.getLinks(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Collection links = webapp2.getLinks();
        Assert.assertThat((Object)links, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Link[]{Link.valueOf((String)"webapp:webapp")}));
        Assert.assertThat((Object)webapp2.getEnv(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Collection env = webapp2.getEnv();
        Assert.assertThat((Object)env, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"RACK_ENV=development"}));
    }

    @Test
    public void shouldReadEnvironmentVarsFromFile() throws URISyntaxException, IOException {
        URI readEnvsDockerCompose = DockerComposeConverterTest.class.getResource("/read-envs-docker-compose.yml").toURI();
        DockerComposeConverter dockerComposeConverter = DockerComposeConverter.create((Path)Paths.get(readEnvsDockerCompose));
        CubeContainers convert = dockerComposeConverter.convert();
        CubeContainer webapp = convert.get("webapp");
        Assert.assertThat((Object)webapp.getEnv(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Collection env = webapp.getEnv();
        Assert.assertThat((Object)env, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"RACK_ENV=development"}));
    }

    @Test
    public void shouldResolveEnvironmentVars() throws URISyntaxException, IOException {
        this.testResolvePlaceholders("/simple-cube-var.yml", "MyImageName");
    }

    @Test
    public void shouldResolveSystemEnvironmentVars() throws URISyntaxException, IOException {
        this.testResolvePlaceholders("/simple-cube-system-var.yml", "TestImageName");
    }

    private void testResolvePlaceholders(String dockerComposeFile, String expectedImageName) throws URISyntaxException, IOException {
        URI readEnvsDockerCompose = DockerComposeConverterTest.class.getResource(dockerComposeFile).toURI();
        DockerComposeConverter dockerComposeConverter = DockerComposeConverter.create((Path)Paths.get(readEnvsDockerCompose));
        CubeContainers convert = dockerComposeConverter.convert();
        CubeContainer webapp = convert.get("webapp2");
        Assert.assertThat((Object)webapp.getImage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        String image = webapp.getImage().toImageRef();
        Assert.assertThat((Object)image, (Matcher)CoreMatchers.is((Object)expectedImageName));
    }

    @Test
    public void shouldExtendDockerCompose() throws URISyntaxException, IOException {
        URI readEnvsDockerCompose = DockerComposeConverterTest.class.getResource("/extends-docker-compose.yml").toURI();
        DockerComposeConverter dockerComposeConverter = DockerComposeConverter.create((Path)Paths.get(readEnvsDockerCompose));
        CubeContainers convert = dockerComposeConverter.convert();
        CubeContainer webapp = convert.get("web");
        Assert.assertThat((Object)webapp.getEnv(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Collection env = webapp.getEnv();
        Assert.assertThat((Object)env, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"REDIS_HOST=redis-production.example.com"}));
        Assert.assertThat((Object)webapp.getPortBindings(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Collection ports = webapp.getPortBindings();
        Assert.assertThat((Object)ports, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new PortBinding[]{PortBinding.valueOf((String)"8080->8080")}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldExtendDockerComposeWithEnvResolution() throws URISyntaxException, IOException {
        String oldValue = System.getProperty("ports");
        System.setProperty("ports", "9090:8080");
        try {
            URI readEnvsDockerCompose = DockerComposeConverterTest.class.getResource("/extends-docker-compose-env.yml").toURI();
            DockerComposeConverter dockerComposeConverter = DockerComposeConverter.create((Path)Paths.get(readEnvsDockerCompose));
            CubeContainers convert = dockerComposeConverter.convert();
            CubeContainer webapp = convert.get("web");
            Assert.assertThat((Object)webapp.getEnv(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            Collection env = webapp.getEnv();
            Assert.assertThat((Object)env, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"REDIS_HOST=redis-production.example.com"}));
            Assert.assertThat((Object)webapp.getPortBindings(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            Collection ports = webapp.getPortBindings();
            Assert.assertThat((Object)ports, (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new PortBinding[]{PortBinding.valueOf((String)"9090->8080")}));
        }
        finally {
            System.clearProperty("ports");
            if (oldValue != null) {
                System.setProperty("ports", oldValue);
            }
        }
    }
}

