/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import java.util.Arrays;
import java.util.Set;
import org.arquillian.cube.docker.impl.util.CommandLineExecutor;
import org.arquillian.cube.docker.impl.util.DockerMachine;
import org.arquillian.cube.docker.impl.util.Machine;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DockerMachineTest {
    @Mock
    private CommandLineExecutor executor;

    @Test
    public void shouldParseStoppedMachines() {
        Mockito.when((Object)this.executor.execCommandAsArray(new String[]{"docker-machine", "ls"})).thenReturn(Arrays.asList("NAME   ACTIVE   DRIVER       STATE     URL                         SWARM", "dev    -        virtualbox   Stopped                                     "));
        DockerMachine dockerMachine = new DockerMachine(this.executor);
        Set list = dockerMachine.list();
        Assert.assertThat((Object)list, (Matcher)Matchers.hasSize((int)1));
        Machine[] machines = list.toArray(new Machine[1]);
        Assert.assertThat((Object)machines[0].getName(), (Matcher)Matchers.is((Object)"dev"));
        Assert.assertThat((Object)machines[0].getState(), (Matcher)Matchers.is((Object)"Stopped"));
        Assert.assertThat((Object)machines[0].getUrl(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void shouldListDockerMachines() {
        Mockito.when((Object)this.executor.execCommandAsArray(new String[]{"docker-machine", "ls"})).thenReturn(Arrays.asList("NAME   ACTIVE   DRIVER       STATE     URL                         SWARM", "dev    *        virtualbox   Running   tcp://192.168.99.100:2376     ", "qa     *        virtualbox   Running   tcp://192.168.99.101:2376     swarm-master"));
        DockerMachine dockerMachine = new DockerMachine(this.executor);
        Set list = dockerMachine.list();
        Assert.assertThat((Object)list, (Matcher)Matchers.hasSize((int)2));
        Machine[] machines = list.toArray(new Machine[2]);
        Assert.assertThat((Object)machines[0].getName(), (Matcher)Matchers.is((Object)"qa"));
        Assert.assertThat((Object)machines[0].getState(), (Matcher)Matchers.is((Object)"Running"));
        Assert.assertThat((Object)machines[0].getSwarm(), (Matcher)Matchers.is((Object)"swarm-master"));
        Assert.assertThat((Object)machines[1].getName(), (Matcher)Matchers.is((Object)"dev"));
        Assert.assertThat((Object)machines[1].getState(), (Matcher)Matchers.is((Object)"Running"));
        Assert.assertThat((Object)machines[1].getSwarm(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void shouldListWithFilterDockerMachines() {
        Mockito.when((Object)this.executor.execCommandAsArray(new String[]{"docker-machine", "ls", "--filter", "state=Running"})).thenReturn(Arrays.asList("NAME   ACTIVE   DRIVER       STATE     URL                         SWARM", "dev    *        virtualbox   Running   tcp://192.168.99.100:2376     ", "qa     *        virtualbox   Running   tcp://192.168.99.101:2376     swarm-master"));
        DockerMachine dockerMachine = new DockerMachine(this.executor);
        Set list = dockerMachine.list("state", "Running");
        Assert.assertThat((Object)list, (Matcher)Matchers.hasSize((int)2));
        Machine[] machines = list.toArray(new Machine[2]);
        Assert.assertThat((Object)machines[0].getName(), (Matcher)Matchers.is((Object)"qa"));
        Assert.assertThat((Object)machines[0].getState(), (Matcher)Matchers.is((Object)"Running"));
        Assert.assertThat((Object)machines[0].getSwarm(), (Matcher)Matchers.is((Object)"swarm-master"));
        Assert.assertThat((Object)machines[1].getName(), (Matcher)Matchers.is((Object)"dev"));
        Assert.assertThat((Object)machines[1].getState(), (Matcher)Matchers.is((Object)"Running"));
        Assert.assertThat((Object)machines[1].getSwarm(), (Matcher)Matchers.is((Object)""));
    }
}

