/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.docker.compose;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.arquillian.cube.docker.impl.client.Converter;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.CubeContainers;
import org.arquillian.cube.docker.impl.docker.compose.ContainerBuilder;
import org.arquillian.cube.docker.impl.docker.compose.DockerComposeEnvironmentVarResolver;
import org.arquillian.cube.docker.impl.util.YamlUtil;
import org.arquillian.cube.impl.util.IOUtil;
import org.yaml.snakeyaml.Yaml;

public class DockerComposeConverter
implements Converter {
    private Map<String, Object> dockerComposeDefinitionMap = new HashMap<String, Object>();
    private Path dockerComposeRootDirectory;

    private DockerComposeConverter(Path location) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(location.toFile());){
            String content = DockerComposeEnvironmentVarResolver.replaceParameters(inputStream);
            this.dockerComposeDefinitionMap = this.loadConfig(content);
            this.dockerComposeRootDirectory = location.getParent();
        }
    }

    private String resolvePlaceholders(String content) {
        content = this.resolveSystemProperties(content);
        Map<String, String> env = System.getenv();
        return IOUtil.replacePlaceholdersWithWhiteSpace((String)content, env);
    }

    private String resolveSystemProperties(String content) {
        return IOUtil.replacePlaceholdersWithWhiteSpace((String)content);
    }

    private DockerComposeConverter(String content) {
        String resolvePlaceholders = this.resolvePlaceholders(content);
        this.dockerComposeDefinitionMap = this.loadConfig(resolvePlaceholders);
        this.dockerComposeRootDirectory = Paths.get(".", new String[0]);
    }

    public static DockerComposeConverter create(Path location) {
        try {
            return new DockerComposeConverter(location);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static DockerComposeConverter create(String content) {
        return new DockerComposeConverter(content);
    }

    @Override
    public CubeContainers convert() {
        CubeContainers cubeContainers = new CubeContainers();
        Set<String> names = this.dockerComposeDefinitionMap.keySet();
        for (String name : names) {
            CubeContainer cubeContainer = this.convertContainer(YamlUtil.asMap(this.dockerComposeDefinitionMap, name));
            cubeContainers.add(name, cubeContainer);
        }
        return cubeContainers;
    }

    private CubeContainer convertContainer(Map<String, Object> dockerComposeContainerDefinition) {
        ContainerBuilder containerBuilder = new ContainerBuilder(this.dockerComposeRootDirectory);
        return containerBuilder.build(dockerComposeContainerDefinition);
    }

    private Map<String, Object> loadConfig(String content) {
        return (Map)new Yaml().load(content);
    }
}

