/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;

public final class Ping {
    public static final String COMMAND_NOT_FOUND = "command not found";

    private Ping() {
    }

    public static boolean ping(DockerClientExecutor dockerClientExecutor, String containerId, String command, int totalIterations, long sleep, TimeUnit timeUnit) {
        boolean result = false;
        int iteration = 0;
        do {
            if (result = Ping.execContainerPing(dockerClientExecutor, containerId, command)) continue;
            ++iteration;
            try {
                timeUnit.sleep(sleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!result && iteration < totalIterations);
        return result;
    }

    public static boolean ping(String host, int port, int totalIterations, long sleep, TimeUnit timeUnit) {
        boolean result = false;
        int iteration = 0;
        do {
            if (result = Ping.ping(host, port)) continue;
            ++iteration;
            try {
                timeUnit.sleep(sleep);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!result && iteration < totalIterations);
        return result;
    }

    private static boolean execContainerPing(DockerClientExecutor dockerClientExecutor, String containerId, String command) {
        Object[] commands = new String[]{"sh", "-c", command};
        String result = dockerClientExecutor.execStart(containerId, (String[])commands);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Command %s in container %s has returned no value.", Arrays.toString(commands), containerId));
        }
        if (result != null && result.contains(COMMAND_NOT_FOUND)) {
            throw new UnsupportedOperationException(String.format("Command %s is not available in container %s.", Arrays.toString(commands), containerId));
        }
        try {
            int numberOfListenConnectons = Integer.parseInt(result.trim());
            return numberOfListenConnectons > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean ping(String host, int port) {
        Socket socket = null;
        try {
            socket = new Socket(host, port);
            boolean bl = true;
            return bl;
        }
        catch (UnknownHostException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

