/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.await;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.arquillian.cube.docker.impl.await.AwaitStrategyFactory;
import org.arquillian.cube.docker.impl.await.CustomAwaitStrategyInstantiator;
import org.arquillian.cube.docker.impl.await.HttpAwaitStrategy;
import org.arquillian.cube.docker.impl.await.LogScanningAwaitStrategy;
import org.arquillian.cube.docker.impl.await.NativeAwaitStrategy;
import org.arquillian.cube.docker.impl.await.PollingAwaitStrategy;
import org.arquillian.cube.docker.impl.await.SleepingAwaitStrategy;
import org.arquillian.cube.docker.impl.await.StaticAwaitStrategy;
import org.arquillian.cube.docker.impl.client.config.Await;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.DockerCompositions;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.util.ConfigUtil;
import org.arquillian.cube.docker.impl.util.HomeResolverUtil;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.await.AwaitStrategy;
import org.arquillian.spacelift.Spacelift;
import org.arquillian.spacelift.task.net.DownloadTool;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AwaitStrategyTest {
    @Mock
    private Cube<?> cube;
    @Mock
    private DockerClientExecutor dockerClientExecutor;

    @Test
    public void should_be_able_to_use_wait_for_it_await_strategy() {
        ((DownloadTool)Spacelift.task(DownloadTool.class)).from("https://raw.githubusercontent.com/vishnubob/wait-for-it/master/wait-for-it.sh").to(HomeResolverUtil.resolveHomeDirectoryChar((String)"~/.arquillian/wait-for-it.sh")).execute().await();
    }

    @Test
    public void should_be_able_to_create_http_await_strategy() {
        String containerDefinition = "tomcat:\n            image: tutum/tomcat:7.0\n            exposedPorts: [8089/tcp]\n            await:\n              strategy: http\n              iterations: 10\n              sleepPollingTime: 200 s\n              url: http://localhost:8080/ping\n              responseCode: 201\n              match: 'Server startup'\n              headers: \n                   X-Cube: Docker\n";
        DockerCompositions load = ConfigUtil.load((InputStream)new ByteArrayInputStream(containerDefinition.getBytes()));
        CubeContainer tomcat = (CubeContainer)load.getContainers().get("tomcat");
        HttpAwaitStrategy awaitStrategy = new HttpAwaitStrategy(this.cube, this.dockerClientExecutor, tomcat.getAwait());
        Assert.assertThat((Object)awaitStrategy.getPollIterations(), (Matcher)CoreMatchers.is((Object)10));
        Assert.assertThat((Object)awaitStrategy.getUrl(), (Matcher)CoreMatchers.is((Object)"http://localhost:8080/ping"));
        Assert.assertThat((Object)awaitStrategy.getResponseCode(), (Matcher)CoreMatchers.is((Object)201));
        Assert.assertThat((Object)awaitStrategy.getMatcher(), (Matcher)CoreMatchers.is((Object)"Server startup"));
        Assert.assertThat((Object)((String)awaitStrategy.getHeaders().get("X-Cube")), (Matcher)CoreMatchers.is((Object)"Docker"));
    }

    @Test
    public void should_be_able_to_create_custom_await_strategies() {
        Await await = new Await();
        await.setStrategy("org.arquillian.cube.docker.impl.await.CustomAwaitStrategyImpl");
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create((DockerClientExecutor)this.dockerClientExecutor, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(CustomAwaitStrategyInstantiator.class));
        CustomAwaitStrategyInstantiator customAwaitStrategyInstantiator = (CustomAwaitStrategyInstantiator)strategy;
        Assert.assertThat((Object)customAwaitStrategyInstantiator.await(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void should_create_static_await_strategy() {
        Await await = new Await();
        await.setStrategy("static");
        await.setIp("localhost");
        await.setPorts(Arrays.asList(8080, 8089));
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(StaticAwaitStrategy.class));
        StaticAwaitStrategy staticAwaitStrategy = (StaticAwaitStrategy)strategy;
        Assert.assertThat((Object)staticAwaitStrategy.getIp(), (Matcher)CoreMatchers.is((Object)"localhost"));
        Assert.assertThat(staticAwaitStrategy.getPorts().get(0), (Matcher)CoreMatchers.is((Object)8080));
        Assert.assertThat(staticAwaitStrategy.getPorts().get(1), (Matcher)CoreMatchers.is((Object)8089));
    }

    @Test
    public void should_create_static_await_strategy_without_defaults() {
        Await await = new Await();
        await.setStrategy("static");
        await.setIp("localhost");
        await.setPorts(Arrays.asList(8080, 8089));
        await.setSleepPollingTime((Object)200);
        await.setIterations(Integer.valueOf(3));
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(StaticAwaitStrategy.class));
        StaticAwaitStrategy staticAwaitStrategy = (StaticAwaitStrategy)strategy;
        Assert.assertThat((Object)staticAwaitStrategy.getIp(), (Matcher)CoreMatchers.is((Object)"localhost"));
        Assert.assertThat(staticAwaitStrategy.getPorts().get(0), (Matcher)CoreMatchers.is((Object)8080));
        Assert.assertThat(staticAwaitStrategy.getPorts().get(1), (Matcher)CoreMatchers.is((Object)8089));
        Assert.assertThat((Object)staticAwaitStrategy.getPollIterations(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)staticAwaitStrategy.getSleepTime(), (Matcher)CoreMatchers.is((Object)200));
    }

    @Test
    public void should_create_static_await_strategy_without_defaults_and_units() {
        Await await = new Await();
        await.setStrategy("static");
        await.setIp("localhost");
        await.setPorts(Arrays.asList(8080, 8089));
        await.setSleepPollingTime((Object)"200 s");
        await.setIterations(Integer.valueOf(3));
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(StaticAwaitStrategy.class));
        StaticAwaitStrategy staticAwaitStrategy = (StaticAwaitStrategy)strategy;
        Assert.assertThat((Object)staticAwaitStrategy.getIp(), (Matcher)CoreMatchers.is((Object)"localhost"));
        Assert.assertThat(staticAwaitStrategy.getPorts().get(0), (Matcher)CoreMatchers.is((Object)8080));
        Assert.assertThat(staticAwaitStrategy.getPorts().get(1), (Matcher)CoreMatchers.is((Object)8089));
        Assert.assertThat((Object)staticAwaitStrategy.getPollIterations(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)staticAwaitStrategy.getSleepTime(), (Matcher)CoreMatchers.is((Object)200));
        Assert.assertThat((Object)((Object)staticAwaitStrategy.getTimeUnit()), (Matcher)CoreMatchers.is((Object)((Object)TimeUnit.SECONDS)));
    }

    @Test
    public void should_create_polling_await_strategy_if_no_strategy_is_provided() {
        CubeContainer cubeContainer = new CubeContainer();
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(PollingAwaitStrategy.class));
    }

    @Test
    public void should_create_polling_await_strategy() {
        Await await = new Await();
        await.setStrategy("polling");
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(PollingAwaitStrategy.class));
    }

    @Test
    public void should_create_polling_await_strategy_with_specific_port() {
        Await await = new Await();
        await.setStrategy("polling");
        await.setPorts(Arrays.asList(80));
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(PollingAwaitStrategy.class));
        Assert.assertThat((Object)((PollingAwaitStrategy)strategy).getPorts(), (Matcher)CoreMatchers.hasItems((Object[])new Integer[]{80}));
    }

    @Test
    public void should_create_polling_await_strategy_with_specific_times() {
        Await await = new Await();
        await.setStrategy("polling");
        await.setSleepPollingTime((Object)200);
        await.setIterations(Integer.valueOf(3));
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(PollingAwaitStrategy.class));
        Assert.assertThat((Object)((PollingAwaitStrategy)strategy).getPollIterations(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((PollingAwaitStrategy)strategy).getSleepTime(), (Matcher)CoreMatchers.is((Object)200));
    }

    @Test
    public void should_create_sleeping_await_strategy_with_specific_times() {
        Await await = new Await();
        await.setStrategy("sleeping");
        await.setSleepTime((Object)"200 s");
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(SleepingAwaitStrategy.class));
        Assert.assertThat((Object)((SleepingAwaitStrategy)strategy).getSleepTime(), (Matcher)CoreMatchers.is((Object)200));
    }

    @Test
    public void should_create_polling_await_strategy_with_specific_times_and_unit() {
        Await await = new Await();
        await.setStrategy("polling");
        await.setSleepPollingTime((Object)"200 s");
        await.setIterations(Integer.valueOf(3));
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(PollingAwaitStrategy.class));
        Assert.assertThat((Object)((PollingAwaitStrategy)strategy).getPollIterations(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((PollingAwaitStrategy)strategy).getSleepTime(), (Matcher)CoreMatchers.is((Object)200));
        Assert.assertThat((Object)((Object)((PollingAwaitStrategy)strategy).getTimeUnit()), (Matcher)CoreMatchers.is((Object)((Object)TimeUnit.SECONDS)));
        Assert.assertThat((Object)((PollingAwaitStrategy)strategy).getType(), (Matcher)CoreMatchers.is((Object)"sscommand"));
    }

    @Test
    public void should_create_polling_await_strategy_with_specific_type() {
        Await await = new Await();
        await.setStrategy("polling");
        await.setType("sscommand");
        await.setSleepPollingTime((Object)"200 s");
        await.setIterations(Integer.valueOf(3));
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(PollingAwaitStrategy.class));
        Assert.assertThat((Object)((PollingAwaitStrategy)strategy).getType(), (Matcher)CoreMatchers.is((Object)"sscommand"));
    }

    @Test
    public void should_create_native_await_strategy() {
        Await await = new Await();
        await.setStrategy("native");
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(NativeAwaitStrategy.class));
    }

    @Test
    public void should_create_log_scanning_await_strategy() {
        Await await = new Await();
        await.setStrategy("log");
        await.setMatch("STARTED");
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(LogScanningAwaitStrategy.class));
        Assert.assertThat((Object)((LogScanningAwaitStrategy)strategy).getSleepTime(), (Matcher)CoreMatchers.is((Object)500));
        Assert.assertThat((Object)((Object)((LogScanningAwaitStrategy)strategy).getTimeUnit()), (Matcher)CoreMatchers.is((Object)((Object)TimeUnit.MILLISECONDS)));
        Assert.assertThat((Object)((LogScanningAwaitStrategy)strategy).getPollIterations(), (Matcher)CoreMatchers.is((Object)10));
        Assert.assertThat((Object)((LogScanningAwaitStrategy)strategy).isStdOut(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((LogScanningAwaitStrategy)strategy).isStdErr(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void should_create_log_scanning_await_strategy_without_defaults() {
        Await await = new Await();
        await.setStrategy("log");
        await.setMatch("regexp:.*STARTED.*");
        await.setStdOut(false);
        await.setStdErr(true);
        await.setIterations(Integer.valueOf(30));
        await.setSleepPollingTime((Object)"2s");
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(LogScanningAwaitStrategy.class));
        Assert.assertThat((Object)((LogScanningAwaitStrategy)strategy).getSleepTime(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Object)((LogScanningAwaitStrategy)strategy).getTimeUnit()), (Matcher)CoreMatchers.is((Object)((Object)TimeUnit.SECONDS)));
        Assert.assertThat((Object)((LogScanningAwaitStrategy)strategy).getPollIterations(), (Matcher)CoreMatchers.is((Object)30));
        Assert.assertThat((Object)((LogScanningAwaitStrategy)strategy).isStdOut(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)((LogScanningAwaitStrategy)strategy).isStdErr(), (Matcher)CoreMatchers.is((Object)true));
    }
}

