/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.client.DefinitionFormat;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.DockerCompositions;
import org.arquillian.cube.docker.impl.client.config.ExposedPort;
import org.arquillian.cube.docker.impl.client.config.Network;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CubeConfigurationTest {
    private static final String CONTENT = "tomcat:\n  image: tutum/tomcat:7.0\n  exposedPorts: [8089/tcp]\n  await:\n    strategy: static\n    ip: localhost\n    ports: [8080, 8089]";
    private static final String CONTENT2 = "tomcat2:\n  image: tutum/tomcat:7.0\n  exposedPorts: [8089/tcp]\n  await:\n    strategy: static\n    ip: localhost\n    ports: [8080, 8089]";
    private static final String DOCKER_COMPOSE_CONTENT = "web:\n  build: .\n  ports:\n   - \"5000:5000\"\n  volumes:\n   - .:/code\n  links:\n   - redis\nredis:\n  image: redis";
    private static final String OVERRIDE_CUSTOM = "tomcat:\n  image: tutum/tomcat:8.0\n  await:\n    strategy: polling\n  beforeStop: \n    - copy:\n        from: /test\n        to: /tmp";
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    @Test
    public void should_override_custom_cube_properties() throws IOException {
        File newFile = this.testFolder.newFile("config.yaml");
        Files.write(Paths.get(newFile.toURI()), CONTENT.getBytes(), new OpenOption[0]);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverVersion", "1.13");
        parameters.put("serverUri", "http://localhost:25123");
        parameters.put("dockerContainersFiles", newFile.toURI().toString());
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        parameters.put("cubeSpecificProperties", OVERRIDE_CUSTOM);
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        DockerCompositions dockerContainersContent = cubeConfiguration.getDockerContainersContent();
        CubeContainer tomcat = dockerContainersContent.get("tomcat");
        Assert.assertThat((Object)tomcat, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)tomcat.getImage().getTag(), (Matcher)CoreMatchers.is((Object)"7.0"));
        Assert.assertThat((Object)tomcat.getAwait().getStrategy(), (Matcher)CoreMatchers.is((Object)"polling"));
        Assert.assertThat((Object)tomcat.getBeforeStop().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void should_merge_more_than_one_file_into_one() throws IOException {
        File newFile = this.testFolder.newFile("config.yaml");
        Files.write(Paths.get(newFile.toURI()), CONTENT.getBytes(), new OpenOption[0]);
        File newFile2 = this.testFolder.newFile("config2.yaml");
        Files.write(Paths.get(newFile2.toURI()), CONTENT2.getBytes(), new OpenOption[0]);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverVersion", "1.13");
        parameters.put("serverUri", "http://localhost:25123");
        parameters.put("dockerContainersFiles", newFile.toURI().toString() + ", " + newFile2.toURI().toString());
        parameters.put("definitionFormat", DefinitionFormat.COMPOSE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        DockerCompositions dockerContainersContent = cubeConfiguration.getDockerContainersContent();
        Assert.assertThat((Object)dockerContainersContent.get("tomcat"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)dockerContainersContent.get("tomcat2"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void should_load_docker_compose_format() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverVersion", "1.13");
        parameters.put("serverUri", "http://localhost:25123");
        parameters.put("dockerContainers", DOCKER_COMPOSE_CONTENT);
        parameters.put("definitionFormat", DefinitionFormat.COMPOSE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        DockerCompositions dockerContainersContent = cubeConfiguration.getDockerContainersContent();
        CubeContainer actualWeb = dockerContainersContent.get("web");
        Assert.assertThat((Object)actualWeb.getBuildImage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)actualWeb.getPortBindings(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)actualWeb.getVolumes(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)actualWeb.getLinks(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        CubeContainer actualRedis = dockerContainersContent.get("redis");
        Assert.assertThat((Object)actualRedis.getImage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void should_load_cube_configuration_from_cube_file_if_no_file_is_provided() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverVersion", "1.13");
        parameters.put("serverUri", "http://localhost:25123");
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        DockerCompositions dockerContainersContent = cubeConfiguration.getDockerContainersContent();
        CubeContainer actualTomcat = dockerContainersContent.get("tomcat");
        Assert.assertThat((Object)actualTomcat, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        String image = actualTomcat.getImage().toImageRef();
        Assert.assertThat((Object)image, (Matcher)CoreMatchers.is((Object)"tomcat:7.0"));
    }

    @Test
    public void should_parse_and_load_configuration_file() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverVersion", "1.13");
        parameters.put("serverUri", "http://localhost:25123");
        parameters.put("dockerContainers", CONTENT);
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        Assert.assertThat((Object)cubeConfiguration.getDockerServerUri(), (Matcher)CoreMatchers.is((Object)"http://localhost:25123"));
        Assert.assertThat((Object)cubeConfiguration.getDockerServerVersion(), (Matcher)CoreMatchers.is((Object)"1.13"));
        DockerCompositions dockerContainersContent = cubeConfiguration.getDockerContainersContent();
        CubeContainer actualTomcat = dockerContainersContent.get("tomcat");
        Assert.assertThat((Object)actualTomcat, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        String image = actualTomcat.getImage().toImageRef();
        Assert.assertThat((Object)image, (Matcher)CoreMatchers.is((Object)"tutum/tomcat:7.0"));
    }

    @Test
    public void should_parse_and_load_configuration_file_from_container_configuration_file_and_property_set_file() throws IOException {
        File newFile = this.testFolder.newFile("config.yml");
        Files.write(Paths.get(newFile.toURI()), CONTENT.getBytes(), new OpenOption[0]);
        File newFile2 = this.testFolder.newFile("config.demo.yml");
        Files.write(Paths.get(newFile2.toURI()), CONTENT2.getBytes(), new OpenOption[0]);
        System.setProperty("cube.environment", "demo");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverVersion", "1.13");
        parameters.put("serverUri", "http://localhost:25123");
        parameters.put("dockerContainersFile", newFile.toURI().toString());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        Assert.assertThat((Object)cubeConfiguration.getDockerServerUri(), (Matcher)CoreMatchers.is((Object)"http://localhost:25123"));
        Assert.assertThat((Object)cubeConfiguration.getDockerServerVersion(), (Matcher)CoreMatchers.is((Object)"1.13"));
        DockerCompositions dockerContainersContent = cubeConfiguration.getDockerContainersContent();
        CubeContainer actualTomcat = dockerContainersContent.get("tomcat");
        Assert.assertThat((Object)actualTomcat, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        String image = actualTomcat.getImage().toImageRef();
        Assert.assertThat((Object)image, (Matcher)CoreMatchers.is((Object)"tutum/tomcat:7.0"));
        Assert.assertThat((Object)dockerContainersContent.get("tomcat2"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void should_parse_and_load_configuration_file_from_container_configuration_file() throws IOException {
        File newFile = this.testFolder.newFile("config.yaml");
        Files.write(Paths.get(newFile.toURI()), CONTENT.getBytes(), new OpenOption[0]);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverVersion", "1.13");
        parameters.put("serverUri", "http://localhost:25123");
        parameters.put("dockerContainersFile", newFile.toURI().toString());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        Assert.assertThat((Object)cubeConfiguration.getDockerServerUri(), (Matcher)CoreMatchers.is((Object)"http://localhost:25123"));
        Assert.assertThat((Object)cubeConfiguration.getDockerServerVersion(), (Matcher)CoreMatchers.is((Object)"1.13"));
        DockerCompositions dockerContainersContent = cubeConfiguration.getDockerContainersContent();
        CubeContainer actualTomcat = dockerContainersContent.get("tomcat");
        Assert.assertThat((Object)actualTomcat, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        String image = actualTomcat.getImage().toImageRef();
        Assert.assertThat((Object)image, (Matcher)CoreMatchers.is((Object)"tutum/tomcat:7.0"));
    }

    @Test
    public void should_be_able_to_extend_and_override_toplevel() throws Exception {
        String config = "tomcat6:\n  image: tutum/tomcat:6.0\n  exposedPorts: [8089/tcp]\n  await:\n    strategy: static\n    ip: localhost\n    ports: [8080, 8089]\ntomcat7:\n  extends: tomcat6\n  image: tutum/tomcat:7.0\n";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", config);
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        CubeContainer tomcat7 = cubeConfiguration.getDockerContainersContent().get("tomcat7");
        Assert.assertEquals((Object)"tutum/tomcat:7.0", (Object)tomcat7.getImage().toImageRef());
        Assert.assertTrue((tomcat7.getAwait() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"8089/tcp", (Object)((ExposedPort)tomcat7.getExposedPorts().iterator().next()).toString());
    }

    @Test
    public void should_be_able_to_read_network_configuration() {
        String config = "networks:\n  mynetwork:\n     driver: bridge\ntomcat6:\n  image: tutum/tomcat:6.0\n  exposedPorts: [8089/tcp]\n  await:\n    strategy: static\n    ip: localhost\n    ports: [8080, 8089]\ntomcat7:\n  extends: tomcat6\n  image: tutum/tomcat:7.0\n";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", config);
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        Network mynetwork = cubeConfiguration.getDockerContainersContent().getNetwork("mynetwork");
        Assert.assertThat((Object)mynetwork, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)mynetwork.getDriver(), (Matcher)CoreMatchers.is((Object)"bridge"));
    }

    @Test
    public void should_set_global_removeVolumes_option_if_not_set_on_container_level() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", CONTENT);
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        CubeContainer containerConfig = cubeConfiguration.getDockerContainersContent().get("tomcat");
        Assert.assertThat((Object)containerConfig.getRemoveVolumes(), (Matcher)CoreMatchers.is((Object)true));
        parameters.put("removeVolumes", "true");
        cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        containerConfig = cubeConfiguration.getDockerContainersContent().get("tomcat");
        Assert.assertThat((Object)containerConfig.getRemoveVolumes(), (Matcher)CoreMatchers.is((Object)true));
        parameters.put("removeVolumes", "false");
        cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        containerConfig = cubeConfiguration.getDockerContainersContent().get("tomcat");
        Assert.assertThat((Object)containerConfig.getRemoveVolumes(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void should_container_level_removeVolumes_option_overwrite_global_value() {
        String config1 = "tomcat:\n  image: tutum/tomcat:6.0\n  removeVolumes: false";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("removeVolumes", "true");
        parameters.put("dockerContainers", config1);
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        CubeContainer containerConfig = cubeConfiguration.getDockerContainersContent().get("tomcat");
        Assert.assertThat((Object)containerConfig.getRemoveVolumes(), (Matcher)CoreMatchers.is((Object)false));
        String config2 = "tomcat:\n  image: tutum/tomcat:6.0\n  removeVolumes: true";
        parameters.put("removeVolumes", "false");
        parameters.put("dockerContainers", config2);
        cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        containerConfig = cubeConfiguration.getDockerContainersContent().get("tomcat");
        Assert.assertThat((Object)containerConfig.getRemoveVolumes(), (Matcher)CoreMatchers.is((Object)true));
    }
}

