/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.container;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.arquillian.cube.docker.impl.client.container.DockerServerIPConfigurator;
import org.arquillian.cube.docker.impl.util.OperatingSystemFamily;
import org.arquillian.cube.impl.model.LocalCubeRegistry;
import org.arquillian.cube.impl.util.TestPortBindings;
import org.arquillian.cube.spi.Binding;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.metadata.HasPortBindings;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.event.container.BeforeSetup;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.test.AbstractManagerTestBase;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.yaml.snakeyaml.Yaml;

@RunWith(value=MockitoJUnitRunner.class)
public class DockerServerIPConfiguratorTest
extends AbstractManagerTestBase {
    public static final String CUBE_ID = "test";
    private static final String CONTENT = "image: tutum/tomcat:7.0\nexposedPorts: [8089/tcp]\nportBindings: [8090->8089/tcp]";
    @Mock
    private Cube cube;
    @Mock
    private Container container;
    @Mock
    private DeployableContainer deployableContainer;
    @Mock
    private ContainerRegistry containerRegistry;
    @Mock
    private ContainerDef containerDef;
    private CubeRegistry registry;

    protected void addExtensions(List<Class<?>> extensions) {
        extensions.add(DockerServerIPConfigurator.class);
        super.addExtensions(extensions);
    }

    @Before
    public void setup() {
        Yaml yaml = new Yaml();
        Map content = (Map)yaml.load(CONTENT);
        Mockito.when((Object)this.cube.getId()).thenReturn((Object)CUBE_ID);
        Mockito.when((Object)this.cube.configuration()).thenReturn((Object)content);
        Mockito.when((Object)this.container.getName()).thenReturn((Object)CUBE_ID);
        Mockito.when((Object)this.container.getDeployableContainer()).thenReturn((Object)this.deployableContainer);
        Mockito.when((Object)this.deployableContainer.getConfigurationClass()).thenReturn(ContainerConfiguration.class);
        Mockito.when((Object)this.container.getContainerConfiguration()).thenReturn((Object)this.containerDef);
        Mockito.when((Object)this.containerRegistry.getContainers()).thenReturn(Arrays.asList(this.container));
        this.registry = new LocalCubeRegistry();
        this.registry.addCube(this.cube);
        this.bind(ApplicationScoped.class, CubeRegistry.class, this.registry);
        this.bind(ApplicationScoped.class, ContainerRegistry.class, this.containerRegistry);
    }

    @Test
    public void shouldRemapContainerAddressToBootToDocker() {
        HashMap containerConfig = new HashMap();
        Mockito.when((Object)this.containerDef.getContainerProperties()).thenReturn(containerConfig);
        Mockito.when((Object)this.cube.getMetadata(HasPortBindings.class)).thenReturn((Object)new TestPortBindings(new Binding("192.168.0.1")));
        this.bind(ApplicationScoped.class, OperatingSystemFamily.class, OperatingSystemFamily.MAC);
        this.fire(new BeforeSetup(this.deployableContainer));
        ((ContainerDef)Mockito.verify((Object)this.containerDef)).overrideProperty("myHost", "192.168.0.1");
    }

    @Test
    public void shouldSubstituteDockerServerIpContainerAddressToBootToDockerIp() {
        HashMap<String, String> containerConfig = new HashMap<String, String>();
        containerConfig.put("myHost", "dockerServerIp");
        Mockito.when((Object)this.containerDef.getContainerProperties()).thenReturn(containerConfig);
        Mockito.when((Object)this.cube.getMetadata(HasPortBindings.class)).thenReturn((Object)new TestPortBindings(new Binding("192.168.0.1")));
        this.bind(ApplicationScoped.class, OperatingSystemFamily.class, OperatingSystemFamily.MAC);
        this.fire(new BeforeSetup(this.deployableContainer));
        ((ContainerDef)Mockito.verify((Object)this.containerDef)).overrideProperty("myHost", "192.168.0.1");
    }

    @Test
    public void shouldNotRemapContainerAddressToBootToDocker() {
        HashMap<String, String> containerConfig = new HashMap<String, String>();
        containerConfig.put("myHost", "10.0.10.1");
        Mockito.when((Object)this.containerDef.getContainerProperties()).thenReturn(containerConfig);
        Mockito.when((Object)this.cube.getMetadata(HasPortBindings.class)).thenReturn((Object)new TestPortBindings(new Binding("192.168.0.1")));
        this.bind(ApplicationScoped.class, OperatingSystemFamily.class, OperatingSystemFamily.MAC);
        this.fire(new BeforeSetup(this.deployableContainer));
        ((ContainerDef)Mockito.verify((Object)this.containerDef, (VerificationMode)Mockito.times((int)0))).overrideProperty("myHost", "192.168.0.1");
    }

    public static class ContainerConfiguration {
        private int port = 8089;
        private String myHost = "localhost";

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getMyHost() {
            return this.myHost;
        }

        public void setMyHost(String myHost) {
            this.myHost = myHost;
        }
    }
}

