/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.arquillian.cube.docker.impl.util.AbstractCliInternetAddressResolver;
import org.arquillian.cube.docker.impl.util.CommandLineExecutor;
import org.arquillian.cube.docker.impl.util.Machine;

public class DockerMachine
extends AbstractCliInternetAddressResolver {
    private static Logger log = Logger.getLogger(DockerMachine.class.getName());
    public static final String DOCKER_MACHINE_EXEC = "docker-machine";
    private static final Pattern IP_PATTERN = Pattern.compile("(?:\\d{1,3}\\.){3}\\d{1,3}");
    private String machineName;
    private boolean manuallyStarted = false;

    public DockerMachine(CommandLineExecutor commandLineExecutor) {
        super(commandLineExecutor);
    }

    @Override
    protected String[] getCommandArguments(String cliPathExec) {
        if (this.machineName == null) {
            throw new IllegalArgumentException("Machine Name cannot be null");
        }
        return new String[]{this.createDockerMachineCommand(cliPathExec), "ip", this.machineName};
    }

    @Override
    protected Pattern getIpPattern() {
        return IP_PATTERN;
    }

    public void setMachineName(String machineName) {
        this.machineName = machineName;
    }

    public boolean isManuallyStarted() {
        return this.manuallyStarted;
    }

    public void startDockerMachine(String cliPathExec, String machineName) {
        this.commandLineExecutor.execCommand(this.createDockerMachineCommand(cliPathExec), "start", machineName);
        this.manuallyStarted = true;
    }

    public void startDockerMachine(String machineName) {
        this.startDockerMachine(null, machineName);
    }

    public void stopDockerMachine(String cliPathExec, String machineName) {
        this.commandLineExecutor.execCommand(this.createDockerMachineCommand(cliPathExec), "stop", machineName);
        this.manuallyStarted = false;
    }

    public void stopDockerMachine(String machineName) {
        this.stopDockerMachine(null, machineName);
    }

    public boolean isDockerMachineInstalled(String cliPathExec) {
        try {
            this.commandLineExecutor.execCommand(this.createDockerMachineCommand(cliPathExec));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isDockerMachineInstalled() {
        return this.isDockerMachineInstalled(null);
    }

    public Set<Machine> list(String cliPathExec) {
        HashSet<Machine> machines = new HashSet<Machine>();
        List<String> output = this.commandLineExecutor.execCommandAsArray(this.createDockerMachineCommand(cliPathExec), "ls");
        Map<String, Index> headerIndex = this.calculateStartingFieldsIndex(output.get(0));
        for (String fields : output.subList(1, output.size())) {
            machines.add(this.parse(headerIndex, fields));
        }
        return machines;
    }

    public Set<Machine> list(String cliPathExec, String field, String value) {
        HashSet<Machine> machines = new HashSet<Machine>();
        List<String> output = this.commandLineExecutor.execCommandAsArray(this.createDockerMachineCommand(cliPathExec), "ls", "--filter", field + "=" + value);
        Map<String, Index> headerIndex = this.calculateStartingFieldsIndex(output.get(0));
        for (String fields : output.subList(1, output.size())) {
            machines.add(this.parse(headerIndex, fields));
        }
        return machines;
    }

    private Map<String, Index> calculateStartingFieldsIndex(String header) {
        HashMap<String, Index> headersIndex = new HashMap<String, Index>();
        String[] headers = header.split("\\s+");
        for (int i = 0; i < headers.length; ++i) {
            String currentHeader = headers[i];
            int firstIndex = header.indexOf(currentHeader);
            int lastIndex = i + 1 < headers.length ? header.indexOf(headers[i + 1]) - 1 : -1;
            headersIndex.put(currentHeader, new Index(firstIndex, lastIndex));
        }
        return headersIndex;
    }

    public Set<Machine> list() {
        return this.list(null);
    }

    public Set<Machine> list(String field, String value) {
        return this.list(null, field, value);
    }

    public void grantPermissionToDockerMachine(String machinePath) {
        List<String> chmod = this.commandLineExecutor.execCommandAsArray("chmod", "+x", machinePath);
        this.printOutput(chmod);
    }

    public void createMachine(String machinePath, String machineDriver, String machineName) {
        List<String> create = this.commandLineExecutor.execCommandAsArray(machinePath, "create", "--driver", machineDriver, machineName);
        this.printOutput(create);
    }

    private void printOutput(List<String> lines) {
        StringBuilder output = new StringBuilder();
        for (String line : lines) {
            output.append(line);
            output.append(System.lineSeparator());
        }
        log.info(output.toString());
    }

    private Machine parse(Map<String, Index> headersIndex, String output) {
        String name = this.resolveField(headersIndex.get("NAME"), output);
        String active = this.resolveField(headersIndex.get("ACTIVE"), output);
        String driver = this.resolveField(headersIndex.get("DRIVER"), output);
        String state = this.resolveField(headersIndex.get("STATE"), output);
        String url = this.resolveField(headersIndex.get("URL"), output);
        String swarm = this.resolveField(headersIndex.get("SWARM"), output);
        return new Machine(name, active, driver, state, url, swarm);
    }

    private String resolveField(Index index, String output) {
        if (index.getEndIndex() < 0) {
            if (index.getStartIndex() < 0) {
                return "";
            }
            return output.substring(index.getStartIndex(), output.length()).trim();
        }
        return output.substring(index.getStartIndex(), index.getEndIndex() + 1).trim();
    }

    private String createDockerMachineCommand(String dockerMachinePath) {
        return dockerMachinePath == null ? DOCKER_MACHINE_EXEC : dockerMachinePath;
    }

    private class Index {
        private int startIndex = -1;
        private int endIndex = -1;

        public Index(int startIndex, int endIndex) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }
    }
}

