/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.requirement;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.Version;
import com.github.dockerjava.core.DockerClientBuilder;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import org.arquillian.cube.docker.impl.client.CubeDockerConfigurationResolver;
import org.arquillian.cube.docker.impl.requirement.RequiresDocker;
import org.arquillian.cube.docker.impl.util.Boot2Docker;
import org.arquillian.cube.docker.impl.util.CommandLineExecutor;
import org.arquillian.cube.docker.impl.util.DockerMachine;
import org.arquillian.cube.docker.impl.util.OperatingSystemResolver;
import org.arquillian.cube.docker.impl.util.Top;
import org.arquillian.cube.spi.requirement.Requirement;
import org.arquillian.cube.spi.requirement.UnsatisfiedRequirementException;

public class DockerRequirement
implements Requirement<RequiresDocker> {
    private final CommandLineExecutor commandLineExecutor = new CommandLineExecutor();
    private final CubeDockerConfigurationResolver resolver = new CubeDockerConfigurationResolver(new Top(), new DockerMachine(this.commandLineExecutor), new Boot2Docker(this.commandLineExecutor), new OperatingSystemResolver().currentOperatingSystem().getFamily());

    public void check(RequiresDocker context) throws UnsatisfiedRequirementException {
        Map<String, String> config = this.resolver.resolve(new HashMap<String, String>());
        String serverUrl = config.get("serverUri");
        if (Strings.isNullOrEmpty((String)serverUrl)) {
            throw new UnsatisfiedRequirementException("Could not resolve the docker server url.");
        }
        if (!DockerRequirement.isDockerRunning(serverUrl)) {
            throw new UnsatisfiedRequirementException("No server is running on url:[" + serverUrl + "].");
        }
    }

    private static boolean isDockerRunning(String serverUrl) {
        return DockerRequirement.getDockerVersion(serverUrl) != null;
    }

    private static Version getDockerVersion(String serverUrl) {
        try {
            DockerClient client = DockerClientBuilder.getInstance((String)serverUrl).build();
            return (Version)client.versionCmd().exec();
        }
        catch (Exception e) {
            return null;
        }
    }
}

