/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.util.IOUtil;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.event.lifecycle.BeforeStop;
import org.jboss.arquillian.core.api.annotation.Observes;

public class BeforeStopContainerObserver {
    private static final String BEFORE_STOP = "beforeStop";
    private static final String COPY = "copy";
    private static final String LOG = "log";
    private static final String TO = "to";
    private static final String FROM = "from";
    private static final String FOLLOW = "follow";
    private static final String STDOUT = "stdout";
    private static final String STDERR = "stderr";
    private static final String TIMESTAMPS = "timestamps";
    private static final String TAIL = "tail";

    public void processCommands(@Observes BeforeStop beforeStop, CubeRegistry cubeRegistry, DockerClientExecutor dockerClientExecutor) throws IOException {
        Cube cube = cubeRegistry.getCube(beforeStop.getCubeId());
        Map configuration = cube.configuration();
        if (configuration.containsKey(BEFORE_STOP)) {
            List beforeStopConfiguration = (List)configuration.get(BEFORE_STOP);
            for (Map map : beforeStopConfiguration) {
                if (map.containsKey(COPY)) {
                    Map copyConfiguration = (Map)map.get(COPY);
                    this.executeCopyAction(dockerClientExecutor, beforeStop.getCubeId(), copyConfiguration);
                    continue;
                }
                if (!map.containsKey(LOG)) continue;
                Map logConfiguration = (Map)map.get(LOG);
                this.executeLogAction(dockerClientExecutor, beforeStop.getCubeId(), logConfiguration);
            }
        }
    }

    private void executeLogAction(DockerClientExecutor dockerClientExecutor, String containerId, Map<String, Object> configurationParameters) throws IOException {
        Path toPath;
        File toPathFile;
        String to = null;
        if (!configurationParameters.containsKey(TO)) {
            throw new IllegalArgumentException(String.format("to property is mandatory when getting logs from container %s.", containerId));
        }
        to = (String)configurationParameters.get(TO);
        boolean follow = false;
        boolean stderr = false;
        boolean stdout = false;
        boolean timestamps = false;
        int tail = -1;
        if (configurationParameters.containsKey(FOLLOW)) {
            follow = (Boolean)configurationParameters.get(FOLLOW);
        }
        if (configurationParameters.containsKey(STDOUT)) {
            stdout = (Boolean)configurationParameters.get(STDOUT);
        }
        if (configurationParameters.containsKey(STDERR)) {
            stderr = (Boolean)configurationParameters.get(STDERR);
        }
        if (configurationParameters.containsKey(TIMESTAMPS)) {
            timestamps = (Boolean)configurationParameters.get(TIMESTAMPS);
        }
        if (configurationParameters.containsKey(TAIL)) {
            tail = (Integer)configurationParameters.get(TAIL);
        }
        if ((toPathFile = (toPath = Paths.get(to, new String[0])).toFile()).exists() && toPathFile.isDirectory()) {
            throw new IllegalArgumentException(String.format("%s parameter should be a file in log operation but you set an already existing directory not a file.", TO));
        }
        Path toDirectory = toPath.getParent();
        Files.createDirectories(toDirectory, new FileAttribute[0]);
        dockerClientExecutor.copyLog(containerId, follow, stdout, stderr, timestamps, tail, new FileOutputStream(toPathFile));
    }

    private void executeCopyAction(DockerClientExecutor dockerClientExecutor, String containerId, Map<String, Object> configurationParameters) throws IOException {
        String to = null;
        String from = null;
        if (!configurationParameters.containsKey(TO) || !configurationParameters.containsKey(FROM)) {
            throw new IllegalArgumentException(String.format("to and from property is mandatory when copying files from container %s.", containerId));
        }
        to = (String)configurationParameters.get(TO);
        from = (String)configurationParameters.get(FROM);
        InputStream response = dockerClientExecutor.getFileOrDirectoryFromContainerAsTar(containerId, from);
        Path toPath = Paths.get(to, new String[0]);
        File toPathFile = toPath.toFile();
        if (toPathFile.exists() && toPathFile.isFile()) {
            throw new IllegalArgumentException(String.format("%s parameter should be a directory in copy operation but you set an already existing file not a directory. Check %s in your local directory because currently is a file.", TO, toPath.normalize().toString()));
        }
        Files.createDirectories(toPath, new FileAttribute[0]);
        IOUtil.untar(response, toPathFile);
    }
}

