/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.container;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.arquillian.cube.docker.impl.util.ContainerUtil;
import org.arquillian.cube.docker.impl.util.OperatingSystemFamily;
import org.arquillian.cube.spi.Binding;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeRegistry;
import org.jboss.arquillian.config.descriptor.api.ContainerDef;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.event.container.BeforeSetup;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class DockerServerIPConfigurator {
    private static final Pattern hostPattern = Pattern.compile("(?i:.*host.*)");
    private static final Pattern addressPattern = Pattern.compile("(?i:.*address.*)");
    private static final Pattern jmxPattern = Pattern.compile("(?i:.*jmx.*)");
    @Inject
    private Instance<OperatingSystemFamily> familyInstance;

    public void applyDockerServerIpChange(@Observes BeforeSetup event, CubeRegistry cubeRegistry, ContainerRegistry containerRegistry) throws InstantiationException, IllegalAccessException, MalformedURLException {
        Container container = ContainerUtil.getContainerByDeployableContainer(containerRegistry, event.getDeployableContainer());
        if (container == null) {
            return;
        }
        Cube cube = cubeRegistry.getCube(container.getName());
        if (cube == null) {
            return;
        }
        Binding binding = cube.configuredBindings();
        ContainerDef containerConfiguration = container.getContainerConfiguration();
        boolean foundAttribute = this.resolveConfigurationPropertiesWithDockerServerIp(containerConfiguration, binding);
        if (!foundAttribute) {
            Class configurationClass = container.getDeployableContainer().getConfigurationClass();
            List<PropertyDescriptor> configurationClassHostOrAddressFields = this.filterConfigurationClassPropertiesByHostOrAddressAttribute(configurationClass);
            for (PropertyDescriptor propertyDescriptor : configurationClassHostOrAddressFields) {
                containerConfiguration.overrideProperty(propertyDescriptor.getName(), binding.getIP());
            }
        }
    }

    private boolean resolveConfigurationPropertiesWithDockerServerIp(ContainerDef containerDef, Binding binding) {
        boolean foundAttribute = false;
        for (Map.Entry entry : containerDef.getContainerProperties().entrySet()) {
            if (!hostPattern.matcher((CharSequence)entry.getKey()).matches() && !addressPattern.matcher((CharSequence)entry.getKey()).matches()) continue;
            foundAttribute = true;
            if (!((String)entry.getValue()).contains("dockerServerIp")) continue;
            containerDef.overrideProperty((String)entry.getKey(), ((String)entry.getValue()).replaceAll("dockerServerIp", binding.getIP()));
        }
        return foundAttribute;
    }

    private List<PropertyDescriptor> filterConfigurationClassPropertiesByHostOrAddressAttribute(Class<?> configurationClass) {
        ArrayList<PropertyDescriptor> fields = new ArrayList<PropertyDescriptor>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = Introspector.getBeanInfo(configurationClass, Object.class).getPropertyDescriptors()) {
                String propertyName = propertyDescriptor.getName();
                if (!hostPattern.matcher(propertyName).matches() && !addressPattern.matcher(propertyName).matches() || jmxPattern.matcher(propertyName).matches()) continue;
                fields.add(propertyDescriptor);
            }
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e);
        }
        return fields;
    }
}

