/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.containerobject;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.arquillian.cube.CubeController;
import org.arquillian.cube.containerobject.Cube;
import org.arquillian.cube.containerobject.CubeDockerFile;
import org.arquillian.cube.containerobject.HostPort;
import org.arquillian.cube.containerobject.Image;
import org.arquillian.cube.containerobject.Link;
import org.arquillian.cube.docker.impl.client.config.BuildImage;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.PortBinding;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.model.DockerCube;
import org.arquillian.cube.docker.impl.util.ContainerObjectUtil;
import org.arquillian.cube.docker.impl.util.DockerFileUtil;
import org.arquillian.cube.impl.util.ReflectionUtil;
import org.arquillian.cube.spi.Binding;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.metadata.CubeMetadata;
import org.arquillian.cube.spi.metadata.IsContainerObject;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;

public class CubeContainerObjectTestEnricher
implements TestEnricher {
    private static final Logger logger = Logger.getLogger(CubeContainerObjectTestEnricher.class.getName());
    @Inject
    Instance<CubeRegistry> cubeRegistryInstance;
    @Inject
    Instance<ServiceLoader> serviceLoader;
    @Inject
    Instance<CubeController> cubeControllerInstance;
    @Inject
    Instance<DockerClientExecutor> dockerClientExecutorInstance;
    @Inject
    Instance<Injector> injectorInstance;

    public void enrich(Object testCase) {
        this.enrichAndReturnLinks(testCase);
    }

    private Set<String> enrichAndReturnLinks(Object testCase) {
        List cubeFields = ReflectionUtil.getFieldsWithAnnotation(testCase.getClass(), Cube.class);
        HashSet<String> links = new HashSet<String>();
        if (cubeFields.size() > 0) {
            for (Field cubeField : cubeFields) {
                try {
                    logger.fine(String.format("Creating Container Object for field %s", cubeField.getName()));
                    links.add(this.enrichField(testCase, cubeField));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        return links;
    }

    private String enrichField(Object testCase, Field field) throws IllegalAccessException, IOException, InvocationTargetException {
        Object cubeContainerObject = field.get(testCase);
        if (cubeContainerObject == null) {
            Cube cubeAnnotation = field.getAnnotation(Cube.class);
            Class<?> cubeContainerClazz = field.getType();
            String cubeName = this.getCubeName(cubeAnnotation, cubeContainerClazz);
            String[] cubePortBinding = this.getPortBindings(cubeAnnotation, cubeContainerClazz);
            List methodsWithCubeDockerFile = ReflectionUtil.getMethodsWithAnnotation(cubeContainerClazz, CubeDockerFile.class);
            if (methodsWithCubeDockerFile.size() > 1) {
                throw new IllegalArgumentException(String.format("More than one %s annotation found and only one was expected. Methods where %s was found are; %s", CubeDockerFile.class.getSimpleName(), CubeDockerFile.class.getSimpleName(), methodsWithCubeDockerFile));
            }
            if ((methodsWithCubeDockerFile.size() == 1 || cubeContainerClazz.isAnnotationPresent(CubeDockerFile.class)) && cubeContainerClazz.isAnnotationPresent(Image.class)) {
                throw new IllegalArgumentException(String.format("Container Object %s has defined %s annotation and %s annotation together.", cubeContainerClazz.getSimpleName(), Image.class.getSimpleName(), CubeDockerFile.class.getSimpleName()));
            }
            File output = null;
            boolean imageSet = false;
            CubeDockerFile cubeContainerClazzAnnotation = null;
            if (methodsWithCubeDockerFile.size() == 1) {
                Method annotatedMethodWithCubeDockerFile = (Method)methodsWithCubeDockerFile.get(0);
                cubeContainerClazzAnnotation = annotatedMethodWithCubeDockerFile.getAnnotation(CubeDockerFile.class);
                Object archive = annotatedMethodWithCubeDockerFile.invoke(null, new Object[0]);
                if (archive instanceof Archive) {
                    Archive genericArchive = (Archive)archive;
                    output = this.createTemporalDirectoryForCopyingDockerfile(cubeContainerClazz, cubeName);
                    logger.finer(String.format("Created %s directory for storing contents of %s cube.", output, cubeName));
                    ((ExplodedExporter)genericArchive.as(ExplodedExporter.class)).exportExplodedInto(output);
                }
            } else if (cubeContainerClazz.isAnnotationPresent(CubeDockerFile.class)) {
                cubeContainerClazzAnnotation = cubeContainerClazz.getAnnotation(CubeDockerFile.class);
                output = this.createTemporalDirectoryForCopyingDockerfile(cubeContainerClazz, cubeName);
                logger.finer(String.format("Created %s directory for storing contents of %s cube.", output, cubeName));
                DockerFileUtil.copyDockerfileDirectory(cubeContainerClazz, cubeContainerClazzAnnotation, output);
            } else {
                if (!cubeContainerClazz.isAnnotationPresent(Image.class)) {
                    throw new IllegalArgumentException(String.format("Test class %s has a ContainerObject %s that is not annotated with %s or %s annotation.", testCase.getClass().getName(), cubeContainerClazz.getName(), CubeDockerFile.class.getSimpleName(), Image.class.getSimpleName()));
                }
                imageSet = true;
            }
            Object containerObjectInstance = ReflectionUtil.newInstance((String)cubeContainerClazz.getName(), (Class[])new Class[0], (Object[])new Class[0], cubeContainerClazz);
            this.enrichContainerObject(containerObjectInstance);
            field.set(testCase, containerObjectInstance);
            Set<String> links = this.enrichAndReturnLinks(containerObjectInstance);
            org.arquillian.cube.spi.Cube<?> cube = imageSet ? this.createCubeFromImage(cubeName, cubePortBinding, links, cubeContainerClazz.getAnnotation(Image.class), output, testCase.getClass()) : this.createCubeFromDockerfile(cubeName, cubePortBinding, links, cubeContainerClazzAnnotation, output, testCase.getClass());
            logger.finer(String.format("Created Cube with name %s and configuration %s", cubeName, cube.configuration()));
            ((CubeRegistry)this.cubeRegistryInstance.get()).addCube(cube);
            CubeController cubeController = (CubeController)this.cubeControllerInstance.get();
            cubeController.create(cubeName);
            cubeController.start(cubeName);
            this.enrichHostPort(containerObjectInstance, cube);
            return this.link(field, cubeName);
        }
        return null;
    }

    private void enrichHostPort(Object containerObjectInstance, org.arquillian.cube.spi.Cube<?> cube) throws IllegalAccessException {
        List fieldsWithHostPort = ReflectionUtil.getFieldsWithAnnotation(containerObjectInstance.getClass(), HostPort.class);
        for (Field field : fieldsWithHostPort) {
            HostPort hostPort = field.getAnnotation(HostPort.class);
            int hostPortValue = hostPort.value();
            if (hostPortValue > 0) {
                Binding.PortBinding bindingForExposedPort = cube.bindings().getBindingForExposedPort(Integer.valueOf(hostPortValue));
                if (bindingForExposedPort != null && bindingForExposedPort.getBindingPort() != -1) {
                    field.set(containerObjectInstance, bindingForExposedPort.getBindingPort());
                    continue;
                }
                throw new IllegalArgumentException(String.format("Container Object %s contains field %s annotated with %s but exposed port %s is not exposed on container object.", containerObjectInstance.getClass().getSimpleName(), field.getName(), HostPort.class.getSimpleName(), hostPortValue));
            }
            throw new IllegalArgumentException(String.format("Container Object %s contains field %s annotated with %s but do not specify any exposed port", containerObjectInstance.getClass().getSimpleName(), field.getName(), HostPort.class.getSimpleName()));
        }
    }

    private String link(Field field, String cubeName) {
        if (field.isAnnotationPresent(Link.class)) {
            return field.getAnnotation(Link.class).value();
        }
        return cubeName + ":" + cubeName;
    }

    private String getCubeName(Cube fieldAnnotation, Class<?> cubeContainerClass) {
        String cubeName = fieldAnnotation.value();
        if (!"".equals(cubeName)) {
            return cubeName;
        }
        String value = ContainerObjectUtil.getTopCubeAttribute(cubeContainerClass, "value", Cube.class, "");
        if (value != null && !"".equals(value)) {
            return value;
        }
        return cubeContainerClass.getSimpleName();
    }

    private String[] getPortBindings(Cube fieldAnnotation, Class<?> cubeContainerClass) {
        Object[] portBindings = fieldAnnotation.portBinding();
        if (!Arrays.equals(portBindings, Cube.DEFAULT_PORT_BINDING)) {
            return portBindings;
        }
        Object[] portBinding = ContainerObjectUtil.getTopCubeAttribute(cubeContainerClass, "portBinding", Cube.class, Cube.DEFAULT_PORT_BINDING);
        if (portBinding != null && !Arrays.equals(portBinding, Cube.DEFAULT_PORT_BINDING)) {
            return portBinding;
        }
        return Cube.DEFAULT_PORT_BINDING;
    }

    private void enrichContainerObject(Object containerObjectInstance) {
        Collection testEnrichers = ((ServiceLoader)this.serviceLoader.get()).all(TestEnricher.class);
        for (TestEnricher testEnricher : testEnrichers) {
            if (testEnricher == this) continue;
            testEnricher.enrich(containerObjectInstance);
        }
    }

    private org.arquillian.cube.spi.Cube<?> createCubeFromDockerfile(String cubeName, String[] portBinding, Set<String> links, CubeDockerFile cubeContainerClazzAnnotation, File dockerfileLocation, Class<?> testClass) {
        CubeContainer configuration = this.createConfigurationFromDockerfie(portBinding, links, cubeContainerClazzAnnotation, dockerfileLocation);
        DockerCube newCube = new DockerCube(cubeName, configuration, (DockerClientExecutor)this.dockerClientExecutorInstance.get());
        newCube.addMetadata(IsContainerObject.class, (CubeMetadata)new IsContainerObject(testClass));
        ((Injector)this.injectorInstance.get()).inject((Object)newCube);
        return newCube;
    }

    private org.arquillian.cube.spi.Cube<?> createCubeFromImage(String cubeName, String[] portBinding, Set<String> links, Image image, File dockerfileLocation, Class<?> testClass) {
        CubeContainer configuration = this.createConfigurationFromImage(portBinding, links, image, dockerfileLocation);
        DockerCube newCube = new DockerCube(cubeName, configuration, (DockerClientExecutor)this.dockerClientExecutorInstance.get());
        newCube.addMetadata(IsContainerObject.class, (CubeMetadata)new IsContainerObject(testClass));
        ((Injector)this.injectorInstance.get()).inject((Object)newCube);
        return newCube;
    }

    private CubeContainer createConfigurationFromDockerfie(String[] portBinding, Set<String> links, CubeDockerFile cubeContainerClazzAnnotation, File dockerfileLocation) {
        CubeContainer configuration = new CubeContainer();
        ArrayList<PortBinding> bindings = new ArrayList<PortBinding>();
        for (String binding : portBinding) {
            bindings.add(PortBinding.valueOf(binding));
        }
        configuration.setPortBindings(bindings);
        if (links.size() > 0) {
            configuration.setLinks(org.arquillian.cube.docker.impl.client.config.Link.valuesOf(links));
        }
        BuildImage dockerfileConfiguration = new BuildImage(dockerfileLocation.getAbsolutePath(), null, cubeContainerClazzAnnotation.nocache(), cubeContainerClazzAnnotation.remove());
        configuration.setBuildImage(dockerfileConfiguration);
        return configuration;
    }

    private CubeContainer createConfigurationFromImage(String[] portBinding, Set<String> links, Image image, File dockerfileLocation) {
        CubeContainer configuration = new CubeContainer();
        ArrayList<PortBinding> bindings = new ArrayList<PortBinding>();
        for (String binding : portBinding) {
            bindings.add(PortBinding.valueOf(binding));
        }
        configuration.setPortBindings(bindings);
        if (links.size() > 0) {
            configuration.setLinks(org.arquillian.cube.docker.impl.client.config.Link.valuesOf(links));
        }
        configuration.setImage(org.arquillian.cube.docker.impl.client.config.Image.valueOf(image.value()));
        return configuration;
    }

    private File createTemporalDirectoryForCopyingDockerfile(Class<?> cubeContainerClazz, String id) throws IOException {
        File dir = File.createTempFile(cubeContainerClazz.getSimpleName(), id);
        dir.delete();
        if (!dir.mkdirs()) {
            throw new IllegalArgumentException("Temp Dir for storing Dockerfile contents could not be created.");
        }
        dir.deleteOnExit();
        return dir;
    }

    public Object[] resolve(Method method) {
        return new Object[0];
    }
}

