/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.arquillian.cube.containerobject.CubeDockerFile;
import org.arquillian.cube.impl.util.Which;

public class DockerFileUtil {
    private DockerFileUtil() {
    }

    public static void copyDockerfileDirectory(Class<?> containerObject, CubeDockerFile cubeDockerFile, File output) throws IOException {
        if (cubeDockerFile == null) {
            throw new IllegalArgumentException("No CubeDockerFile annotation is provided");
        }
        String dockerfilePath = DockerFileUtil.resolveDockerfileLocation(containerObject, cubeDockerFile);
        DockerFileUtil.copyDockerfileDirectoryFromClasspath(containerObject, dockerfilePath, output);
    }

    private static File createTemporaryFolder(Class<?> containerObject) throws IOException {
        File dir = File.createTempFile(containerObject.getSimpleName(), "Dockerfile");
        dir.delete();
        if (!dir.mkdirs()) {
            throw new IllegalStateException(String.format("Directory %s for storing Dockerfile cannot be created.", dir));
        }
        return dir;
    }

    private static String resolveDockerfileLocation(Class<?> containerObject, CubeDockerFile cubeDockerFile) {
        String prefix = null;
        prefix = DockerFileUtil.isSpecificDockerfileLocationSet(cubeDockerFile) ? cubeDockerFile.value() : containerObject.getName();
        return prefix.replace('.', '/').replace('$', '/');
    }

    private static boolean isSpecificDockerfileLocationSet(CubeDockerFile cubeDockerFile) {
        return !cubeDockerFile.value().isEmpty();
    }

    private static void copyDockerfileDirectoryFromClasspath(Class<?> containerObject, String dockerfileLocation, File dir) throws IOException {
        File jar = null;
        try {
            jar = Which.jarFile(containerObject);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
        if (jar != null && jar.isFile()) {
            dockerfileLocation = dockerfileLocation + "/";
            DockerFileUtil.copyDockerfileDirectoryFromPackaged(jar, dockerfileLocation, dir);
        } else {
            DockerFileUtil.copyDockerfileDirectoryFromLocal(dockerfileLocation, dir);
        }
    }

    private static void copyDockerfileDirectoryFromPackaged(File jar, String location, File outputDirectory) throws IOException {
        try (JarFile j = new JarFile(jar);){
            Enumeration<JarEntry> e = j.entries();
            while (e.hasMoreElements()) {
                JarEntry je = e.nextElement();
                if (!je.getName().startsWith(location)) continue;
                File dst = new File(outputDirectory, je.getName().substring(location.length()));
                if (je.isDirectory()) {
                    dst.mkdirs();
                    continue;
                }
                InputStream in = j.getInputStream(je);
                Throwable throwable = null;
                try {
                    Files.copy(in, Paths.get(dst.toURI()), new CopyOption[0]);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
    }

    private static void copyDockerfileDirectoryFromLocal(String location, File outputDirectory) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL resourceDir = classLoader.getResource(location);
        if (resourceDir == null) {
            throw new IllegalArgumentException(String.format("No location found at %s", location));
        }
        DockerFileUtil.copyFile(outputDirectory, resourceDir);
    }

    private static void copyFile(File outputDirectory, URL resourceDir) throws IOException {
        File dockerFileDir;
        try {
            dockerFileDir = new File(resourceDir.toURI());
        }
        catch (URISyntaxException e) {
            dockerFileDir = new File(resourceDir.getPath());
        }
        FileUtils.copyDirectory((File)dockerFileDir, (File)outputDirectory);
    }
}

