/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.await;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.arquillian.cube.docker.impl.await.AwaitStrategy;
import org.arquillian.cube.docker.impl.await.AwaitStrategyFactory;
import org.arquillian.cube.docker.impl.await.NativeAwaitStrategy;
import org.arquillian.cube.docker.impl.await.PollingAwaitStrategy;
import org.arquillian.cube.docker.impl.await.SleepingAwaitStrategy;
import org.arquillian.cube.docker.impl.await.StaticAwaitStrategy;
import org.arquillian.cube.docker.impl.client.config.Await;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.spi.Cube;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AwaitStrategyTest {
    @Mock
    private Cube<?> cube;

    @Test
    public void should_create_static_await_strategy() {
        Await await = new Await();
        await.setStrategy("static");
        await.setIp("localhost");
        await.setPorts(Arrays.asList(8080, 8089));
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(StaticAwaitStrategy.class));
        StaticAwaitStrategy staticAwaitStrategy = (StaticAwaitStrategy)strategy;
        Assert.assertThat((Object)staticAwaitStrategy.getIp(), (Matcher)CoreMatchers.is((Object)"localhost"));
        Assert.assertThat(staticAwaitStrategy.getPorts().get(0), (Matcher)CoreMatchers.is((Object)8080));
        Assert.assertThat(staticAwaitStrategy.getPorts().get(1), (Matcher)CoreMatchers.is((Object)8089));
    }

    @Test
    public void should_create_static_await_strategy_without_defaults() {
        Await await = new Await();
        await.setStrategy("static");
        await.setIp("localhost");
        await.setPorts(Arrays.asList(8080, 8089));
        await.setSleepPollingTime((Object)200);
        await.setIterations(Integer.valueOf(3));
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(StaticAwaitStrategy.class));
        StaticAwaitStrategy staticAwaitStrategy = (StaticAwaitStrategy)strategy;
        Assert.assertThat((Object)staticAwaitStrategy.getIp(), (Matcher)CoreMatchers.is((Object)"localhost"));
        Assert.assertThat(staticAwaitStrategy.getPorts().get(0), (Matcher)CoreMatchers.is((Object)8080));
        Assert.assertThat(staticAwaitStrategy.getPorts().get(1), (Matcher)CoreMatchers.is((Object)8089));
        Assert.assertThat((Object)staticAwaitStrategy.getPollIterations(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)staticAwaitStrategy.getSleepPollTime(), (Matcher)CoreMatchers.is((Object)200));
    }

    @Test
    public void should_create_static_await_strategy_without_defaults_and_units() {
        Await await = new Await();
        await.setStrategy("static");
        await.setIp("localhost");
        await.setPorts(Arrays.asList(8080, 8089));
        await.setSleepPollingTime((Object)"200 s");
        await.setIterations(Integer.valueOf(3));
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(StaticAwaitStrategy.class));
        StaticAwaitStrategy staticAwaitStrategy = (StaticAwaitStrategy)strategy;
        Assert.assertThat((Object)staticAwaitStrategy.getIp(), (Matcher)CoreMatchers.is((Object)"localhost"));
        Assert.assertThat(staticAwaitStrategy.getPorts().get(0), (Matcher)CoreMatchers.is((Object)8080));
        Assert.assertThat(staticAwaitStrategy.getPorts().get(1), (Matcher)CoreMatchers.is((Object)8089));
        Assert.assertThat((Object)staticAwaitStrategy.getPollIterations(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)staticAwaitStrategy.getSleepPollTime(), (Matcher)CoreMatchers.is((Object)200));
        Assert.assertThat((Object)((Object)staticAwaitStrategy.getTimeUnit()), (Matcher)CoreMatchers.is((Object)((Object)TimeUnit.SECONDS)));
    }

    @Test
    public void should_create_native_await_strategy_if_no_strategy_is_provided() {
        CubeContainer cubeContainer = new CubeContainer();
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(PollingAwaitStrategy.class));
    }

    @Test
    public void should_create_polling_await_strategy() {
        Await await = new Await();
        await.setStrategy("polling");
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(PollingAwaitStrategy.class));
    }

    @Test
    public void should_create_polling_await_strategy_with_specific_port() {
        Await await = new Await();
        await.setStrategy("polling");
        await.setPorts(Arrays.asList(80));
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(PollingAwaitStrategy.class));
        Assert.assertThat((Object)((PollingAwaitStrategy)strategy).getPorts(), (Matcher)CoreMatchers.hasItems((Object[])new Integer[]{80}));
    }

    @Test
    public void should_create_polling_await_strategy_with_specific_times() {
        Await await = new Await();
        await.setStrategy("polling");
        await.setSleepPollingTime((Object)200);
        await.setIterations(Integer.valueOf(3));
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(PollingAwaitStrategy.class));
        Assert.assertThat((Object)((PollingAwaitStrategy)strategy).getPollIterations(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((PollingAwaitStrategy)strategy).getSleepPollTime(), (Matcher)CoreMatchers.is((Object)200));
    }

    @Test
    public void should_create_sleeping_await_strategy_with_specific_times() {
        Await await = new Await();
        await.setStrategy("sleeping");
        await.setSleepTime((Object)"200 s");
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(SleepingAwaitStrategy.class));
        Assert.assertThat((Object)((SleepingAwaitStrategy)strategy).getSleepTime(), (Matcher)CoreMatchers.is((Object)200));
    }

    @Test
    public void should_create_polling_await_strategy_with_specific_times_and_unit() {
        Await await = new Await();
        await.setStrategy("polling");
        await.setSleepPollingTime((Object)"200 s");
        await.setIterations(Integer.valueOf(3));
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(PollingAwaitStrategy.class));
        Assert.assertThat((Object)((PollingAwaitStrategy)strategy).getPollIterations(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((PollingAwaitStrategy)strategy).getSleepPollTime(), (Matcher)CoreMatchers.is((Object)200));
        Assert.assertThat((Object)((Object)((PollingAwaitStrategy)strategy).getTimeUnit()), (Matcher)CoreMatchers.is((Object)((Object)TimeUnit.SECONDS)));
        Assert.assertThat((Object)((PollingAwaitStrategy)strategy).getType(), (Matcher)CoreMatchers.is((Object)"sscommand"));
    }

    @Test
    public void should_create_polling_await_strategy_with_specific_type() {
        Await await = new Await();
        await.setStrategy("polling");
        await.setType("sscommand");
        await.setSleepPollingTime((Object)"200 s");
        await.setIterations(Integer.valueOf(3));
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(PollingAwaitStrategy.class));
        Assert.assertThat((Object)((PollingAwaitStrategy)strategy).getType(), (Matcher)CoreMatchers.is((Object)"sscommand"));
    }

    @Test
    public void should_create_native_await_strategy() {
        Await await = new Await();
        await.setStrategy("native");
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setAwait(await);
        AwaitStrategy strategy = AwaitStrategyFactory.create(null, this.cube, (CubeContainer)cubeContainer);
        Assert.assertThat((Object)strategy, (Matcher)CoreMatchers.instanceOf(NativeAwaitStrategy.class));
    }
}

