/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.config;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;

public class CubeContainers {
    private static final Logger logger = Logger.getLogger(CubeContainers.class.getName());
    private Map<String, CubeContainer> containers = new LinkedHashMap<String, CubeContainer>();

    public Map<String, CubeContainer> getContainers() {
        return this.containers;
    }

    public Set<String> getContainerIds() {
        return this.containers.keySet();
    }

    public void setContainers(Map<String, CubeContainer> containers) {
        this.containers = containers;
    }

    public CubeContainer get(String id) {
        return this.containers.get(id);
    }

    public void add(String id, CubeContainer container) {
        this.containers.put(id, container);
    }

    public void merge(CubeContainers otherContainers) {
        for (Map.Entry<String, CubeContainer> thisContainer : this.containers.entrySet()) {
            if (otherContainers.get(thisContainer.getKey()) == null) continue;
            thisContainer.getValue().merge(otherContainers.get(thisContainer.getKey()));
        }
        HashMap<String, CubeContainer> addAll = new HashMap<String, CubeContainer>();
        for (Map.Entry<String, CubeContainer> otherContainer : otherContainers.getContainers().entrySet()) {
            if (this.get(otherContainer.getKey()) != null) continue;
            addAll.put(otherContainer.getKey(), otherContainer.getValue());
        }
        this.containers.putAll(addAll);
    }

    public void overrideCubeProperties(CubeContainers overrideCubeContainers) {
        Set<String> containerIds = overrideCubeContainers.getContainerIds();
        for (String containerId : containerIds) {
            if (this.containers.containsKey(containerId)) {
                CubeContainer cubeContainer = this.containers.get(containerId);
                CubeContainer overrideCubeContainer = overrideCubeContainers.get(containerId);
                if (overrideCubeContainer.hasAwait()) {
                    cubeContainer.setAwait(overrideCubeContainer.getAwait());
                }
                if (!overrideCubeContainer.hasBeforeStop()) continue;
                cubeContainer.setBeforeStop(overrideCubeContainer.getBeforeStop());
                continue;
            }
            logger.warning(String.format("Overriding Container %s are not defined in main definition of containers.", new Object[0]));
        }
    }
}

