/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.containerobject;

import java.util.List;
import java.util.logging.Logger;
import org.arquillian.cube.CubeController;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.metadata.IsContainerObject;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;

public class AfterClassContainerObjectObserver {
    private static final Logger logger = Logger.getLogger(AfterClassContainerObjectObserver.class.getName());
    @Inject
    Instance<CubeRegistry> cubeRegistryInstance;
    @Inject
    Instance<CubeController> cubeControllerInstance;

    public void stopContainerObjects(@Observes AfterClass afterClass) {
        CubeController cubeController = (CubeController)this.cubeControllerInstance.get();
        List byMetadata = ((CubeRegistry)this.cubeRegistryInstance.get()).getByMetadata(IsContainerObject.class);
        for (Cube cube : byMetadata) {
            Class testJavaClass = afterClass.getTestClass().getJavaClass();
            if (!testJavaClass.equals(((IsContainerObject)cube.getMetadata(IsContainerObject.class)).getTestClass())) continue;
            logger.fine(String.format("Stopping Container Object %s", cube.getId()));
            cubeController.stop(cube.getId());
            cubeController.destroy(cube.getId());
            ((CubeRegistry)this.cubeRegistryInstance.get()).removeCube(cube.getId());
        }
    }
}

