/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.docker.compose;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import org.arquillian.cube.docker.impl.client.config.BuildImage;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.Device;
import org.arquillian.cube.docker.impl.client.config.ExposedPort;
import org.arquillian.cube.docker.impl.client.config.Image;
import org.arquillian.cube.docker.impl.client.config.Link;
import org.arquillian.cube.docker.impl.client.config.PortBinding;
import org.arquillian.cube.docker.impl.client.config.RestartPolicy;
import org.arquillian.cube.docker.impl.util.YamlUtil;
import org.yaml.snakeyaml.Yaml;

public class ContainerBuilder {
    private static final String IMAGE = "image";
    private static final String BUILD = "build";
    private static final String COMMAND = "command";
    private static final String LINKS = "links";
    private static final String EXTERNAL_LINKS = "external_links";
    private static final String LABELS = "labels";
    private static final String LOG_DRIVER = "log_driver";
    private static final String SECURITY_OPT = "security_opt";
    private static final String DOCKERFILE = "dockerfile";
    private static final String READ_ONLY = "read_only";
    private static final String EXTENDS = "extends";
    private static final String PORTS = "ports";
    private static final String EXPOSE = "expose";
    private static final String VOLUMES = "volumes";
    private static final String VOLUMES_FROM = "volumes_from";
    private static final String ENVIRONMENT = "environment";
    private static final String ENV_FILE = "env_file";
    private static final String NET = "net";
    private static final String DNS = "dns";
    private static final String CAP_ADD = "cap_add";
    private static final String CAP_DROP = "cap_drop";
    private static final String DNS_SEARCH = "dns_search";
    private static final String WORKING_DIR = "working_dir";
    private static final String ENTRYPOINT = "entrypoint";
    private static final String PID = "pid";
    private static final String USER = "user";
    private static final String HOSTNAME = "hostname";
    private static final String DOMAINNAME = "domainname";
    private static final String MEM_LIMIT = "mem_limit";
    private static final String PRIVILEGED = "privileged";
    private static final String RESTART = "restart";
    private static final String STDIN_OPEN = "stdin_open";
    private static final String TTY = "tty";
    private static final String CPU_SHARES = "cpu_shares";
    private static final String CPU_SET = "cpuset";
    private static final String EXTRA_HOSTS = "extra_hosts";
    private static final String DEVICES = "devices";
    private static List<String> AVAILABLE_COMMANDS = Arrays.asList("image", "build", "command", "links", "external_links", "dockerfile", "extends", "ports", "expose", "volumes", "volumes_from", "environment", "env_file", "net", "dns", "cap_add", "cap_drop", "dns_search", "working_dir", "entrypoint", "user", "hostname", "mem_limit", "privileged", "restart", "stdin_open", "tty", "cpuset", "cpu_shares", "extra_hosts", "devices");
    private static final Logger log = Logger.getLogger(ContainerBuilder.class.getName());
    private Random random = new Random();
    private CubeContainer configuration;
    private Path dockerComposeRootLocation;

    public ContainerBuilder(Path dockerComposeRootLocation) {
        this(dockerComposeRootLocation, new CubeContainer());
    }

    protected ContainerBuilder(Path dockerComposeRootLocation, CubeContainer configuration) {
        this.dockerComposeRootLocation = dockerComposeRootLocation;
        this.configuration = configuration;
    }

    public CubeContainer build(Map<String, Object> dockerComposeContainerDefinition) {
        Object dns;
        if (dockerComposeContainerDefinition.containsKey(EXTENDS)) {
            Map<String, Object> extendsDefinition = YamlUtil.asMap(dockerComposeContainerDefinition, EXTENDS);
            this.extend(Paths.get(YamlUtil.asString(extendsDefinition, "file"), new String[0]), YamlUtil.asString(extendsDefinition, "service"));
        }
        if (dockerComposeContainerDefinition.containsKey(IMAGE)) {
            this.addImage(YamlUtil.asString(dockerComposeContainerDefinition, IMAGE));
        }
        if (dockerComposeContainerDefinition.containsKey(BUILD)) {
            String dockerfile = dockerComposeContainerDefinition.containsKey(DOCKERFILE) ? YamlUtil.asString(dockerComposeContainerDefinition, DOCKERFILE) : null;
            this.addBuild(YamlUtil.asString(dockerComposeContainerDefinition, BUILD), dockerfile);
        }
        if (dockerComposeContainerDefinition.containsKey(COMMAND)) {
            this.addCommand(YamlUtil.asString(dockerComposeContainerDefinition, COMMAND));
        }
        if (dockerComposeContainerDefinition.containsKey(LINKS)) {
            this.addLinks(YamlUtil.asListOfString(dockerComposeContainerDefinition, LINKS));
        }
        if (dockerComposeContainerDefinition.containsKey(EXTERNAL_LINKS)) {
            this.addLinks(YamlUtil.asListOfString(dockerComposeContainerDefinition, EXTERNAL_LINKS));
        }
        if (dockerComposeContainerDefinition.containsKey(PORTS)) {
            this.addPorts(YamlUtil.asListOfString(dockerComposeContainerDefinition, PORTS));
        }
        if (dockerComposeContainerDefinition.containsKey(EXPOSE)) {
            this.addExpose(YamlUtil.asListOfString(dockerComposeContainerDefinition, EXPOSE));
        }
        if (dockerComposeContainerDefinition.containsKey(VOLUMES)) {
            this.addVolumes(YamlUtil.asListOfString(dockerComposeContainerDefinition, VOLUMES));
        }
        if (dockerComposeContainerDefinition.containsKey(LABELS)) {
            this.addLabels(YamlUtil.asMapOfStrings(dockerComposeContainerDefinition, LABELS));
        }
        if (dockerComposeContainerDefinition.containsKey(VOLUMES_FROM)) {
            this.addVolumesFrom(YamlUtil.asListOfString(dockerComposeContainerDefinition, VOLUMES_FROM));
        }
        if (dockerComposeContainerDefinition.containsKey(ENVIRONMENT)) {
            this.addEnvironment(YamlUtil.asListOfString(dockerComposeContainerDefinition, ENVIRONMENT));
        }
        if (dockerComposeContainerDefinition.containsKey(ENV_FILE)) {
            if (dockerComposeContainerDefinition.get(ENV_FILE) instanceof List) {
                this.addEnvFile(YamlUtil.asListOfString(dockerComposeContainerDefinition, ENV_FILE));
            } else {
                this.addEnvFile(Arrays.asList(YamlUtil.asString(dockerComposeContainerDefinition, ENV_FILE)));
            }
        }
        if (dockerComposeContainerDefinition.containsKey(NET)) {
            this.addNet(YamlUtil.asString(dockerComposeContainerDefinition, NET));
        }
        if (dockerComposeContainerDefinition.containsKey(EXTRA_HOSTS)) {
            this.addExtraHosts(YamlUtil.asListOfString(dockerComposeContainerDefinition, EXTRA_HOSTS));
        }
        if (dockerComposeContainerDefinition.containsKey(DNS)) {
            dns = dockerComposeContainerDefinition.get(DNS);
            if (dns instanceof List) {
                this.addDns((List)dns);
            } else {
                this.addDns((String)dns);
            }
        }
        if (dockerComposeContainerDefinition.containsKey(CAP_ADD)) {
            this.addCapAdd(YamlUtil.asListOfString(dockerComposeContainerDefinition, CAP_ADD));
        }
        if (dockerComposeContainerDefinition.containsKey(CAP_DROP)) {
            this.addCapDrop(YamlUtil.asListOfString(dockerComposeContainerDefinition, CAP_DROP));
        }
        if (dockerComposeContainerDefinition.containsKey(DNS_SEARCH)) {
            dns = dockerComposeContainerDefinition.get(DNS_SEARCH);
            if (dns instanceof List) {
                this.addDnsSearch((List)dns);
            } else {
                this.addDnsSearch((String)dns);
            }
        }
        if (dockerComposeContainerDefinition.containsKey(WORKING_DIR)) {
            this.addWorkingDir(YamlUtil.asString(dockerComposeContainerDefinition, WORKING_DIR));
        }
        if (dockerComposeContainerDefinition.containsKey(ENTRYPOINT)) {
            this.addEntrypoint(YamlUtil.asString(dockerComposeContainerDefinition, ENTRYPOINT));
        }
        if (dockerComposeContainerDefinition.containsKey(USER)) {
            this.addUser(YamlUtil.asString(dockerComposeContainerDefinition, USER));
        }
        if (dockerComposeContainerDefinition.containsKey(HOSTNAME)) {
            this.addHostname(YamlUtil.asString(dockerComposeContainerDefinition, HOSTNAME));
        }
        if (dockerComposeContainerDefinition.containsKey(MEM_LIMIT)) {
            this.addMemLimit(YamlUtil.asInt(dockerComposeContainerDefinition, MEM_LIMIT));
        }
        if (dockerComposeContainerDefinition.containsKey(PRIVILEGED)) {
            this.addPrivileged(YamlUtil.asBoolean(dockerComposeContainerDefinition, PRIVILEGED));
        }
        if (dockerComposeContainerDefinition.containsKey(RESTART)) {
            this.addRestart(YamlUtil.asString(dockerComposeContainerDefinition, RESTART));
        }
        if (dockerComposeContainerDefinition.containsKey(STDIN_OPEN)) {
            this.addStdinOpen(YamlUtil.asBoolean(dockerComposeContainerDefinition, STDIN_OPEN));
        }
        if (dockerComposeContainerDefinition.containsKey(TTY)) {
            this.addTty(YamlUtil.asBoolean(dockerComposeContainerDefinition, TTY));
        }
        if (dockerComposeContainerDefinition.containsKey(CPU_SHARES)) {
            this.addCpuShares(YamlUtil.asInt(dockerComposeContainerDefinition, CPU_SHARES));
        }
        if (dockerComposeContainerDefinition.containsKey(CPU_SET)) {
            this.addCpuSet(YamlUtil.asString(dockerComposeContainerDefinition, CPU_SET));
        }
        if (dockerComposeContainerDefinition.containsKey(DEVICES)) {
            this.addDevices(YamlUtil.asListOfString(dockerComposeContainerDefinition, DEVICES));
        }
        if (dockerComposeContainerDefinition.containsKey(DOMAINNAME)) {
            this.addDomainName(YamlUtil.asString(dockerComposeContainerDefinition, DOMAINNAME));
        }
        if (dockerComposeContainerDefinition.containsKey(READ_ONLY)) {
            this.addReadOnly(YamlUtil.asBoolean(dockerComposeContainerDefinition, READ_ONLY));
        }
        this.logUnsupportedOperations(dockerComposeContainerDefinition.keySet());
        return this.build();
    }

    private ContainerBuilder addDevices(Collection<String> devices) {
        HashSet<Device> devicesDefinition = new HashSet<Device>();
        for (String device : devices) {
            String[] deviceSplitted = device.split(":");
            Device def = new Device();
            switch (deviceSplitted.length) {
                case 3: {
                    def.setcGroupPermissions(deviceSplitted[2]);
                }
                case 2: {
                    def.setPathOnHost(deviceSplitted[0]);
                    def.setPathInContainer(deviceSplitted[1]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Device definition %s is incorrect. It should follow the format <hostPath>:<containerPath>:(optional)<permissions>", device));
                }
            }
            devicesDefinition.add(def);
        }
        this.configuration.setDevices(devicesDefinition);
        return this;
    }

    public ContainerBuilder addExtraHosts(Collection<String> extraHosts) {
        if (this.configuration.getExtraHosts() != null) {
            Collection<String> oldExtraHosts = this.configuration.getExtraHosts();
            oldExtraHosts.addAll(extraHosts);
        } else {
            this.configuration.setExtraHosts(new HashSet<String>(extraHosts));
        }
        return this;
    }

    public ContainerBuilder addImage(String image) {
        this.configuration.setImage(Image.valueOf(image));
        return this;
    }

    public ContainerBuilder addReadOnly(boolean b) {
        this.configuration.setReadonlyRootfs(b);
        return this;
    }

    public ContainerBuilder addBuild(String buildPath, String dockerfile) {
        Path fullDirectory = this.dockerComposeRootLocation.resolve(buildPath);
        Path relativize = this.dockerComposeRootLocation.relativize(fullDirectory);
        BuildImage buildImage = new BuildImage(relativize.toString(), dockerfile, true, true);
        this.configuration.setBuildImage(buildImage);
        return this;
    }

    public ContainerBuilder addCommand(String command) {
        this.configuration.setCmd(Arrays.asList(command));
        return this;
    }

    public ContainerBuilder addLinks(Collection<String> links) {
        HashSet<Link> listOfLinks = new HashSet<Link>();
        for (String link : links) {
            listOfLinks.add(Link.valueOf(link));
        }
        if (this.configuration.getLinks() != null) {
            Collection<Link> oldLinks = this.configuration.getLinks();
            oldLinks.addAll(listOfLinks);
        } else {
            this.configuration.setLinks(listOfLinks);
        }
        return this;
    }

    public ContainerBuilder addPorts(Collection<String> ports) {
        HashSet<PortBinding> listOfPorts = new HashSet<PortBinding>();
        for (String port : ports) {
            String[] elements = port.split(":");
            switch (elements.length) {
                case 1: {
                    listOfPorts.add(PortBinding.valueOf(this.getRandomPort() + "->" + elements[0]));
                    break;
                }
                case 2: {
                    listOfPorts.add(PortBinding.valueOf(port.replaceAll(":", "->")));
                    break;
                }
                case 3: {
                    listOfPorts.add(PortBinding.valueOf(elements[0] + ":" + elements[1] + "->" + elements[2]));
                }
            }
        }
        if (this.configuration.getPortBindings() != null) {
            Collection<PortBinding> oldPortBindings = this.configuration.getPortBindings();
            oldPortBindings.addAll(listOfPorts);
        } else {
            this.configuration.setPortBindings(listOfPorts);
        }
        return this;
    }

    public ContainerBuilder addExpose(Collection<String> exposes) {
        HashSet<ExposedPort> ports = new HashSet<ExposedPort>();
        for (String exposed : exposes) {
            ports.add(ExposedPort.valueOf(exposed));
        }
        if (this.configuration.getExposedPorts() != null) {
            Collection<ExposedPort> oldExposedPorts = this.configuration.getExposedPorts();
            oldExposedPorts.addAll(ports);
        } else {
            this.configuration.setExposedPorts(ports);
        }
        return this;
    }

    public ContainerBuilder addVolumes(Collection<String> volumes) {
        if (this.configuration.getVolumes() != null) {
            Collection<String> oldVolumes = this.configuration.getVolumes();
            oldVolumes.addAll(volumes);
        } else {
            this.configuration.setVolumes(new HashSet<String>(volumes));
        }
        return this;
    }

    public ContainerBuilder addVolumesFrom(Collection<String> volumesFrom) {
        if (this.configuration.getVolumesFrom() != null) {
            Collection<String> oldVolumes = this.configuration.getVolumesFrom();
            oldVolumes.addAll(volumesFrom);
        } else {
            this.configuration.setVolumesFrom(new HashSet<String>(volumesFrom));
        }
        return this;
    }

    public ContainerBuilder addLabels(Map<String, String> labels) {
        if (this.configuration.getLabels() != null) {
            Map<String, String> oldLabels = this.configuration.getLabels();
            oldLabels.putAll(labels);
        } else {
            this.configuration.setLabels(labels);
        }
        return this;
    }

    public ContainerBuilder addEnvironment(Collection<String> environments) {
        this.addEnvironment(this.getProperties(environments));
        return this;
    }

    private void addEnvironment(Properties properties) {
        if (this.configuration.getEnv() != null) {
            Properties oldProperties = this.getProperties(this.configuration.getEnv());
            oldProperties.putAll((Map<?, ?>)properties);
            this.configuration.setEnv(this.toEnvironment(oldProperties));
        } else {
            this.configuration.setEnv(this.toEnvironment(properties));
        }
    }

    public ContainerBuilder addEnvFile(Collection<String> environmentPaths) {
        for (String environmentPath : environmentPaths) {
            try {
                Properties properties = new Properties();
                Path environmentLocation = Paths.get(environmentPath, new String[0]);
                File environmentFile = this.dockerComposeRootLocation.resolve(environmentLocation).toFile();
                FileInputStream inStream = new FileInputStream(environmentFile);
                properties.load(inStream);
                inStream.close();
                this.addEnvironment(properties);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this;
    }

    public ContainerBuilder addNet(String net) {
        this.configuration.setNetworkMode(net);
        return this;
    }

    public ContainerBuilder addDns(String dns) {
        this.configuration.setDns(Arrays.asList(dns));
        return this;
    }

    public ContainerBuilder addDns(Collection<String> dns) {
        if (this.configuration.getDns() != null) {
            Collection<String> oldDns = this.configuration.getDns();
            oldDns.addAll(dns);
        } else {
            this.configuration.setDns(new HashSet<String>(dns));
        }
        return this;
    }

    public ContainerBuilder addCapAdd(Collection<String> capAdds) {
        if (this.configuration.getCapAdd() != null) {
            Collection<String> oldCapAdd = this.configuration.getCapAdd();
            oldCapAdd.addAll(capAdds);
        } else {
            this.configuration.setCapAdd(new HashSet<String>(capAdds));
        }
        return this;
    }

    public ContainerBuilder addCapDrop(Collection<String> capDrops) {
        if (this.configuration.getCapDrop() != null) {
            Collection<String> oldCapDrops = this.configuration.getCapDrop();
            oldCapDrops.addAll(capDrops);
        } else {
            this.configuration.setCapDrop(new HashSet<String>(capDrops));
        }
        return this;
    }

    public ContainerBuilder addDnsSearch(String dnsSearch) {
        this.configuration.setDnsSearch(Arrays.asList(dnsSearch));
        return this;
    }

    public ContainerBuilder addDnsSearch(Collection<String> dnsSearch) {
        if (this.configuration.getDnsSearch() != null) {
            Collection<String> oldDnsSearch = this.configuration.getDnsSearch();
            oldDnsSearch.addAll(dnsSearch);
        } else {
            this.configuration.setDnsSearch(new HashSet<String>(dnsSearch));
        }
        return this;
    }

    public ContainerBuilder addCpuShares(int cpuShares) {
        this.configuration.setCpuShares(cpuShares);
        return this;
    }

    private ContainerBuilder addCpuSet(String cpuSet) {
        this.configuration.setCpuSet(cpuSet);
        return this;
    }

    public ContainerBuilder addTty(boolean tty) {
        this.configuration.setTty(tty);
        return this;
    }

    public ContainerBuilder addStdinOpen(boolean stdinOpen) {
        this.configuration.setStdinOpen(stdinOpen);
        return this;
    }

    public ContainerBuilder extend(Path location, String service) {
        File extendLocation = this.dockerComposeRootLocation.resolve(location).toFile();
        try (FileInputStream inputStream = new FileInputStream(extendLocation);){
            Map extendedDockerComposeFile = (Map)new Yaml().load((InputStream)inputStream);
            Map<String, Object> serviceDockerComposeConfiguration = YamlUtil.asMap(extendedDockerComposeFile, service);
            ContainerBuilder containerBuilder = new ContainerBuilder(this.dockerComposeRootLocation, this.configuration);
            this.configuration = containerBuilder.build(serviceDockerComposeConfiguration);
            if (serviceDockerComposeConfiguration == null) {
                throw new IllegalArgumentException(String.format("Service name %s is not present at %s", service, extendLocation.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ContainerBuilder addRestart(String restart) {
        RestartPolicy restartPolicy = new RestartPolicy();
        if (restart.startsWith("on-failure")) {
            String[] element = restart.split(":");
            if (element.length == 1) {
                restartPolicy.setName(restart);
                restartPolicy.setMaximumRetryCount(0);
            } else {
                if (element.length != 2) throw new IllegalArgumentException("on-failure restart should be on-failure or with optional retries on-failure:retries");
                restartPolicy.setName(element[0]);
                restartPolicy.setMaximumRetryCount(Integer.parseInt(element[1]));
            }
        } else {
            restartPolicy.setName(restart);
        }
        this.configuration.setRestartPolicy(restartPolicy);
        return this;
    }

    public ContainerBuilder addPrivileged(boolean privileged) {
        this.configuration.setPrivileged(privileged);
        return this;
    }

    public ContainerBuilder addMemLimit(int memLimit) {
        this.configuration.setMemoryLimit(memLimit);
        return this;
    }

    public ContainerBuilder addDomainName(String domainName) {
        this.configuration.setDomainName(domainName);
        return this;
    }

    public ContainerBuilder addHostname(String hostname) {
        this.configuration.setHostName(hostname);
        return this;
    }

    public ContainerBuilder addUser(String user) {
        this.configuration.setUser(user);
        return this;
    }

    public ContainerBuilder addEntrypoint(String entrypoint) {
        this.configuration.setEntryPoint(Arrays.asList(entrypoint));
        return this;
    }

    public ContainerBuilder addWorkingDir(String workingDir) {
        this.configuration.setWorkingDir(workingDir);
        return this;
    }

    public CubeContainer buildFromExtension() {
        return this.configuration;
    }

    public CubeContainer build() {
        return this.configuration;
    }

    private String getRandomPort() {
        int shiftedRandomPort = this.random.nextInt(28232);
        return Integer.toString(shiftedRandomPort + 32768);
    }

    private Properties getProperties(Collection<String> properties) {
        Properties allProperties = new Properties();
        for (String property : properties) {
            int keySeparator = property.indexOf("=");
            allProperties.put(property.substring(0, keySeparator), property.substring(keySeparator + 1, property.length()));
        }
        return allProperties;
    }

    private Collection<String> toEnvironment(Properties properties) {
        HashSet<String> listOfEnvironment = new HashSet<String>();
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            listOfEnvironment.add(entry.getKey() + "=" + entry.getValue());
        }
        return listOfEnvironment;
    }

    private void logUnsupportedOperations(Set<String> keys) {
        for (String key : keys) {
            if (AVAILABLE_COMMANDS.contains(key)) continue;
            log.info(String.format("Key: %s is not implemented in Cube.", keys));
        }
    }
}

