/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.arquillian.cube.docker.impl.client.AutoStartParser;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.Link;

public class AutoStartOrderUtil {
    public static final String REGEXP = "regexp:";

    public static List<String[]> getAutoStopOrder(CubeDockerConfiguration config) {
        List<String[]> autoStartOrder = AutoStartOrderUtil.getAutoStartOrder(config);
        Collections.reverse(autoStartOrder);
        return autoStartOrder;
    }

    public static List<String[]> getAutoStartOrder(CubeDockerConfiguration config) {
        ArrayList<String[]> sorted = new ArrayList<String[]>();
        List<Step> steps = AutoStartOrderUtil.sort(AutoStartOrderUtil.from(config));
        for (Step step : steps) {
            sorted.add(step.getIDs());
        }
        return sorted;
    }

    static List<Step> sort(Set<Node> nodes) {
        ArrayList<Step> steps = new ArrayList<Step>();
        ArrayList<Node> remaining = new ArrayList<Node>(nodes);
        int previousSize = remaining.size();
        while (!remaining.isEmpty()) {
            Step step = new Step();
            for (int i = 0; i < remaining.size(); ++i) {
                Node node = (Node)remaining.get(i);
                if (node.hasParent() && !AutoStartOrderUtil.nodesInStep(steps, node.getParents())) continue;
                step.add(node);
                remaining.remove(i);
                --i;
            }
            if (previousSize == remaining.size()) {
                throw new IllegalArgumentException("Could not resolve autoStart order. " + nodes);
            }
            previousSize = remaining.size();
            steps.add(step);
        }
        return steps;
    }

    static Set<Node> from(CubeDockerConfiguration config) {
        HashMap<String, Node> nodes = new HashMap<String, Node>();
        AutoStartParser autoStartParser = config.getAutoStartContainers();
        if (autoStartParser != null) {
            nodes.putAll(autoStartParser.parse());
        }
        HashMap autoStartNodes = new HashMap(nodes);
        for (Map.Entry node : autoStartNodes.entrySet()) {
            AutoStartOrderUtil.addAll(nodes, config, (String)node.getKey());
        }
        return new HashSet<Node>(nodes.values());
    }

    private static boolean nodesInStep(List<Step> steps, Set<Node> nodes) {
        for (Node node : nodes) {
            if (AutoStartOrderUtil.nodeInStep(steps, node)) continue;
            return false;
        }
        return true;
    }

    private static boolean nodeInStep(List<Step> steps, Node node) {
        for (Step step : steps) {
            if (!step.contains(node)) continue;
            return true;
        }
        return false;
    }

    private static void addAll(Map<String, Node> nodes, CubeDockerConfiguration config, String id) {
        CubeContainer content = config.getDockerContainersContent().get(id);
        if (content == null) {
            return;
        }
        Node parent = nodes.get(id);
        if (content.getLinks() != null) {
            Collection<Link> links = content.getLinks();
            for (Link link : links) {
                String name = link.getName();
                if (config.getDockerContainersContent().get(name) == null) continue;
                Node child = nodes.get(name);
                if (child == null) {
                    child = Node.from(name);
                    nodes.put(name, child);
                }
                if (!child.addAsChildOf(parent)) continue;
                AutoStartOrderUtil.addAll(nodes, config, name);
            }
        }
    }

    private static String nodeList(Set<Node> nodes) {
        StringBuilder sb = new StringBuilder();
        Node[] array = nodes.toArray(new Node[0]);
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i].getId());
            if (i >= array.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static String toString(Map<String, Node> nodeMap) {
        return AutoStartOrderUtil.nodeList(new HashSet<Node>(nodeMap.values()));
    }

    public static class Step {
        private Set<Node> nodes = new HashSet<Node>();

        private Step() {
        }

        public boolean contains(Node node) {
            return this.nodes.contains(node);
        }

        public void add(Node node) {
            if (!this.nodes.contains(node)) {
                this.nodes.add(node);
            }
        }

        public String[] getIDs() {
            String[] ids = new String[this.nodes.size()];
            Node[] nodes = this.nodes.toArray(new Node[0]);
            for (int i = 0; i < nodes.length; ++i) {
                ids[i] = nodes[i].getId();
            }
            return ids;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Step [ids=" + AutoStartOrderUtil.nodeList(this.nodes));
            sb.append("]");
            return sb.toString();
        }
    }

    public static class Node {
        private String id;
        private Set<Node> parents;
        private Set<Node> children;

        private Node(String id) {
            this.id = id;
            this.parents = new HashSet<Node>();
            this.children = new HashSet<Node>();
        }

        public String getId() {
            return this.id;
        }

        public boolean addAsParentOf(Node node) {
            if (!this.parents.contains(node)) {
                this.parents.add(node);
                node.addAsChildOf(this);
                return true;
            }
            return false;
        }

        public boolean addAsChildOf(Node node) {
            if (!this.children.contains(node)) {
                this.children.add(node);
                node.addAsParentOf(this);
                return true;
            }
            return false;
        }

        public Set<Node> getParents() {
            return this.parents;
        }

        public boolean hasParent() {
            return this.parents.size() > 0;
        }

        public static Node from(String id) {
            return new Node(id);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Node [id=" + this.id);
            if (!this.parents.isEmpty()) {
                sb.append(", parents=" + AutoStartOrderUtil.nodeList(this.parents));
            }
            if (!this.children.isEmpty()) {
                sb.append(", children=" + AutoStartOrderUtil.nodeList(this.children));
            }
            sb.append("]");
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }
}

