/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import org.arquillian.cube.docker.impl.client.CommaSeparatedAutoStartParser;
import org.arquillian.cube.docker.impl.client.CustomAutoStartParser;
import org.arquillian.cube.docker.impl.client.NoneAutoStartParser;
import org.arquillian.cube.docker.impl.client.RegularExpressionAutoStartParser;
import org.arquillian.cube.docker.impl.client.config.DockerCompositions;
import org.arquillian.cube.spi.AutoStartParser;
import org.jboss.arquillian.core.api.Injector;

public class AutoStartParserFactory {
    public static AutoStartParser create(String expression, DockerCompositions containersDefinition, Injector injector) {
        if (AutoStartParserFactory.isNone(expression)) {
            return new NoneAutoStartParser();
        }
        if (AutoStartParserFactory.isRegularExpressionBased(expression)) {
            return new RegularExpressionAutoStartParser(expression, containersDefinition);
        }
        if (AutoStartParserFactory.isCustomImplementation(expression)) {
            return new CustomAutoStartParser(injector, expression.substring(expression.indexOf("custom:") + "custom:".length()).trim());
        }
        if (AutoStartParserFactory.isCommaSeparated(expression)) {
            return new CommaSeparatedAutoStartParser(expression, containersDefinition);
        }
        return null;
    }

    private static boolean isCustomImplementation(String expression) {
        return expression != null && expression.startsWith("custom:");
    }

    private static boolean isNone(String expression) {
        return expression != null && "[none]".equals(expression.trim());
    }

    private static boolean isCommaSeparated(String expression) {
        return expression != null;
    }

    private static boolean isRegularExpressionBased(String expression) {
        return expression != null && expression.startsWith("regexp:");
    }
}

