/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.containerobject.dsl;

import org.arquillian.cube.HostIpContext;
import org.arquillian.cube.containerobject.ConnectionMode;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.containerobject.dsl.ContainerBuilder;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.metadata.HasPortBindings;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;

public class Container {
    @Inject
    Instance<HostIpContext> hostIpContextInstance;
    @Inject
    Instance<CubeRegistry> cubeRegistryInstance;
    private String containerName;
    private CubeContainer cubeContainer;
    private ConnectionMode connectionMode;

    protected Container(String containerName, CubeContainer cubeContainer, ConnectionMode connectionMode) {
        this.containerName = containerName;
        this.cubeContainer = cubeContainer;
        this.connectionMode = connectionMode;
    }

    public static ContainerBuilder withContainerName(String containerName) {
        return ContainerBuilder.newContainer(containerName);
    }

    public String getContainerName() {
        return this.containerName;
    }

    public CubeContainer getCubeContainer() {
        return this.cubeContainer;
    }

    public ConnectionMode getConnectionMode() {
        return this.connectionMode;
    }

    public String getIpAddress() {
        return ((HostIpContext)this.hostIpContextInstance.get()).getHost();
    }

    public int getBindPort(int exposedPort) {
        return this.getBindingPort(this.containerName, exposedPort);
    }

    private int getBindingPort(String cubeId, int exposedPort) {
        HasPortBindings portBindings;
        HasPortBindings.PortAddress mappedAddress;
        int bindPort = -1;
        Cube cube = this.getCube(cubeId);
        if (cube != null && (mappedAddress = (portBindings = (HasPortBindings)cube.getMetadata(HasPortBindings.class)).getMappedAddress(exposedPort)) != null) {
            bindPort = mappedAddress.getPort();
        }
        return bindPort;
    }

    private Cube getCube(String cubeId) {
        return ((CubeRegistry)this.cubeRegistryInstance.get()).getCube(cubeId);
    }
}

