/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.containerobject;

import java.util.Optional;
import org.arquillian.cube.ContainerObjectConfiguration;
import org.arquillian.cube.docker.impl.client.config.Await;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.Link;
import org.arquillian.cube.docker.impl.client.config.PortBinding;

public class CubeContainerObjectConfiguration
implements ContainerObjectConfiguration {
    private final CubeContainer configuration;

    public CubeContainerObjectConfiguration(CubeContainer configuration) {
        this.configuration = configuration;
    }

    public CubeContainer getCubeContainerConfiguration() {
        return this.configuration;
    }

    public static CubeContainerObjectConfiguration empty() {
        return new CubeContainerObjectConfiguration(null);
    }

    public String getContainerName() {
        return this.configuration.getContainerName();
    }

    public String[] getPortBindings() {
        return Optional.ofNullable(this.configuration.getPortBindings()).map(links -> (String[])links.stream().map(PortBinding::toString).toArray(String[]::new)).orElse(null);
    }

    public int[] getAwaitPorts() {
        return Optional.ofNullable(this.configuration.getAwait()).filter(await -> await.getStrategy().equals("polling")).map(Await::getPorts).map(ports -> ports.stream().mapToInt(Integer::intValue).toArray()).orElse(null);
    }

    public String[] getEnvironmentVariables() {
        return Optional.ofNullable(this.configuration.getEnv()).map(env -> (String[])env.stream().toArray(String[]::new)).orElse(null);
    }

    public String[] getVolumes() {
        return Optional.ofNullable(this.configuration.getVolumes()).map(volumes -> (String[])volumes.stream().toArray(String[]::new)).orElse(null);
    }

    public String[] getLinks() {
        return Optional.ofNullable(this.configuration.getLinks()).map(links -> (String[])links.stream().map(Link::toString).toArray(String[]::new)).orElse(null);
    }
}

