/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.arquillian.cube.docker.impl.client.AutomaticResolutionLinksAutoStartParser;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.client.CubeSuiteLifecycleController;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.spi.AutoStartParser;
import org.arquillian.cube.spi.ConnectionMode;
import org.arquillian.cube.spi.CubeConfiguration;
import org.arquillian.cube.spi.event.CreateCube;
import org.arquillian.cube.spi.event.DestroyCube;
import org.arquillian.cube.spi.event.PreRunningCube;
import org.arquillian.cube.spi.event.StartCube;
import org.arquillian.cube.spi.event.StopCube;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.test.AbstractManagerTestBase;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CubeSuiteLifecycleControllerTest
extends AbstractManagerTestBase {
    @Mock
    private DockerClientExecutor executor;

    protected void addExtensions(List<Class<?>> extensions) {
        extensions.add(CubeSuiteLifecycleController.class);
        super.addExtensions(extensions);
    }

    @Test
    public void shouldParseEmptyAutostart() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("autoStartContainers", "");
        parameters.put("dockerContainers", "a:\n  image: a\nb:\n  image: a\n");
        CubeConfiguration cubeConfiguration = CubeConfiguration.fromMap(new HashMap());
        this.bind(ApplicationScoped.class, CubeConfiguration.class, cubeConfiguration);
        CubeDockerConfiguration dockerConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        this.bind(ApplicationScoped.class, CubeDockerConfiguration.class, dockerConfiguration);
        this.fire(new BeforeSuite());
        this.assertEventFired(CreateCube.class, 0);
        this.assertEventFired(StartCube.class, 0);
    }

    @Test
    public void shouldParseEmptyValuesAutostart() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("autoStartContainers", " ,  ");
        parameters.put("dockerContainers", "a:\n  image: a\nb:\n  image: a\n");
        CubeConfiguration cubeConfiguration = CubeConfiguration.fromMap(new HashMap());
        this.bind(ApplicationScoped.class, CubeConfiguration.class, cubeConfiguration);
        CubeDockerConfiguration dockerConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        this.bind(ApplicationScoped.class, CubeDockerConfiguration.class, dockerConfiguration);
        this.fire(new BeforeSuite());
        this.assertEventFired(CreateCube.class, 0);
        this.assertEventFired(StartCube.class, 0);
    }

    @Test
    public void shouldParseTrimAutostart() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("autoStartContainers", "a , b ");
        parameters.put("dockerContainers", "a:\n  image: a\nb:\n  image: a\n");
        CubeConfiguration cubeConfiguration = CubeConfiguration.fromMap(new HashMap());
        this.bind(ApplicationScoped.class, CubeConfiguration.class, cubeConfiguration);
        CubeDockerConfiguration dockerConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        this.bind(ApplicationScoped.class, CubeDockerConfiguration.class, dockerConfiguration);
        this.fire(new BeforeSuite());
        this.assertEventFired(CreateCube.class, 2);
        this.assertEventFired(StartCube.class, 2);
        this.assertEventFiredOnOtherThread(CreateCube.class);
        this.assertEventFiredOnOtherThread(StartCube.class);
    }

    @Test
    public void shouldCreateAndStartAutoContainersWhenNoAutoStartIsProvided() {
        HashMap<String, String> dockerData = new HashMap<String, String>();
        dockerData.put("dockerContainers", "a:\n  image: a\n  links:\n    - b:b\nb:\n  image: a\n");
        CubeConfiguration cubeConfiguration = CubeConfiguration.fromMap(new HashMap());
        this.bind(ApplicationScoped.class, CubeConfiguration.class, cubeConfiguration);
        CubeDockerConfiguration dockerConfiguration = CubeDockerConfiguration.fromMap(dockerData, null);
        dockerConfiguration.setAutoStartContainers((AutoStartParser)new AutomaticResolutionLinksAutoStartParser(Arrays.asList("a"), dockerConfiguration.getDockerContainersContent()));
        this.bind(ApplicationScoped.class, CubeDockerConfiguration.class, dockerConfiguration);
        ContainerRegistry containerRegistry = (ContainerRegistry)Mockito.mock(ContainerRegistry.class);
        ArrayList<Container> containers = new ArrayList<Container>();
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.lenient().when((Object)container.getName()).thenReturn((Object)"a");
        containers.add(container);
        Mockito.lenient().when((Object)containerRegistry.getContainers()).thenReturn(containers);
        this.bind(ApplicationScoped.class, ContainerRegistry.class, containerRegistry);
        this.fire(new BeforeSuite());
        this.assertEventFired(CreateCube.class, 1);
        this.assertEventFired(StartCube.class, 1);
    }

    @Test
    public void shouldCreateAndStartAutoContainersDefiningRegularExpressions() {
        HashMap<String, String> dockerData = new HashMap<String, String>();
        dockerData.put("autoStartContainers", "regexp:a(.*)");
        dockerData.put("dockerContainers", "a:\n  image: a\nab:\n  image: a\nx:\n  image: a\n");
        CubeConfiguration cubeConfiguration = CubeConfiguration.fromMap(new HashMap());
        this.bind(ApplicationScoped.class, CubeConfiguration.class, cubeConfiguration);
        CubeDockerConfiguration dockerConfiguration = CubeDockerConfiguration.fromMap(dockerData, null);
        this.bind(ApplicationScoped.class, CubeDockerConfiguration.class, dockerConfiguration);
        this.fire(new BeforeSuite());
        this.assertEventFired(CreateCube.class, 2);
        this.assertEventFired(StartCube.class, 2);
        this.assertEventFiredOnOtherThread(CreateCube.class);
        this.assertEventFiredOnOtherThread(StartCube.class);
    }

    @Test
    public void shouldCreateAndStartAutoContainers() {
        HashMap<String, String> dockerData = new HashMap<String, String>();
        dockerData.put("autoStartContainers", "a,b");
        dockerData.put("dockerContainers", "a:\n  image: a\nb:\n  image: a\n");
        CubeConfiguration cubeConfiguration = CubeConfiguration.fromMap(new HashMap());
        this.bind(ApplicationScoped.class, CubeConfiguration.class, cubeConfiguration);
        CubeDockerConfiguration dockerConfiguration = CubeDockerConfiguration.fromMap(dockerData, null);
        this.bind(ApplicationScoped.class, CubeDockerConfiguration.class, dockerConfiguration);
        this.fire(new BeforeSuite());
        this.assertEventFired(CreateCube.class, 2);
        this.assertEventFired(StartCube.class, 2);
        this.assertEventFiredOnOtherThread(CreateCube.class);
        this.assertEventFiredOnOtherThread(StartCube.class);
    }

    @Test
    public void shouldStopAndDestroyAutoContainers() {
        HashMap<String, String> dockerData = new HashMap<String, String>();
        dockerData.put("autoStartContainers", "a,b");
        dockerData.put("dockerContainers", "a:\n  image: a\nb:\n  image: a\n");
        CubeConfiguration cubeConfiguration = CubeConfiguration.fromMap(new HashMap());
        this.bind(ApplicationScoped.class, CubeConfiguration.class, cubeConfiguration);
        CubeDockerConfiguration dockerConfiguration = CubeDockerConfiguration.fromMap(dockerData, null);
        this.bind(ApplicationScoped.class, CubeDockerConfiguration.class, dockerConfiguration);
        this.fire(new AfterSuite());
        this.assertEventFired(StopCube.class, 2);
        this.assertEventFired(DestroyCube.class, 2);
        this.assertEventFiredOnOtherThread(StopCube.class);
        this.assertEventFiredOnOtherThread(DestroyCube.class);
    }

    @Test
    public void shouldUsePreRunningContainers() {
        HashMap<String, String> cubeData = new HashMap<String, String>();
        cubeData.put("connectionMode", ConnectionMode.STARTORCONNECT.name());
        HashMap<String, String> dockerData = new HashMap<String, String>();
        dockerData.put("autoStartContainers", "a,b");
        dockerData.put("dockerContainers", "a:\n  image: a\nb:\n  image: a\n");
        CubeConfiguration cubeConfiguration = CubeConfiguration.fromMap(cubeData);
        this.bind(ApplicationScoped.class, CubeConfiguration.class, cubeConfiguration);
        CubeDockerConfiguration dockerConfiguration = CubeDockerConfiguration.fromMap(dockerData, null);
        this.bind(ApplicationScoped.class, CubeDockerConfiguration.class, dockerConfiguration);
        com.github.dockerjava.api.model.Container container = (com.github.dockerjava.api.model.Container)Mockito.mock(com.github.dockerjava.api.model.Container.class);
        Mockito.when((Object)container.getNames()).thenReturn((Object)new String[]{"a"});
        Mockito.when((Object)this.executor.listRunningContainers()).thenReturn(Arrays.asList(container));
        this.bind(ApplicationScoped.class, DockerClientExecutor.class, this.executor);
        this.fire(new BeforeSuite());
        this.assertEventFired(CreateCube.class, 1);
        this.assertEventFired(StartCube.class, 1);
        this.assertEventFired(PreRunningCube.class, 1);
        this.assertEventFiredOnOtherThread(CreateCube.class);
        this.assertEventFiredOnOtherThread(StartCube.class);
        this.assertEventFiredOnOtherThread(PreRunningCube.class);
    }

    @Test
    public void shouldStartAContainerInStartOrConnectModeAndStopIt() {
        HashMap<String, String> cubeData = new HashMap<String, String>();
        cubeData.put("connectionMode", ConnectionMode.STARTORCONNECT.name());
        HashMap<String, String> dockerData = new HashMap<String, String>();
        dockerData.put("autoStartContainers", "a,b");
        dockerData.put("dockerContainers", "a:\n  image: a\nb:\n  image: a\n");
        CubeConfiguration cubeConfiguration = CubeConfiguration.fromMap(cubeData);
        this.bind(ApplicationScoped.class, CubeConfiguration.class, cubeConfiguration);
        CubeDockerConfiguration dockerConfiguration = CubeDockerConfiguration.fromMap(dockerData, null);
        this.bind(ApplicationScoped.class, CubeDockerConfiguration.class, dockerConfiguration);
        com.github.dockerjava.api.model.Container container = (com.github.dockerjava.api.model.Container)Mockito.mock(com.github.dockerjava.api.model.Container.class);
        Mockito.when((Object)container.getNames()).thenReturn((Object)new String[]{"alreadyrun"});
        Mockito.when((Object)this.executor.listRunningContainers()).thenReturn(Arrays.asList(container));
        this.bind(ApplicationScoped.class, DockerClientExecutor.class, this.executor);
        this.fire(new BeforeSuite());
        this.assertEventFired(CreateCube.class, 2);
        this.assertEventFired(StartCube.class, 2);
        this.assertEventFired(PreRunningCube.class, 0);
        this.assertEventFiredOnOtherThread(CreateCube.class);
        this.assertEventFiredOnOtherThread(StartCube.class);
    }

    @Test
    public void shouldStartAContainerInStartOrConnectAndLeaveModeAndNotStopIt() {
        HashMap<String, String> cubeData = new HashMap<String, String>();
        cubeData.put("connectionMode", ConnectionMode.STARTORCONNECTANDLEAVE.name());
        HashMap<String, String> dockerData = new HashMap<String, String>();
        dockerData.put("autoStartContainers", "a,b");
        dockerData.put("dockerContainers", "a:\n  image: a\nb:\n  image: a\n");
        CubeConfiguration cubeConfiguration = CubeConfiguration.fromMap(cubeData);
        this.bind(ApplicationScoped.class, CubeConfiguration.class, cubeConfiguration);
        CubeDockerConfiguration dockerConfiguration = CubeDockerConfiguration.fromMap(dockerData, null);
        this.bind(ApplicationScoped.class, CubeDockerConfiguration.class, dockerConfiguration);
        com.github.dockerjava.api.model.Container container = (com.github.dockerjava.api.model.Container)Mockito.mock(com.github.dockerjava.api.model.Container.class);
        Mockito.when((Object)container.getNames()).thenReturn((Object)new String[]{"alreadyrun"});
        Mockito.when((Object)this.executor.listRunningContainers()).thenReturn(Arrays.asList(container));
        this.bind(ApplicationScoped.class, DockerClientExecutor.class, this.executor);
        this.fire(new BeforeSuite());
        this.assertEventFired(CreateCube.class, 2);
        this.assertEventFired(StartCube.class, 2);
        this.assertEventFired(PreRunningCube.class, 2);
        this.assertEventFiredOnOtherThread(CreateCube.class);
        this.assertEventFiredOnOtherThread(StartCube.class);
        this.assertEventFiredOnOtherThread(PreRunningCube.class);
    }
}

