/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.arquillian.cube.docker.impl.client.AutoStartParserFactory;
import org.arquillian.cube.docker.impl.client.ChangeNameAutoStartParser;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.client.CustomAutoStartParser;
import org.arquillian.cube.docker.impl.client.DefinitionFormat;
import org.arquillian.cube.spi.AutoStartParser;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.test.AbstractManagerTestBase;
import org.junit.Assert;
import org.junit.Test;

public class CustomResolutionAutoStartParserTest
extends AbstractManagerTestBase {
    private static final String CONTENT = "tomcat:\n  image: tomcat:10.1.30\n  exposedPorts: [8089/tcp]\n  await:\n    strategy: static\n    ip: localhost\n    ports: [8080, 8089]\ngo:\n  image: tomcat:10.1.30\n";

    protected void addExtensions(List<Class<?>> extensions) {
        super.addExtensions(extensions);
    }

    @Test
    public void shouldInstantiateACustomAutoStartParser() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverVersion", "1.13");
        parameters.put("serverUri", "http://localhost:25123");
        parameters.put("dockerContainers", CONTENT);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        final CubeDockerConfiguration cubeDockerConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        Injector injector = new Injector(){

            public <T> T inject(T target) {
                ChangeNameAutoStartParser orderByNameAutoStartParser = (ChangeNameAutoStartParser)target;
                orderByNameAutoStartParser.cubeDockerConfigurationInstance = new Instance<CubeDockerConfiguration>(){

                    public CubeDockerConfiguration get() {
                        return cubeDockerConfiguration;
                    }
                };
                return target;
            }
        };
        AutoStartParser autoStartParser = AutoStartParserFactory.create((String)"custom:org.arquillian.cube.docker.impl.client.ChangeNameAutoStartParser", null, (Injector)injector);
        Assert.assertThat((Object)autoStartParser, (Matcher)CoreMatchers.instanceOf(CustomAutoStartParser.class));
        Set names = autoStartParser.parse().keySet();
        Assert.assertThat(names, (Matcher)CoreMatchers.hasItem((Object)"og"));
        Assert.assertThat(names, (Matcher)CoreMatchers.hasItem((Object)"tacmot"));
    }
}

