/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import java.util.HashMap;
import java.util.List;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.client.DefinitionFormat;
import org.arquillian.cube.docker.impl.client.DockerImageController;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.impl.model.LocalCubeRegistry;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeConfiguration;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.event.lifecycle.AfterDestroy;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.test.AbstractManagerTestBase;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DockerImageControllerTest
extends AbstractManagerTestBase {
    public static final String CUBE_ID = "pingpong";
    @Mock
    Cube cube;

    protected void addExtensions(List<Class<?>> extensions) {
        extensions.add(DockerImageController.class);
        super.addExtensions(extensions);
    }

    @Test
    public void should_remove_docker_image_if_built_by_cube() {
        DockerClientExecutor executor = (DockerClientExecutor)Mockito.mock(DockerClientExecutor.class);
        String config = "pingpong:\n  buildImage:\n    dockerfileLocation: src/test/resources/tomcat\n    noCache: true\n    remove: true\n  exposedPorts: [8080/tcp]\n  portBindings: [8080->8080/tcp]\n";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", config);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeConfiguration cubeConfiguration = CubeConfiguration.fromMap(new HashMap());
        this.bind(ApplicationScoped.class, CubeConfiguration.class, cubeConfiguration);
        CubeDockerConfiguration dockerConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        Mockito.when((Object)this.cube.getId()).thenReturn((Object)CUBE_ID);
        Mockito.when((Object)this.cube.configuration()).thenReturn((Object)dockerConfiguration.getDockerContainersContent().get(CUBE_ID));
        this.bind(ApplicationScoped.class, CubeDockerConfiguration.class, dockerConfiguration);
        LocalCubeRegistry localCubeRegistry = new LocalCubeRegistry();
        localCubeRegistry.addCube(this.cube);
        this.bind(ApplicationScoped.class, CubeRegistry.class, localCubeRegistry);
        this.bind(ApplicationScoped.class, DockerClientExecutor.class, executor);
        this.fire(new AfterDestroy(CUBE_ID));
        ((DockerClientExecutor)Mockito.verify((Object)executor)).removeImage("pingpong:latest", Boolean.valueOf(false));
    }

    @Test
    public void should_not_remove_docker_image_as_not_built_by_cube() {
        DockerClientExecutor executor = (DockerClientExecutor)Mockito.mock(DockerClientExecutor.class);
        String config = "pingpong:\n  image: tsongpon/pingpong\n  exposedPorts: [8080/tcp]\n  portBindings: [8080->8080/tcp]\n";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", config);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeConfiguration cubeConfiguration = CubeConfiguration.fromMap(new HashMap());
        this.bind(ApplicationScoped.class, CubeConfiguration.class, cubeConfiguration);
        CubeDockerConfiguration dockerConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        Mockito.when((Object)this.cube.getId()).thenReturn((Object)CUBE_ID);
        Mockito.when((Object)this.cube.configuration()).thenReturn((Object)dockerConfiguration.getDockerContainersContent().get(CUBE_ID));
        this.bind(ApplicationScoped.class, CubeDockerConfiguration.class, dockerConfiguration);
        LocalCubeRegistry localCubeRegistry = new LocalCubeRegistry();
        localCubeRegistry.addCube(this.cube);
        this.bind(ApplicationScoped.class, CubeRegistry.class, localCubeRegistry);
        this.bind(ApplicationScoped.class, DockerClientExecutor.class, executor);
        this.fire(new AfterDestroy(CUBE_ID));
        ((DockerClientExecutor)Mockito.verify((Object)executor, (VerificationMode)Mockito.never())).removeImage("pingpong:latest", Boolean.valueOf(false));
    }
}

