/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.containerobject;

import com.github.dockerjava.api.DockerClient;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.arquillian.cube.CubeController;
import org.arquillian.cube.containerobject.Cube;
import org.arquillian.cube.containerobject.CubeDockerFile;
import org.arquillian.cube.containerobject.Environment;
import org.arquillian.cube.containerobject.Environments;
import org.arquillian.cube.containerobject.Image;
import org.arquillian.cube.containerobject.Link;
import org.arquillian.cube.containerobject.Volume;
import org.arquillian.cube.docker.impl.client.containerobject.CubeContainerObjectTestEnricher;
import org.arquillian.cube.docker.impl.client.containerobject.DockerContainerObjectFactory;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.model.DockerCube;
import org.arquillian.cube.impl.model.LocalCubeRegistry;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.metadata.IsContainerObject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.docker.DockerDescriptor;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class CubeContainerObjectTestEnricherTest {
    private CubeRegistry cubeRegistry;
    private CubeController cubeController;
    private DockerClientExecutor dockerClientExecutor;
    private Injector injector;
    private ServiceLoader serviceLoader;
    private DockerContainerObjectFactory dockerContainerObjectFactory;

    @AfterClass
    public static void cleanEnvironment() {
        CubeContainerObjectTestEnricherTest.deleteTestDirectory();
    }

    @Before
    public void init() {
        this.cubeRegistry = new LocalCubeRegistry();
        this.dockerContainerObjectFactory = new DockerContainerObjectFactory();
        this.cubeController = (CubeController)Mockito.mock(CubeController.class);
        this.dockerClientExecutor = (DockerClientExecutor)Mockito.mock(DockerClientExecutor.class);
        Mockito.when((Object)this.dockerClientExecutor.isDockerInsideDockerResolution()).thenReturn((Object)true);
        this.injector = (Injector)Mockito.mock(Injector.class);
        this.serviceLoader = (ServiceLoader)Mockito.mock(ServiceLoader.class);
        Mockito.when((Object)this.serviceLoader.all((Class)ArgumentMatchers.any(Class.class))).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.dockerClientExecutor.getDockerClient()).thenReturn((Object)((DockerClient)Mockito.mock(DockerClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS)));
        this.dockerContainerObjectFactory.serviceLoaderInstance = () -> this.serviceLoader;
        this.dockerContainerObjectFactory.dockerClientExecutorInstance = () -> this.dockerClientExecutor;
        this.dockerContainerObjectFactory.cubeRegistryInstance = () -> this.cubeRegistry;
        this.dockerContainerObjectFactory.cubeControllerInstance = () -> this.cubeController;
        this.dockerContainerObjectFactory.injectorInstance = () -> this.injector;
        CubeContainerObjectTestEnricherTest.deleteTestDirectory();
    }

    @Test
    public void shouldStartAContainerObject() {
        CubeContainerObjectTestEnricher cubeContainerObjectTestEnricher = new CubeContainerObjectTestEnricher();
        cubeContainerObjectTestEnricher.containerObjectFactoryInstance = () -> this.dockerContainerObjectFactory;
        Mockito.when((Object)this.serviceLoader.all(TestEnricher.class)).thenReturn(Arrays.asList(cubeContainerObjectTestEnricher));
        InjectableTest injectableTest = new InjectableTest();
        cubeContainerObjectTestEnricher.enrich((Object)injectableTest);
        org.arquillian.cube.spi.Cube mycontainer = this.cubeRegistry.getCube("mycontainer");
        Assert.assertThat((Object)mycontainer, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)mycontainer.hasMetadata(IsContainerObject.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((IsContainerObject)mycontainer.getMetadata(IsContainerObject.class)).getTestClass().getName(), (Matcher)Is.is((Object)InjectableTest.class.getName()));
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).start("mycontainer");
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).create("mycontainer");
    }

    @Test
    public void shouldShouldStartAContainerObjectDefinedUsingDescriptor() {
        CubeContainerObjectTestEnricher cubeContainerObjectTestEnricher = new CubeContainerObjectTestEnricher();
        cubeContainerObjectTestEnricher.containerObjectFactoryInstance = () -> this.dockerContainerObjectFactory;
        Mockito.when((Object)this.serviceLoader.all(TestEnricher.class)).thenReturn(Arrays.asList(cubeContainerObjectTestEnricher));
        SecondInjectableTest secondInjectableTest = new SecondInjectableTest();
        cubeContainerObjectTestEnricher.enrich((Object)secondInjectableTest);
        org.arquillian.cube.spi.Cube mycontainer = this.cubeRegistry.getCube("mycontainer2");
        Assert.assertThat((Object)mycontainer, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).start("mycontainer2");
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).create("mycontainer2");
        File generatedDirectory = CubeContainerObjectTestEnricherTest.findGeneratedDirectory();
        Assert.assertThat((Object)generatedDirectory, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)new File(generatedDirectory, "Dockerfile").exists(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldLinkInnerContainers() {
        CubeContainerObjectTestEnricher cubeContainerObjectTestEnricher = new CubeContainerObjectTestEnricher();
        cubeContainerObjectTestEnricher.containerObjectFactoryInstance = () -> this.dockerContainerObjectFactory;
        Mockito.when((Object)this.serviceLoader.all(TestEnricher.class)).thenReturn(Arrays.asList(cubeContainerObjectTestEnricher));
        ThirdInjetableTest thirdInjetableTest = new ThirdInjetableTest();
        cubeContainerObjectTestEnricher.enrich((Object)thirdInjetableTest);
        org.arquillian.cube.spi.Cube outterContainer = this.cubeRegistry.getCube("outter");
        Assert.assertThat((Object)outterContainer, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        DockerCube dockerCube = (DockerCube)outterContainer;
        Collection links = dockerCube.configuration().getLinks();
        Assert.assertThat((Object)links.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)links, (Matcher)CoreMatchers.hasItem((Object)org.arquillian.cube.docker.impl.client.config.Link.valueOf((String)"db:db")));
        org.arquillian.cube.spi.Cube innerContainer = this.cubeRegistry.getCube("inner");
        Assert.assertThat((Object)innerContainer, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).start("outter");
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).create("outter");
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).start("inner");
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).create("inner");
    }

    @Test
    public void shouldLinkInnerContainersWithoutLink() {
        CubeContainerObjectTestEnricher cubeContainerObjectTestEnricher = new CubeContainerObjectTestEnricher();
        cubeContainerObjectTestEnricher.containerObjectFactoryInstance = () -> this.dockerContainerObjectFactory;
        Mockito.when((Object)this.serviceLoader.all(TestEnricher.class)).thenReturn(Arrays.asList(cubeContainerObjectTestEnricher));
        FifthInjetableTest fifthInjetableTest = new FifthInjetableTest();
        cubeContainerObjectTestEnricher.enrich((Object)fifthInjetableTest);
        org.arquillian.cube.spi.Cube outterContainer = this.cubeRegistry.getCube("outter");
        Assert.assertThat((Object)outterContainer, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        DockerCube dockerCube = (DockerCube)outterContainer;
        Collection links = dockerCube.configuration().getLinks();
        Assert.assertThat((Object)links.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)links, (Matcher)CoreMatchers.hasItem((Object)org.arquillian.cube.docker.impl.client.config.Link.valueOf((String)"inner:inner")));
        org.arquillian.cube.spi.Cube innerContainer = this.cubeRegistry.getCube("inner");
        Assert.assertThat((Object)innerContainer, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).start("outter");
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).create("outter");
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).start("inner");
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).create("inner");
    }

    @Test
    public void shouldStartAContainerObjectDefinedAsImage() {
        CubeContainerObjectTestEnricher cubeContainerObjectTestEnricher = new CubeContainerObjectTestEnricher();
        cubeContainerObjectTestEnricher.containerObjectFactoryInstance = () -> this.dockerContainerObjectFactory;
        Mockito.when((Object)this.serviceLoader.all(TestEnricher.class)).thenReturn(Arrays.asList(cubeContainerObjectTestEnricher));
        FourthInjectableTest injectableTest = new FourthInjectableTest();
        cubeContainerObjectTestEnricher.enrich((Object)injectableTest);
        org.arquillian.cube.spi.Cube image = this.cubeRegistry.getCube("image");
        Assert.assertThat((Object)image, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)image.hasMetadata(IsContainerObject.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((IsContainerObject)image.getMetadata(IsContainerObject.class)).getTestClass().getName(), (Matcher)Is.is((Object)FourthInjectableTest.class.getName()));
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).start("image");
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).create("image");
        DockerCube dockerCube = (DockerCube)image;
        Assert.assertThat((Object)dockerCube.configuration().getImage().toImageRef(), (Matcher)Is.is((Object)"tomee:8-jre-1.7.2-webprofile"));
    }

    @Test
    public void shouldStartAContainerObjectDefinedAsImageAndEnvironmentVariables() {
        CubeContainerObjectTestEnricher cubeContainerObjectTestEnricher = new CubeContainerObjectTestEnricher();
        cubeContainerObjectTestEnricher.containerObjectFactoryInstance = () -> this.dockerContainerObjectFactory;
        Mockito.when((Object)this.serviceLoader.all(TestEnricher.class)).thenReturn(Arrays.asList(cubeContainerObjectTestEnricher));
        FifthInjectableTest injectableTest = new FifthInjectableTest();
        cubeContainerObjectTestEnricher.enrich((Object)injectableTest);
        org.arquillian.cube.spi.Cube image = this.cubeRegistry.getCube("image");
        Assert.assertThat((Object)image, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)image.hasMetadata(IsContainerObject.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((IsContainerObject)image.getMetadata(IsContainerObject.class)).getTestClass().getName(), (Matcher)Is.is((Object)FifthInjectableTest.class.getName()));
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).start("image");
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).create("image");
        DockerCube dockerCube = (DockerCube)image;
        Assert.assertThat((Object)dockerCube.configuration().getImage().toImageRef(), (Matcher)Is.is((Object)"tomee:8-jre-1.7.2-webprofile"));
        Assert.assertThat((Object)dockerCube.configuration().getEnv(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"a=b", "c=d"}));
    }

    @Test
    public void shouldStartAContainerObjectDefinedAsImageAndVolumesVariables() {
        CubeContainerObjectTestEnricher cubeContainerObjectTestEnricher = new CubeContainerObjectTestEnricher();
        cubeContainerObjectTestEnricher.containerObjectFactoryInstance = () -> this.dockerContainerObjectFactory;
        Mockito.when((Object)this.serviceLoader.all(TestEnricher.class)).thenReturn(Arrays.asList(cubeContainerObjectTestEnricher));
        SixthInjectableTest injectableTest = new SixthInjectableTest();
        cubeContainerObjectTestEnricher.enrich((Object)injectableTest);
        org.arquillian.cube.spi.Cube image = this.cubeRegistry.getCube("image");
        Assert.assertThat((Object)image, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)image.hasMetadata(IsContainerObject.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((IsContainerObject)image.getMetadata(IsContainerObject.class)).getTestClass().getName(), (Matcher)Is.is((Object)SixthInjectableTest.class.getName()));
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).start("image");
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).create("image");
        DockerCube dockerCube = (DockerCube)image;
        Assert.assertThat((Object)dockerCube.configuration().getImage().toImageRef(), (Matcher)Is.is((Object)"tomee:8-jre-1.7.2-webprofile"));
        Assert.assertThat((Object)dockerCube.configuration().getBinds(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"/mypath:/containerPath:Z", "/mypath2:/containerPath2:Z"}));
    }

    private static void deleteTestDirectory() {
        File tempDirectory = new File(System.getProperty("java.io.tmpdir"));
        File[] testsDirectories = tempDirectory.listFiles(CubeContainerObjectTestEnricherTest::testDirectoryFilter);
        if (testsDirectories != null) {
            for (File testDirectory : testsDirectories) {
                try {
                    FileUtils.deleteDirectory((File)testDirectory);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static File findGeneratedDirectory() {
        File tempDirectory = new File(System.getProperty("java.io.tmpdir"));
        File[] testsDirectories = tempDirectory.listFiles(CubeContainerObjectTestEnricherTest::testDirectoryFilter);
        if (testsDirectories != null && testsDirectories.length > 0) {
            return testsDirectories[0];
        }
        return null;
    }

    private static boolean testDirectoryFilter(File dir, String name) {
        return dir.isDirectory() && name.startsWith("arquilliancube_") && name.endsWith(".build");
    }

    private static class InjectableTest {
        @Cube(value="mycontainer")
        TestContainerObject testContainerObject;

        private InjectableTest() {
        }
    }

    private static class SecondInjectableTest {
        @Cube(value="mycontainer2")
        TestInnerDockerfileContainerObject testInnerDockerfileContainerObject;

        private SecondInjectableTest() {
        }
    }

    private static class ThirdInjetableTest {
        @Cube(value="outter")
        TestLinkedContainerObject testLinkedContainerObject;

        private ThirdInjetableTest() {
        }
    }

    private static class FifthInjetableTest {
        @Cube(value="outter")
        TestLinkedContainerObjectNoLink testLinkedContainerObjectNoLink;

        private FifthInjetableTest() {
        }
    }

    private static class FourthInjectableTest {
        @Cube(value="image")
        ImageContainerObject imageContainerObject;

        private FourthInjectableTest() {
        }
    }

    private static class FifthInjectableTest {
        @Cube(value="image")
        ImageWithEnvContainerObject imageContainerObject;

        private FifthInjectableTest() {
        }
    }

    private static class SixthInjectableTest {
        @Cube(value="image")
        @Volume(hostPath="/mypath2", containerPath="/containerPath2")
        VolumesContainerObject volumesContainerObject;

        private SixthInjectableTest() {
        }
    }

    public static class TestLinkContainerObject {
        @CubeDockerFile
        public static Archive<?> createDockerfile() {
            String dockerDescriptor = ((DockerDescriptor)Descriptors.create(DockerDescriptor.class)).from("mysql").exportAsString();
            return ((GenericArchive)ShrinkWrap.create(GenericArchive.class)).add((Asset)new StringAsset(dockerDescriptor), "Dockerfile");
        }
    }

    @Image(value="tomee:8-jre-1.7.2-webprofile")
    @Volume(hostPath="/mypath", containerPath="/containerPath")
    public static class VolumesContainerObject {
    }

    @Image(value="tomee:8-jre-1.7.2-webprofile")
    @Environments(value={@Environment(key="a", value="b"), @Environment(key="c", value="d")})
    public static class ImageWithEnvContainerObject {
    }

    @Image(value="tomee:8-jre-1.7.2-webprofile")
    public static class ImageContainerObject {
    }

    public static class TestLinkedContainerObjectNoLink {
        @Cube(value="inner")
        TestLinkContainerObject linkContainerObject;

        @CubeDockerFile
        public static Archive<?> createDockerfile() {
            String dockerDescriptor = ((DockerDescriptor)Descriptors.create(DockerDescriptor.class)).from("tomee").exportAsString();
            return ((GenericArchive)ShrinkWrap.create(GenericArchive.class)).add((Asset)new StringAsset(dockerDescriptor), "Dockerfile");
        }
    }

    public static class TestLinkedContainerObject {
        @Cube(value="inner")
        @Link(value="db:db")
        TestLinkContainerObject linkContainerObject;

        @CubeDockerFile
        public static Archive<?> createDockerfile() {
            String dockerDescriptor = ((DockerDescriptor)Descriptors.create(DockerDescriptor.class)).from("tomee").exportAsString();
            return ((GenericArchive)ShrinkWrap.create(GenericArchive.class)).add((Asset)new StringAsset(dockerDescriptor), "Dockerfile");
        }
    }

    public static class TestInnerDockerfileContainerObject {
        @CubeDockerFile
        public static Archive<?> createDockerfile() {
            String dockerDescriptor = ((DockerDescriptor)Descriptors.create(DockerDescriptor.class)).from("tomee").exportAsString();
            return ((GenericArchive)ShrinkWrap.create(GenericArchive.class)).add((Asset)new StringAsset(dockerDescriptor), "Dockerfile");
        }
    }

    @CubeDockerFile
    public static class TestContainerObject {
    }
}

