/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.containerobject.dsl;

import org.arquillian.cube.CubeController;
import org.arquillian.cube.docker.impl.client.containerobject.dsl.Container;
import org.arquillian.cube.docker.impl.client.containerobject.dsl.ContainerNetworkObjectDslTestEnricher;
import org.arquillian.cube.docker.impl.client.containerobject.dsl.DockerContainer;
import org.arquillian.cube.docker.impl.client.containerobject.dsl.DockerNetwork;
import org.arquillian.cube.docker.impl.client.containerobject.dsl.Network;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.model.LocalDockerNetworkRegistry;
import org.arquillian.cube.docker.impl.model.NetworkRegistry;
import org.arquillian.cube.impl.model.LocalCubeRegistry;
import org.arquillian.cube.spi.CubeRegistry;
import org.assertj.core.api.Assertions;
import org.jboss.arquillian.core.api.Injector;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ContainerNetworkObjectDslTestEnricherTest {
    private CubeRegistry cubeRegistry;
    private NetworkRegistry networkRegistry;
    private CubeController cubeController;
    private DockerClientExecutor dockerClientExecutor;

    @Before
    public void init() {
        this.cubeRegistry = new LocalCubeRegistry();
        this.networkRegistry = new LocalDockerNetworkRegistry();
        this.cubeController = (CubeController)Mockito.mock(CubeController.class);
        this.dockerClientExecutor = (DockerClientExecutor)Mockito.mock(DockerClientExecutor.class);
    }

    @Test
    public void should_start_a_network() {
        ContainerNetworkObjectDslTestEnricher containerNetworkObjectDslTestEnricher = new ContainerNetworkObjectDslTestEnricher();
        Injector injector = (Injector)Mockito.mock(Injector.class);
        containerNetworkObjectDslTestEnricher.injectorInstance = () -> injector;
        containerNetworkObjectDslTestEnricher.networkRegistryInstance = () -> this.networkRegistry;
        containerNetworkObjectDslTestEnricher.dockerClientExecutorInstance = () -> this.dockerClientExecutor;
        Mockito.lenient().when((Object)((Network)injector.inject((Object)((Network)ArgumentMatchers.any(Network.class))))).then(invocation -> invocation.getArgument(0, Network.class));
        Mockito.when((Object)this.dockerClientExecutor.createNetwork((String)ArgumentMatchers.eq((Object)"default"), (org.arquillian.cube.docker.impl.client.config.Network)ArgumentMatchers.any(org.arquillian.cube.docker.impl.client.config.Network.class))).thenReturn((Object)"default");
        containerNetworkObjectDslTestEnricher.enrich((Object)new NetworkTest());
        ((DockerClientExecutor)Mockito.verify((Object)this.dockerClientExecutor)).createNetwork((String)ArgumentMatchers.eq((Object)"default"), (org.arquillian.cube.docker.impl.client.config.Network)ArgumentMatchers.any(org.arquillian.cube.docker.impl.client.config.Network.class));
        Assertions.assertThat((Object)this.networkRegistry.getNetwork("default")).isNotNull();
    }

    @Test
    public void should_start_a_container() {
        Injector injector = new Injector(){

            public <T> T inject(T target) {
                return target;
            }
        };
        ContainerNetworkObjectDslTestEnricher containerNetworkObjectDslTestEnricher = new ContainerNetworkObjectDslTestEnricher();
        containerNetworkObjectDslTestEnricher.injectorInstance = () -> injector;
        containerNetworkObjectDslTestEnricher.cubeRegistryInstance = () -> this.cubeRegistry;
        containerNetworkObjectDslTestEnricher.cubeControllerInstance = () -> this.cubeController;
        containerNetworkObjectDslTestEnricher.dockerClientExecutorInstance = () -> this.dockerClientExecutor;
        containerNetworkObjectDslTestEnricher.enrich((Object)new SimpleContainerTest());
        ((CubeController)Mockito.verify((Object)this.cubeController)).create("mytomcat");
        ((CubeController)Mockito.verify((Object)this.cubeController)).start("mytomcat");
        Assertions.assertThat((Object)this.cubeRegistry.getCube("mytomcat")).isNotNull();
    }

    @Test
    public void should_start_multiple_containers_in_order() {
        Injector injector = new Injector(){

            public <T> T inject(T target) {
                return target;
            }
        };
        ContainerNetworkObjectDslTestEnricher containerNetworkObjectDslTestEnricher = new ContainerNetworkObjectDslTestEnricher();
        containerNetworkObjectDslTestEnricher.injectorInstance = () -> injector;
        containerNetworkObjectDslTestEnricher.cubeRegistryInstance = () -> this.cubeRegistry;
        containerNetworkObjectDslTestEnricher.cubeControllerInstance = () -> this.cubeController;
        containerNetworkObjectDslTestEnricher.dockerClientExecutorInstance = () -> this.dockerClientExecutor;
        containerNetworkObjectDslTestEnricher.enrich((Object)new MultipleContainerTest());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.cubeController});
        ((CubeController)inOrder.verify((Object)this.cubeController)).create("mytomcat3");
        ((CubeController)inOrder.verify((Object)this.cubeController)).create("mytomcat1");
        ((CubeController)inOrder.verify((Object)this.cubeController)).create("mytomcat2");
    }

    public static class NetworkTest {
        @DockerNetwork
        Network network = Network.withDefaultDriver((String)"default").build();
    }

    public static class SimpleContainerTest {
        @DockerContainer
        Container container = Container.withContainerName((String)"mytomcat").fromImage("tomcat").withPortBinding(new Integer[]{8080}).build();
    }

    public static class MultipleContainerTest {
        @DockerContainer(order=10)
        Container container1 = Container.withContainerName((String)"mytomcat1").fromImage("tomcat").withPortBinding(new Integer[]{8080}).build();
        @DockerContainer(order=5)
        Container container2 = Container.withContainerName((String)"mytomcat2").fromImage("tomcat").withPortBinding(new Integer[]{8080}).build();
        @DockerContainer(order=25)
        Container container3 = Container.withContainerName((String)"mytomcat3").fromImage("tomcat").withPortBinding(new Integer[]{8080}).build();
    }
}

