/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.arquillian.cube.docker.impl.util.GitHubUtil;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class GitHubUtilTest {
    @Test
    public void test_download_docker_machine() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        URL url = this.mockUrl(connection);
        String content = "{\"id\":\"1\", \"name\":\"v0.5.5\", \"tag_name\":\"v0.5.5\"}";
        Mockito.when((Object)connection.getInputStream()).thenReturn((Object)new ByteArrayInputStream(content.getBytes()));
        Assert.assertThat((Object)GitHubUtil.consumeHttp((URL)url).getTagName(), (Matcher)Is.is((Object)"v0.5.5"));
    }

    private URL mockUrl(final URLConnection con) throws IOException {
        URLStreamHandler urlHandler = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                return con;
            }
        };
        return new URL("http", "some-host", 0, "", urlHandler);
    }
}

