/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import java.util.HashMap;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.client.DefinitionFormat;
import org.arquillian.cube.docker.impl.util.SinglePortBindResolver;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SinglePortBindResolverTest {
    @Test
    public void should_resolve_single_bind_port() {
        String content = "tomcat:\n  image: tomcat:10.1.30\n  portBindings: [8080/tcp]\n  links:\n    - ping\nping:\n  image: tsongpon/pingpong\n  exposedPorts: [8089/tcp]\nstorage:\n  image: tutum/mongodb";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", content);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        int bindPort = SinglePortBindResolver.resolveBindPort((CubeDockerConfiguration)cubeConfiguration, (String[])new String[0]);
        Assert.assertThat((Object)bindPort, (Matcher)CoreMatchers.is((Object)8080));
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_throw_exception_with_resolve_two_bind_port() {
        String content = "tomcat:\n  image: tomcat:10.1.30\n  portBindings: [8080/tcp, 8081/tcp]\n  links:\n    - ping\nping:\n  image: tsongpon/pingpong\n  exposedPorts: [8089/tcp]\nstorage:\n  image: tutum/mongodb";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", content);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        int bindPort = SinglePortBindResolver.resolveBindPort((CubeDockerConfiguration)cubeConfiguration, (String[])new String[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_throw_exception_with_resolve_two_bind_port_from_different_containers() {
        String content = "tomcat:\n  image: tomcat:10.1.30\n  portBindings: [8080/tcp]\n  links:\n    - ping\nping:\n  image: tsongpon/pingpong\n  portBindings: [8081/tcp]\nstorage:\n  image: tutum/mongodb";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", content);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        int bindPort = SinglePortBindResolver.resolveBindPort((CubeDockerConfiguration)cubeConfiguration, (String[])new String[0]);
    }

    @Test
    public void should_resolve_two_bind_port_from_different_containers_with_exclusions() {
        String content = "tomcat:\n  image: tomcat:10.1.30\n  portBindings: [8080/tcp]\n  links:\n    - ping\nping:\n  image: tsongpon/pingpong\n  portBindings: [8081/tcp]\nstorage:\n  image: tutum/mongodb";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", content);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        int bindPort = SinglePortBindResolver.resolveBindPort((CubeDockerConfiguration)cubeConfiguration, (String[])new String[]{"ping"});
        Assert.assertThat((Object)bindPort, (Matcher)CoreMatchers.is((Object)8080));
    }

    @Test
    public void should_resolve_two_bind_port_from_different_containers_with_exposed_port() {
        String content = "tomcat:\n  image: tomcat:10.1.30\n  portBindings: [8080/tcp]\n  links:\n    - ping\nping:\n  image: tsongpon/pingpong\n  portBindings: [8081/tcp]\nstorage:\n  image: tutum/mongodb";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", content);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        int bindPort = SinglePortBindResolver.resolveBindPort((CubeDockerConfiguration)cubeConfiguration, (int)8080, (String[])new String[0]);
        Assert.assertThat((Object)bindPort, (Matcher)CoreMatchers.is((Object)8080));
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_throw_exception_when_resolve_two_bind_port_from_different_containers_with_same_exposed_port() {
        String content = "tomcat:\n  image: tomcat:10.1.30\n  portBindings: [8080/tcp]\n  links:\n    - ping\nping:\n  image: tsongpon/pingpong\n  portBindings: [8080/tcp]\nstorage:\n  image: tutum/mongodb";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", content);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        int bindPort = SinglePortBindResolver.resolveBindPort((CubeDockerConfiguration)cubeConfiguration, (int)8080, (String[])new String[0]);
    }

    @Test
    public void should_resolve_two_bind_port_from_different_containers_with_exposed_port_value_if_no_matches() {
        String content = "tomcat:\n  image: tomcat:10.1.30\n  portBindings: [8080/tcp]\n  links:\n    - ping\nping:\n  image: tsongpon/pingpong\n  portBindings: [8081/tcp]\nstorage:\n  image: tutum/mongodb";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", content);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        int bindPort = SinglePortBindResolver.resolveBindPort((CubeDockerConfiguration)cubeConfiguration, (int)8082, (String[])new String[0]);
        Assert.assertThat((Object)bindPort, (Matcher)CoreMatchers.is((Object)8082));
    }
}

