/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.await;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.core.async.ResultCallbackTemplate;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.arquillian.cube.docker.impl.await.SleepingAwaitStrategyBase;
import org.arquillian.cube.docker.impl.client.config.Await;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.spi.Cube;

public class LogScanningAwaitStrategy
extends SleepingAwaitStrategyBase {
    public static final String TAG = "log";
    private static final Logger logger = Logger.getLogger(LogScanningAwaitStrategy.class.getName());
    private static final String REGEXP_PREFIX = "regexp:";
    private final LogMatcher matcher;
    private int timeout = 15;
    private boolean stdOut;
    private boolean stdErr;
    private int occurrences = 1;
    private Cube<?> cube;
    private DockerClientExecutor dockerClientExecutor;

    public LogScanningAwaitStrategy(Cube<?> cube, DockerClientExecutor dockerClientExecutor, Await params) {
        super(params.getSleepPollingTime());
        this.cube = cube;
        this.dockerClientExecutor = dockerClientExecutor;
        this.stdOut = params.isStdOut();
        this.stdErr = params.isStdErr();
        this.occurrences = params.getOccurrences();
        this.matcher = params.getMatch().startsWith(REGEXP_PREFIX) ? new RegexpLogMatcher(params.getMatch().substring(REGEXP_PREFIX.length())) : new ContainsLogMatcher(params.getMatch());
        if (params.getTimeout() != null) {
            this.timeout = params.getTimeout();
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isStdOut() {
        return this.stdOut;
    }

    public boolean isStdErr() {
        return this.stdErr;
    }

    public int getOccurrences() {
        return this.occurrences;
    }

    public boolean await() {
        boolean bl;
        DockerClient client = this.dockerClientExecutor.getDockerClient();
        CountDownLatch containerUp = new CountDownLatch(1);
        LogContainerResultCallback callback = new LogContainerResultCallback(containerUp, this.occurrences);
        try {
            client.logContainerCmd(this.cube.getId()).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).exec((ResultCallback)callback);
            bl = containerUp.await(this.timeout, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            try {
                try {
                    callback.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | InterruptedException e) {
                logger.log(Level.SEVERE, String.format("Log Await Strategy failed with %s", e.getMessage()));
                return false;
            }
        }
        callback.close();
        return bl;
    }

    private static final class RegexpLogMatcher
    implements LogMatcher {
        private Pattern regex;

        public RegexpLogMatcher(String pattern) {
            this.regex = Pattern.compile(pattern, 32);
        }

        @Override
        public boolean match(String line) {
            return this.regex.matcher(line).matches();
        }
    }

    private static interface LogMatcher {
        public boolean match(String var1);
    }

    private static final class ContainsLogMatcher
    implements LogMatcher {
        private String substring;

        public ContainsLogMatcher(String substring) {
            this.substring = substring;
        }

        @Override
        public boolean match(String line) {
            return line.contains(this.substring);
        }
    }

    private class LogContainerResultCallback
    extends ResultCallbackTemplate<LogContainerResultCallback, Frame> {
        private CountDownLatch containerUp;
        private int occurrences;

        public LogContainerResultCallback(CountDownLatch containerUp, int occurrences) {
            this.containerUp = containerUp;
            this.occurrences = occurrences;
        }

        public void onNext(Frame item) {
            String line = new String(item.getPayload());
            if (LogScanningAwaitStrategy.this.matcher.match(line)) {
                --this.occurrences;
                if (this.occurrences == 0) {
                    this.containerUp.countDown();
                }
            }
        }
    }
}

