/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.containerobject.dsl;

import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.model.NetworkRegistry;
import org.arquillian.cube.spi.metadata.IsNetworkContainerObject;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;

public class AfterClassNetworkContainerObserver {
    private static Logger logger = Logger.getLogger(AfterClassNetworkContainerObserver.class.getName());
    @Inject
    Instance<DockerClientExecutor> dockerClientExecutorInstance;
    @Inject
    private Instance<NetworkRegistry> networkRegistryInstance;

    public void stopNetworkObjects(@Observes(precedence=90) AfterClass afterClass) {
        NetworkRegistry networkRegistry = (NetworkRegistry)this.networkRegistryInstance.get();
        List networksToRemove = networkRegistry.getNetworkIds().stream().filter(id -> networkRegistry.getNetwork((String)id).hasMetadata(IsNetworkContainerObject.class)).collect(Collectors.toList());
        networksToRemove.stream().forEach(id -> {
            logger.fine(String.format("Stopping Network %s", id));
            ((DockerClientExecutor)this.dockerClientExecutorInstance.get()).removeNetwork((String)id);
            networkRegistry.removeNetwork((String)id);
        });
    }
}

