/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.containerobject.dsl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import org.arquillian.cube.CubeController;
import org.arquillian.cube.docker.impl.client.containerobject.dsl.Container;
import org.arquillian.cube.docker.impl.client.containerobject.dsl.DockerContainer;
import org.arquillian.cube.docker.impl.client.containerobject.dsl.DockerNetwork;
import org.arquillian.cube.docker.impl.client.containerobject.dsl.Network;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.model.DockerCube;
import org.arquillian.cube.docker.impl.model.NetworkRegistry;
import org.arquillian.cube.impl.util.ReflectionUtil;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.metadata.CubeMetadata;
import org.arquillian.cube.spi.metadata.IsContainerObject;
import org.arquillian.cube.spi.metadata.IsNetworkContainerObject;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestEnricher;

public class ContainerNetworkObjectDslTestEnricher
implements TestEnricher {
    private static final Logger logger = Logger.getLogger(ContainerNetworkObjectDslTestEnricher.class.getName());
    @Inject
    Instance<CubeController> cubeControllerInstance;
    @Inject
    Instance<CubeRegistry> cubeRegistryInstance;
    @Inject
    Instance<DockerClientExecutor> dockerClientExecutorInstance;
    @Inject
    Instance<NetworkRegistry> networkRegistryInstance;
    @Inject
    Instance<Injector> injectorInstance;

    public void enrich(Object testCase) {
        this.startNetworks(testCase);
        this.startContainers(testCase);
    }

    private void startContainers(Object testCase) {
        List containerFields = ReflectionUtil.getFieldsWithAnnotation(testCase.getClass(), DockerContainer.class);
        Collections.sort(containerFields, Comparator.comparingInt(f -> f.getAnnotation(DockerContainer.class).order()));
        Collections.reverse(containerFields);
        for (Field field : containerFields) {
            try {
                Object object = field.get(testCase);
                if (Container.class.isAssignableFrom(object.getClass())) {
                    Container containerObject = (Container)object;
                    Container enrichedContainer = (Container)((Injector)this.injectorInstance.get()).inject((Object)containerObject);
                    field.set(testCase, enrichedContainer);
                    this.startContainer(enrichedContainer, testCase.getClass());
                    continue;
                }
                throw new IllegalArgumentException(String.format("Object %s is not assignable to %s.", object.getClass(), Container.class.getName()));
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private void startNetworks(Object testCase) {
        List networkFields = ReflectionUtil.getFieldsWithAnnotation(testCase.getClass(), DockerNetwork.class);
        for (Field field : networkFields) {
            try {
                Object object = field.get(testCase);
                if (Network.class.isAssignableFrom(object.getClass())) {
                    Network networkObject = (Network)object;
                    this.startNetwork(networkObject);
                    continue;
                }
                throw new IllegalArgumentException(String.format("Object %s is not assignable to %s.", object.getClass(), Network.class.getName()));
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public Object[] resolve(Method method) {
        return new Object[0];
    }

    private void startNetwork(Network network) {
        org.arquillian.cube.docker.impl.client.config.Network dockerNetwork = network.getNetwork();
        String id = ((DockerClientExecutor)this.dockerClientExecutorInstance.get()).createNetwork(network.getId(), dockerNetwork);
        dockerNetwork.addMetadata(IsNetworkContainerObject.class, new IsNetworkContainerObject());
        ((NetworkRegistry)this.networkRegistryInstance.get()).addNetwork(id, dockerNetwork);
    }

    private void startContainer(Container container, Class<?> testClass) {
        String containerName = container.getContainerName();
        if (this.isNotInitialized(containerName)) {
            DockerCube dockerCube = new DockerCube(containerName, container.getCubeContainer(), (DockerClientExecutor)this.dockerClientExecutorInstance.get());
            dockerCube.addMetadata(IsContainerObject.class, (CubeMetadata)new IsContainerObject(testClass, container.getConnectionMode()));
            logger.finer(String.format("Created Cube with name %s and configuration %s", containerName, dockerCube.configuration()));
            ((CubeRegistry)this.cubeRegistryInstance.get()).addCube((Cube)((Injector)this.injectorInstance.get()).inject((Object)dockerCube));
            CubeController cubeController = (CubeController)this.cubeControllerInstance.get();
            cubeController.create(containerName);
            cubeController.start(containerName);
        }
    }

    private boolean isNotInitialized(String containerName) {
        return ((CubeRegistry)this.cubeRegistryInstance.get()).getCube(containerName) == null;
    }
}

