/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.client.CubeDockerConfigurator;
import org.arquillian.cube.docker.impl.client.DefinitionFormat;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.DockerCompositions;
import org.arquillian.cube.docker.impl.client.config.ExposedPort;
import org.arquillian.cube.docker.impl.client.config.Link;
import org.arquillian.cube.docker.impl.client.config.Network;
import org.arquillian.cube.docker.impl.client.config.PortBinding;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CubeConfigurationTest {
    private static final String CONTENT = "tomcat:\n  image: tomcat:10.1.30\n  exposedPorts: [8089/tcp]\n  await:\n    strategy: static\n    ip: localhost\n    ports: [8080, 8089]";
    private static final String CONTENT2 = "tomcat2:\n  image: tomcat:10.1.30\n  exposedPorts: [8089/tcp]\n  await:\n    strategy: static\n    ip: localhost\n    ports: [8080, 8089]";
    private static final String DOCKER_COMPOSE_CONTENT = "web:\n  build: .\n  ports:\n   - \"5432:5000\"\n  volumes:\n   - .:/code\n  links:\n   - redis\nredis:\n  image: redis";
    private static final String OVERRIDE_CUSTOM = "tomcat:\n  image: tomcat:10.1.30\n  await:\n    strategy: polling\n  afterStart: \n    - copy:\n        from: /tmp\n        to: /test\n  beforeStop: \n    - copy:\n        from: /test\n        to: /tmp\n  afterStop: \n    - copy:\n        from: /test\n        to: /tmp";
    private static final String VERSION_2_WITH_VOLUMES = "version: '2'\nservices:\n  nginx:\n    image: \"nginx:alpine\"\n    ports:\n    - \"80\"\n    volumes:\n    - \"/tmp/www:/usr/share/nginx/html\"";
    private static final String VERSION_2_WITH_PORT_RANGE = "version: '2'\nservices:\n  nginx:\n    image: \"nginx:alpine\"\n    ports:\n    - \"80-84:90-94\"\n    volumes:\n    - \"/tmp/www:/usr/share/nginx/html\"";
    private static final String VERSION_2_WITH_SPACE_SEPERATED_COMMAND = "version: '2'\nservices:\n  wildfly:\n    image: \"quay.io/wildfly/wildfly:33.0.2.Final-jdk11\"\n    command: /opt/jboss/wildfly/bin/standalone.sh -b 0.0.0.0 -bmanagement 0.0.0.0";
    private static final String VERSION_2_WITH_SPACE_AND_QUOTES_SEPERATED_COMMAND = "version: '2'\nservices:\n  wildfly:\n    image: \"quay.io/wildfly/wildfly:33.0.2.Final-jdk11\"\n    command: \"/opt/jboss/wildfly/bin/standalone.sh -b 0.0.0.0 -bmanagement 0.0.0.0\"";
    private static final String VERSION_2_WITH_ARRAY_COMMAND = "version: '2'\nservices:\n  wildfly:\n    image: \"quay.io/wildfly/wildfly:33.0.2.Final-jdk11\"\n    command: [\"/opt/jboss/wildfly/bin/standalone.sh\", \"-b\", \"0.0.0.0\", \"-bmanagement\", \"0.0.0.0\"]";
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    @Test
    public void shouldSplitCmdOnSpaces() {
        this.testCmdSplittedOnSpaces(VERSION_2_WITH_SPACE_SEPERATED_COMMAND, new String[]{"/opt/jboss/wildfly/bin/standalone.sh", "-b", "0.0.0.0", "-bmanagement", "0.0.0.0"});
    }

    @Test
    public void shouldSplitCmdWihtQuotesOnSpaces() {
        this.testCmdSplittedOnSpaces(VERSION_2_WITH_SPACE_AND_QUOTES_SEPERATED_COMMAND, new String[]{"/opt/jboss/wildfly/bin/standalone.sh", "-b", "0.0.0.0", "-bmanagement", "0.0.0.0"});
    }

    @Test
    public void shouldSplitCmdWithArray() {
        this.testCmdSplittedOnSpaces(VERSION_2_WITH_ARRAY_COMMAND, new String[]{"/opt/jboss/wildfly/bin/standalone.sh", "-b", "0.0.0.0", "-bmanagement", "0.0.0.0"});
    }

    private void testCmdSplittedOnSpaces(String composeDefinition, String[] expectedInOrderCmds) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverVersion", "1.13");
        parameters.put("serverUri", "http://localhost:25123");
        parameters.put("dockerContainers", composeDefinition);
        parameters.put("definitionFormat", DefinitionFormat.COMPOSE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        DockerCompositions dockerContainersContent = cubeConfiguration.getDockerContainersContent();
        CubeContainer wildfly = dockerContainersContent.get("wildfly");
        Collection commands = wildfly.getCmd();
        Assert.assertThat((Object)commands, (Matcher)IsIterableContainingInOrder.contains((Object[])expectedInOrderCmds));
    }

    @Test
    public void should_expand_ports_from_docker_compose_version_2() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverVersion", "1.13");
        parameters.put("serverUri", "http://localhost:25123");
        parameters.put("dockerContainers", VERSION_2_WITH_PORT_RANGE);
        parameters.put("definitionFormat", DefinitionFormat.COMPOSE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        DockerCompositions dockerContainersContent = cubeConfiguration.getDockerContainersContent();
        CubeContainer ngnix = dockerContainersContent.get("nginx");
        Collection portBindings = ngnix.getPortBindings();
        Assert.assertThat((Object)portBindings, (Matcher)Matchers.containsInAnyOrder((Object[])new PortBinding[]{PortBinding.valueOf((String)"80->90"), PortBinding.valueOf((String)"81->91"), PortBinding.valueOf((String)"82->92"), PortBinding.valueOf((String)"83->93"), PortBinding.valueOf((String)"84->94")}));
    }

    @Test
    public void should_load_volumes_from_docker_compose_version_2() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverVersion", "1.13");
        parameters.put("serverUri", "http://localhost:25123");
        parameters.put("dockerContainers", VERSION_2_WITH_VOLUMES);
        parameters.put("definitionFormat", DefinitionFormat.COMPOSE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        DockerCompositions dockerContainersContent = cubeConfiguration.getDockerContainersContent();
        CubeContainer ngnix = dockerContainersContent.get("nginx");
        Collection volumes = ngnix.getVolumes();
        String volume = (String)volumes.iterator().next();
        Assert.assertThat((Object)volume, (Matcher)CoreMatchers.is((Object)"/tmp/www:/usr/share/nginx/html"));
        Collection binds = ngnix.getBinds();
        String bind = (String)volumes.iterator().next();
        Assert.assertThat((Object)bind, (Matcher)CoreMatchers.is((Object)"/tmp/www:/usr/share/nginx/html"));
    }

    @Test
    public void shouldChangeNamesInParallelizeStarCubes() {
        String content = "tomcat*:\n  image: tomcat:10.1.30\n  portBindings: [8080/tcp]\n  links:\n    - ping*\nping*:\n  image: tsongpon/pingpong\n  exposedPorts: [8089/tcp]\nstorage:\n  image: tutum/mongodb";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", content);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        CubeDockerConfigurator cubeDockerConfigurator = new CubeDockerConfigurator();
        CubeDockerConfiguration cubeDockerConfiguration = cubeDockerConfigurator.resolveDynamicNames(cubeConfiguration);
        Set containerIds = cubeDockerConfiguration.getDockerContainersContent().getContainerIds();
        String tomcat = this.findElementStartingWith(containerIds, "tomcat");
        Assert.assertThat((Object)tomcat.length(), (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(6))));
        String ping = this.findElementStartingWith(containerIds, "ping");
        Assert.assertThat((Object)ping.length(), (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(4))));
    }

    @Test
    public void shouldAddEnvVarsWithHostNameInParallelizeStarCubes() {
        String content = "tomcat*:\n  image: tomcat:10.1.30\n  portBindings: [8080/tcp]\n  links:\n    - ping*\nping*:\n  image: tsongpon/pingpong\n  exposedPorts: [8089/tcp]\nstorage:\n  image: tutum/mongodb";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", content);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        CubeDockerConfigurator cubeDockerConfigurator = new CubeDockerConfigurator();
        CubeDockerConfiguration cubeDockerConfiguration = cubeDockerConfigurator.resolveDynamicNames(cubeConfiguration);
        Set containerIds = cubeDockerConfiguration.getDockerContainersContent().getContainerIds();
        String tomcat = this.findElementStartingWith(containerIds, "tomcat");
        String ping = this.findElementStartingWith(containerIds, "ping");
        CubeContainer tomcatContainer = cubeDockerConfiguration.getDockerContainersContent().get(tomcat);
        Assert.assertThat((Object)((String)this.getFirst(tomcatContainer.getEnv())), (Matcher)CoreMatchers.is((Object)("PING_HOSTNAME=" + ping)));
    }

    @Test
    public void shouldChangePortBindingToPrivatePortsInParallelizeStarCubes() {
        String content = "tomcat*:\n  image: tomcat:10.1.30\n  portBindings: [8080/tcp]\n  links:\n    - ping*\nping*:\n  image: tsongpon/pingpong\n  exposedPorts: [8089/tcp]\nstorage:\n  image: tutum/mongodb";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", content);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        CubeDockerConfigurator cubeDockerConfigurator = new CubeDockerConfigurator();
        CubeDockerConfiguration cubeDockerConfiguration = cubeDockerConfigurator.resolveDynamicNames(cubeConfiguration);
        Set containerIds = cubeDockerConfiguration.getDockerContainersContent().getContainerIds();
        String tomcat = this.findElementStartingWith(containerIds, "tomcat");
        CubeContainer tomcatContainer = cubeDockerConfiguration.getDockerContainersContent().get(tomcat);
        Assert.assertThat((Object)((PortBinding)this.getFirst(tomcatContainer.getPortBindings())).getBound(), (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(49152))));
    }

    @Test
    public void shouldChangeStarLinksInParallelizeStarCubes() {
        String content = "tomcat*:\n  image: tomcat:10.1.30\n  portBindings: [8080/tcp]\n  links:\n    - ping*\nping*:\n  image: tsongpon/pingpong\n  exposedPorts: [8089/tcp]\nstorage:\n  image: tutum/mongodb";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", content);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        CubeDockerConfigurator cubeDockerConfigurator = new CubeDockerConfigurator();
        CubeDockerConfiguration cubeDockerConfiguration = cubeDockerConfigurator.resolveDynamicNames(cubeConfiguration);
        Set containerIds = cubeDockerConfiguration.getDockerContainersContent().getContainerIds();
        String tomcat = this.findElementStartingWith(containerIds, "tomcat");
        String ping = this.findElementStartingWith(containerIds, "ping");
        CubeContainer tomcatContainer = cubeDockerConfiguration.getDockerContainersContent().get(tomcat);
        Assert.assertThat((Object)((Link)this.getFirst(tomcatContainer.getLinks())).getName(), (Matcher)CoreMatchers.is((Object)ping));
    }

    @Test
    public void shouldParallelizeStarCubesUsingRemappingAlias() {
        String content = "tomcat*:\n  image: tomcat:10.1.30\n  portBindings: [8080/tcp]\n  links:\n    - ping*:bb\nping*:\n  image: tsongpon/pingpong\n  exposedPorts: [8089/tcp]\nstorage:\n  image: tutum/mongodb";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", content);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        CubeDockerConfigurator cubeDockerConfigurator = new CubeDockerConfigurator();
        CubeDockerConfiguration cubeDockerConfiguration = cubeDockerConfigurator.resolveDynamicNames(cubeConfiguration);
        Set containerIds = cubeDockerConfiguration.getDockerContainersContent().getContainerIds();
        String tomcat = this.findElementStartingWith(containerIds, "tomcat");
        String ping = this.findElementStartingWith(containerIds, "ping");
        String uuid = ping.substring(ping.indexOf(95) + 1);
        CubeContainer tomcatContainer = cubeDockerConfiguration.getDockerContainersContent().get(tomcat);
        Link link = (Link)this.getFirst(tomcatContainer.getLinks());
        Assert.assertThat((Object)link.getAlias(), (Matcher)CoreMatchers.is((Object)("bb_" + uuid)));
    }

    @Test
    public void shouldParallelizeNetworks() {
        String content = "networks:\n  network1*:\n    driver: bridge\n  network2:\n    driver: bridge\n  network3*:\n    driver: bridge\ntomcat:\n  image: tomcat:10.1.30\n  networkMode: network3*\nping:\n  image: tsongpon/pingpong\n  networks:\n    - network1*\n    - network2\n";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", content);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        CubeDockerConfigurator cubeDockerConfigurator = new CubeDockerConfigurator();
        CubeDockerConfiguration cubeDockerConfiguration = cubeDockerConfigurator.resolveDynamicNames(cubeConfiguration);
        DockerCompositions dockerContainersContent = cubeDockerConfiguration.getDockerContainersContent();
        Set networkIds = dockerContainersContent.getNetworkIds();
        String network1 = this.findElementStartingWith(networkIds, "network1");
        Assert.assertThat((Object)network1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)"network1*")));
        String network2 = this.findElementStartingWith(networkIds, "network2");
        Assert.assertThat((Object)network2, (Matcher)CoreMatchers.is((Object)"network2"));
        String network3 = this.findElementStartingWith(networkIds, "network3");
        Assert.assertThat((Object)network3, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)"network3*")));
        CubeContainer tomcat = dockerContainersContent.get("tomcat");
        Assert.assertThat((Object)tomcat.getNetworkMode(), (Matcher)CoreMatchers.is((Object)network3));
        CubeContainer ping = dockerContainersContent.get("ping");
        Assert.assertThat((Object)ping.getNetworks(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{network1, network2}));
    }

    private <T> T getFirst(Collection<T> collection) {
        return collection.iterator().next();
    }

    private String findElementStartingWith(Set<String> elements, String startsWith) {
        for (String element : elements) {
            if (!element.startsWith(startsWith)) continue;
            return element;
        }
        return null;
    }

    @Test
    public void should_override_custom_cube_properties() throws IOException {
        File newFile = this.testFolder.newFile("config.yaml");
        Files.write(Paths.get(newFile.toURI()), CONTENT.getBytes(), new OpenOption[0]);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverVersion", "1.13");
        parameters.put("serverUri", "http://localhost:25123");
        parameters.put("dockerContainersFiles", newFile.toURI().toString());
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        parameters.put("cubeSpecificProperties", OVERRIDE_CUSTOM);
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        DockerCompositions dockerContainersContent = cubeConfiguration.getDockerContainersContent();
        CubeContainer tomcat = dockerContainersContent.get("tomcat");
        Assert.assertThat((Object)tomcat, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)tomcat.getImage().getTag(), (Matcher)CoreMatchers.is((Object)"10.1.30"));
        Assert.assertThat((Object)tomcat.getAwait().getStrategy(), (Matcher)CoreMatchers.is((Object)"polling"));
        Assert.assertThat((Object)tomcat.getAfterStart().size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)tomcat.getBeforeStop().size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void should_merge_more_than_one_file_into_one() throws IOException {
        File newFile = this.testFolder.newFile("config.yaml");
        Files.write(Paths.get(newFile.toURI()), CONTENT.getBytes(), new OpenOption[0]);
        File newFile2 = this.testFolder.newFile("config2.yaml");
        Files.write(Paths.get(newFile2.toURI()), CONTENT2.getBytes(), new OpenOption[0]);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("serverVersion", "1.13");
        parameters.put("serverUri", "http://localhost:25123");
        parameters.put("dockerContainersFiles", newFile.toURI().toString() + ", " + newFile2.toURI().toString());
        parameters.put("definitionFormat", DefinitionFormat.COMPOSE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        DockerCompositions dockerContainersContent = cubeConfiguration.getDockerContainersContent();
        Assert.assertThat((Object)dockerContainersContent.get("tomcat"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)dockerContainersContent.get("tomcat2"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void should_load_docker_compose_format() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverVersion", "1.13");
        parameters.put("serverUri", "http://localhost:25123");
        parameters.put("dockerContainers", DOCKER_COMPOSE_CONTENT);
        parameters.put("definitionFormat", DefinitionFormat.COMPOSE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        DockerCompositions dockerContainersContent = cubeConfiguration.getDockerContainersContent();
        CubeContainer actualWeb = dockerContainersContent.get("web");
        Assert.assertThat((Object)actualWeb.getBuildImage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)actualWeb.getPortBindings(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)actualWeb.getVolumes(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)actualWeb.getLinks(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        CubeContainer actualRedis = dockerContainersContent.get("redis");
        Assert.assertThat((Object)actualRedis.getImage(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void should_load_cube_configuration_from_cube_file_if_no_file_is_provided() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverVersion", "1.13");
        parameters.put("serverUri", "http://localhost:25123");
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        DockerCompositions dockerContainersContent = cubeConfiguration.getDockerContainersContent();
        CubeContainer actualTomcat = dockerContainersContent.get("tomcat");
        Assert.assertThat((Object)actualTomcat, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        String image = actualTomcat.getImage().toImageRef();
        Assert.assertThat((Object)image, (Matcher)CoreMatchers.is((Object)"tomcat:10.1.30"));
    }

    @Test
    public void should_parse_and_load_configuration_file() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverVersion", "1.13");
        parameters.put("serverUri", "http://localhost:25123");
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        parameters.put("dockerContainers", CONTENT);
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        Assert.assertThat((Object)cubeConfiguration.getDockerServerUri(), (Matcher)CoreMatchers.is((Object)"http://localhost:25123"));
        Assert.assertThat((Object)cubeConfiguration.getDockerServerVersion(), (Matcher)CoreMatchers.is((Object)"1.13"));
        DockerCompositions dockerContainersContent = cubeConfiguration.getDockerContainersContent();
        CubeContainer actualTomcat = dockerContainersContent.get("tomcat");
        Assert.assertThat((Object)actualTomcat, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        String image = actualTomcat.getImage().toImageRef();
        Assert.assertThat((Object)image, (Matcher)CoreMatchers.is((Object)"tomcat:10.1.30"));
    }

    @Test
    public void should_parse_and_load_configuration_file_from_container_configuration_file_and_property_set_file() throws IOException {
        File newFile = this.testFolder.newFile("config.yml");
        Files.write(Paths.get(newFile.toURI()), CONTENT.getBytes(), new OpenOption[0]);
        File newFile2 = this.testFolder.newFile("config.demo.yml");
        Files.write(Paths.get(newFile2.toURI()), CONTENT2.getBytes(), new OpenOption[0]);
        System.setProperty("cube.environment", "demo");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverVersion", "1.13");
        parameters.put("serverUri", "http://localhost:25123");
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        parameters.put("dockerContainersFile", newFile.toURI().toString());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        Assert.assertThat((Object)cubeConfiguration.getDockerServerUri(), (Matcher)CoreMatchers.is((Object)"http://localhost:25123"));
        Assert.assertThat((Object)cubeConfiguration.getDockerServerVersion(), (Matcher)CoreMatchers.is((Object)"1.13"));
        DockerCompositions dockerContainersContent = cubeConfiguration.getDockerContainersContent();
        CubeContainer actualTomcat = dockerContainersContent.get("tomcat");
        Assert.assertThat((Object)actualTomcat, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        String image = actualTomcat.getImage().toImageRef();
        Assert.assertThat((Object)image, (Matcher)CoreMatchers.is((Object)"tomcat:10.1.30"));
        Assert.assertThat((Object)dockerContainersContent.get("tomcat2"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void should_parse_and_load_configuration_file_from_container_configuration_file() throws IOException {
        File newFile = this.testFolder.newFile("config.yaml");
        Files.write(Paths.get(newFile.toURI()), CONTENT.getBytes(), new OpenOption[0]);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverVersion", "1.13");
        parameters.put("serverUri", "http://localhost:25123");
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        parameters.put("dockerContainersFile", newFile.toURI().toString());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        Assert.assertThat((Object)cubeConfiguration.getDockerServerUri(), (Matcher)CoreMatchers.is((Object)"http://localhost:25123"));
        Assert.assertThat((Object)cubeConfiguration.getDockerServerVersion(), (Matcher)CoreMatchers.is((Object)"1.13"));
        DockerCompositions dockerContainersContent = cubeConfiguration.getDockerContainersContent();
        CubeContainer actualTomcat = dockerContainersContent.get("tomcat");
        Assert.assertThat((Object)actualTomcat, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        String image = actualTomcat.getImage().toImageRef();
        Assert.assertThat((Object)image, (Matcher)CoreMatchers.is((Object)"tomcat:10.1.30"));
    }

    @Test
    public void should_parse_and_load_configuration_from_container_configuration_resource() throws IOException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverVersion", "1.13");
        parameters.put("serverUri", "http://localhost:25123");
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        parameters.put("dockerContainersResource", "test-topologies/topology1.yaml");
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        Assert.assertThat((Object)cubeConfiguration.getDockerServerUri(), (Matcher)CoreMatchers.is((Object)"http://localhost:25123"));
        Assert.assertThat((Object)cubeConfiguration.getDockerServerVersion(), (Matcher)CoreMatchers.is((Object)"1.13"));
        DockerCompositions dockerContainersContent = cubeConfiguration.getDockerContainersContent();
        CubeContainer actualTomcat = dockerContainersContent.get("tomcat");
        Assert.assertThat((Object)actualTomcat, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        String image = actualTomcat.getImage().toImageRef();
        Assert.assertThat((Object)image, (Matcher)CoreMatchers.is((Object)"tomcat:10.1.30"));
    }

    @Test
    public void should_be_able_to_extend_and_override_toplevel() throws Exception {
        String config = "tomcat9:\n  image: tomcat:9.0.95\n  exposedPorts: [8089/tcp]\n  await:\n    strategy: static\n    ip: localhost\n    ports: [8080, 8089]\ntomcat10:\n  extends: tomcat9\n  image: tomcat:10.1.30\n";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", config);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        CubeContainer tomcat10 = cubeConfiguration.getDockerContainersContent().get("tomcat10");
        Assert.assertEquals((Object)"tomcat:10.1.30", (Object)tomcat10.getImage().toImageRef());
        Assert.assertTrue((tomcat10.getAwait() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"8089/tcp", (Object)((ExposedPort)tomcat10.getExposedPorts().iterator().next()).toString());
    }

    @Test
    public void should_be_able_to_read_network_configuration() {
        String config = "networks:\n  mynetwork:\n     driver: bridge\ntomcat9:\n  image: tomcat:9.0.95\n  exposedPorts: [8089/tcp]\n  await:\n    strategy: static\n    ip: localhost\n    ports: [8080, 8089]\ntomcat10:\n  extends: tomcat9\n  image: tomcat:10.1.30\n";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", config);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        Network mynetwork = cubeConfiguration.getDockerContainersContent().getNetwork("mynetwork");
        Assert.assertThat((Object)mynetwork, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)mynetwork.getDriver(), (Matcher)CoreMatchers.is((Object)"bridge"));
    }

    @Test
    public void should_set_global_removeVolumes_option_if_not_set_on_container_level() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", CONTENT);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        CubeContainer containerConfig = cubeConfiguration.getDockerContainersContent().get("tomcat");
        Assert.assertThat((Object)containerConfig.getRemoveVolumes(), (Matcher)CoreMatchers.is((Object)true));
        parameters.put("removeVolumes", "true");
        cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        containerConfig = cubeConfiguration.getDockerContainersContent().get("tomcat");
        Assert.assertThat((Object)containerConfig.getRemoveVolumes(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void should_container_level_removeVolumes_option_overwrite_global_value() {
        String config1 = "tomcat:\n  image: tomcat:10.1.30\n  removeVolumes: false";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("removeVolumes", "true");
        parameters.put("dockerContainers", config1);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        CubeContainer containerConfig = cubeConfiguration.getDockerContainersContent().get("tomcat");
        Assert.assertThat((Object)containerConfig.getRemoveVolumes(), (Matcher)CoreMatchers.is((Object)false));
        String config2 = "tomcat:\n  image: tomcat:10.1.30\n  removeVolumes: true";
        parameters.put("removeVolumes", "false");
        parameters.put("dockerContainers", config2);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        containerConfig = cubeConfiguration.getDockerContainersContent().get("tomcat");
        Assert.assertThat((Object)containerConfig.getRemoveVolumes(), (Matcher)CoreMatchers.is((Object)true));
    }
}

