/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InfoCmd;
import com.github.dockerjava.api.model.Info;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.ProcessingException;
import org.arquillian.cube.docker.impl.client.CubeDockerConfigurationResolver;
import org.arquillian.cube.docker.impl.util.DefaultDocker;
import org.arquillian.cube.docker.impl.util.OperatingSystem;
import org.arquillian.cube.docker.impl.util.OperatingSystemFamily;
import org.arquillian.cube.docker.impl.util.OperatingSystemFamilyInterface;
import org.arquillian.cube.docker.impl.util.OperatingSystemInterface;
import org.arquillian.cube.docker.impl.util.OperatingSystemResolver;
import org.arquillian.cube.docker.impl.util.Top;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.EnvironmentVariables;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CubeDockerConfigurationResolverTest {
    @ClassRule
    public static final EnvironmentVariables environmentVariables = new EnvironmentVariables();
    @Mock
    private static OperatingSystemInterface operatingSystemInterface;
    @Mock
    private static OperatingSystemFamilyInterface defaultOperatingSystemFamilyInterface;
    @Mock
    private static DefaultDocker defaultDocker;
    @Mock
    private static DockerClient dockerClient;
    @Mock
    private static InfoCmd infoCmd;
    @Mock
    private static Info info;

    public DefaultDocker mockDefaultDocker() {
        Mockito.when((Object)defaultDocker.getDefaultDockerClient(ArgumentMatchers.anyString())).thenReturn((Object)dockerClient);
        Mockito.when((Object)dockerClient.infoCmd()).thenReturn((Object)infoCmd);
        Mockito.when((Object)((Info)infoCmd.exec())).thenReturn((Object)info);
        return defaultDocker;
    }

    @BeforeClass
    public static void beforeEach() {
        environmentVariables.clear(new String[]{"DOCKER_HOST"});
    }

    @Test
    public void shouldDetectsValidDockerDefault() throws Exception {
        CubeDockerConfigurationResolver resolver = new CubeDockerConfigurationResolver(new Top(), this.mockDefaultDocker(), operatingSystemInterface);
        Mockito.when((Object)info.getName()).thenReturn((Object)"docker-ce");
        Mockito.when((Object)info.getServerVersion()).thenReturn((Object)"arquillian-test");
        Mockito.when((Object)info.getKernelVersion()).thenReturn((Object)"0.0.0");
        URL sockURL = this.getClass().getClassLoader().getResource("docker.sock");
        boolean isWindows = new OperatingSystemResolver().currentOperatingSystem().getFamily() == OperatingSystemFamily.WINDOWS;
        String sockUri = isWindows ? sockURL.toExternalForm().replace("file:/", "") : "unix://" + sockURL.toExternalForm();
        Mockito.when((Object)defaultOperatingSystemFamilyInterface.getServerUri()).thenReturn((Object)sockUri);
        Mockito.when((Object)operatingSystemInterface.getDefaultFamily()).thenReturn((Object)defaultOperatingSystemFamilyInterface);
        Mockito.lenient().when((Object)operatingSystemInterface.getFamily()).thenReturn((Object)OperatingSystem.MAC_OSX.getFamily());
        HashMap config = new HashMap();
        Map resolvedConfig = resolver.resolve(config);
        if (!isWindows) {
            Assert.assertThat((Object)Boolean.valueOf((String)resolvedConfig.get("tlsVerify")), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)((String)resolvedConfig.get("certPath")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        }
        Assert.assertThat((Object)((String)resolvedConfig.get("serverUri")), (Matcher)CoreMatchers.is((Object)sockUri));
    }

    @Test
    public void shouldNotSetTlsVerifyForTcpSchemeOnOSX() {
        CubeDockerConfigurationResolver resolver = new CubeDockerConfigurationResolver(new Top(), this.mockDefaultDocker(), operatingSystemInterface);
        Mockito.lenient().when((Object)((Info)infoCmd.exec())).thenThrow(new Throwable[]{new ProcessingException("test exception")});
        String sockUri = "unix:///a/path-that/does/not/exist";
        Mockito.lenient().when((Object)defaultOperatingSystemFamilyInterface.getServerUri()).thenReturn((Object)sockUri);
        Mockito.lenient().when((Object)operatingSystemInterface.getDefaultFamily()).thenReturn((Object)defaultOperatingSystemFamilyInterface);
        Mockito.lenient().when((Object)operatingSystemInterface.getFamily()).thenReturn((Object)OperatingSystem.MAC_OSX.getFamily());
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serverUri", "tcp://localhost:2376");
        Map resolvedConfig = resolver.resolve(config);
        Assert.assertThat((Object)Boolean.valueOf((String)resolvedConfig.get("tlsVerify")), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)((String)resolvedConfig.get("certPath")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldNotSetTlsVerifyForTcpSchemeOnLinux() {
        CubeDockerConfigurationResolver resolver = new CubeDockerConfigurationResolver(new Top(), this.mockDefaultDocker(), operatingSystemInterface);
        Mockito.lenient().when((Object)((Info)infoCmd.exec())).thenThrow(new Throwable[]{new ProcessingException("test exception")});
        String sockUri = "unix:///a/path-that/does/not/exist";
        Mockito.lenient().when((Object)defaultOperatingSystemFamilyInterface.getServerUri()).thenReturn((Object)sockUri);
        Mockito.lenient().when((Object)operatingSystemInterface.getDefaultFamily()).thenReturn((Object)defaultOperatingSystemFamilyInterface);
        Mockito.lenient().when((Object)operatingSystemInterface.getFamily()).thenReturn((Object)OperatingSystem.LINUX_OS.getFamily());
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serverUri", "tcp://localhost:2376");
        Map resolvedConfig = resolver.resolve(config);
        Assert.assertThat((Object)Boolean.valueOf((String)resolvedConfig.get("tlsVerify")), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)((String)resolvedConfig.get("certPath")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

