/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.containerobject;

import com.github.dockerjava.api.DockerClient;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.arquillian.cube.ContainerObjectConfiguration;
import org.arquillian.cube.CubeController;
import org.arquillian.cube.CubeIp;
import org.arquillian.cube.HostPort;
import org.arquillian.cube.containerobject.Cube;
import org.arquillian.cube.containerobject.CubeDockerFile;
import org.arquillian.cube.containerobject.Environment;
import org.arquillian.cube.containerobject.Environments;
import org.arquillian.cube.containerobject.Image;
import org.arquillian.cube.containerobject.Link;
import org.arquillian.cube.containerobject.Volume;
import org.arquillian.cube.containerobject.Volumes;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.containerobject.CubeContainerObjectConfiguration;
import org.arquillian.cube.docker.impl.client.containerobject.CubeContainerObjectTestEnricher;
import org.arquillian.cube.docker.impl.client.containerobject.DockerContainerObjectBuilder;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.model.DockerCube;
import org.arquillian.cube.impl.util.ReflectionUtil;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.metadata.HasPortBindings;
import org.arquillian.cube.spi.metadata.IsContainerObject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.docker.DockerDescriptor;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class DockerContainerObjectBuilderTest {
    public static final String BASE_IMAGE = "tomee:8-jre-1.7.2-webprofile";
    private CubeController cubeController;
    private DockerClientExecutor dockerClientExecutor;
    private CubeContainerObjectTestEnricher cubeContainerObjectTestEnricher;
    private Collection<TestEnricher> enrichers;
    private CubeRegistry cubeRegistry;

    @Before
    public void initMocks() {
        this.cubeController = (CubeController)Mockito.mock(CubeController.class);
        this.dockerClientExecutor = (DockerClientExecutor)Mockito.mock(DockerClientExecutor.class);
        Mockito.when((Object)this.dockerClientExecutor.isDockerInsideDockerResolution()).thenReturn((Object)true);
        Mockito.when((Object)this.dockerClientExecutor.getDockerClient()).thenReturn((Object)((DockerClient)Mockito.mock(DockerClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS)));
        this.cubeRegistry = (CubeRegistry)Mockito.mock(CubeRegistry.class);
        this.cubeContainerObjectTestEnricher = (CubeContainerObjectTestEnricher)Mockito.mock(CubeContainerObjectTestEnricher.class);
        ((CubeContainerObjectTestEnricher)Mockito.doAnswer(DockerContainerObjectBuilderTest::objectContainerEnricherMockEnrich).when((Object)this.cubeContainerObjectTestEnricher)).enrich(ArgumentMatchers.any());
        this.enrichers = Collections.singleton(this.cubeContainerObjectTestEnricher);
    }

    @Before
    public void cleanupTestDirsBeforeEachTest() {
        DockerContainerObjectBuilderTest.deleteTestDirectory();
    }

    @AfterClass
    public static void cleanupTestDirsWhenDone() {
        DockerContainerObjectBuilderTest.deleteTestDirectory();
    }

    @Test
    public void shouldStartAContainerObjectDefinedUsingDockerfile() {
        AtomicReference cubeRef = new AtomicReference();
        try {
            TestContainerObjectDefinedUsingDockerfile containerObject = (TestContainerObjectDefinedUsingDockerfile)new DockerContainerObjectBuilder(this.dockerClientExecutor, this.cubeController, this.cubeRegistry).withContainerObjectClass(TestContainerObjectDefinedUsingDockerfile.class).onCubeCreated(cubeRef::set).build();
            Assert.assertThat((Object)containerObject, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        }
        catch (IOException | IllegalAccessException | InvocationTargetException e) {
            Assert.fail();
        }
        DockerCube cube = (DockerCube)cubeRef.get();
        Assert.assertThat((Object)cube, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)cube.hasMetadata(IsContainerObject.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((IsContainerObject)cube.getMetadata(IsContainerObject.class)).getTestClass(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).create("containerDefinedUsingDockerfile");
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).start("containerDefinedUsingDockerfile");
    }

    @Test
    public void shouldStartAContainerObjectDefinedUsingDescriptor() {
        AtomicReference cubeRef = new AtomicReference();
        try {
            TestContainerObjectDefinedUsingDescriptor containerObject = (TestContainerObjectDefinedUsingDescriptor)new DockerContainerObjectBuilder(this.dockerClientExecutor, this.cubeController, this.cubeRegistry).withContainerObjectClass(TestContainerObjectDefinedUsingDescriptor.class).onCubeCreated(cubeRef::set).build();
            Assert.assertThat((Object)containerObject, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        }
        catch (IOException | IllegalAccessException | InvocationTargetException e) {
            Assert.fail();
        }
        DockerCube cube = (DockerCube)cubeRef.get();
        Assert.assertThat((Object)cube, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)cube.hasMetadata(IsContainerObject.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((IsContainerObject)cube.getMetadata(IsContainerObject.class)).getTestClass(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).create("containerDefinedUsingDescriptor");
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).start("containerDefinedUsingDescriptor");
        File generatedDirectory = DockerContainerObjectBuilderTest.findGeneratedDirectory();
        Assert.assertThat((Object)generatedDirectory, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)new File(generatedDirectory, "Dockerfile").exists(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldLinkInnerContainersWithLink() {
        AtomicReference cubeRef = new AtomicReference();
        try {
            TestContainerObjectWithAnnotatedLink containerObject = (TestContainerObjectWithAnnotatedLink)new DockerContainerObjectBuilder(this.dockerClientExecutor, this.cubeController, this.cubeRegistry).withContainerObjectClass(TestContainerObjectWithAnnotatedLink.class).withEnrichers(this.enrichers).onCubeCreated(cubeRef::set).build();
            Assert.assertThat((Object)containerObject, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
            Assert.assertThat((Object)containerObject.linkedContainerObject, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        }
        catch (IOException | IllegalAccessException | InvocationTargetException e) {
            Assert.fail();
        }
        DockerCube cube = (DockerCube)cubeRef.get();
        Assert.assertThat((Object)cube, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)cube.hasMetadata(IsContainerObject.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((IsContainerObject)cube.getMetadata(IsContainerObject.class)).getTestClass(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
        Collection links = cube.configuration().getLinks();
        Assert.assertThat((Object)links, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)links.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)links, (Matcher)Matchers.hasItem((Object)org.arquillian.cube.docker.impl.client.config.Link.valueOf((String)"db:db")));
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).create("containerWithAnnotatedLink");
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).start("containerWithAnnotatedLink");
        ((CubeContainerObjectTestEnricher)Mockito.verify((Object)this.cubeContainerObjectTestEnricher, (VerificationMode)Mockito.times((int)1))).enrich(ArgumentMatchers.any(TestContainerObjectWithAnnotatedLink.class));
    }

    @Test
    public void shouldLinkInnerContainersWithoutLink() {
        AtomicReference cubeRef = new AtomicReference();
        try {
            TestContainerObjectWithNonAnnotatedLink containerObject = (TestContainerObjectWithNonAnnotatedLink)new DockerContainerObjectBuilder(this.dockerClientExecutor, this.cubeController, this.cubeRegistry).withContainerObjectClass(TestContainerObjectWithNonAnnotatedLink.class).withEnrichers(this.enrichers).onCubeCreated(cubeRef::set).build();
            Assert.assertThat((Object)containerObject, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
            Assert.assertThat((Object)containerObject.linkedContainerObject, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        }
        catch (IOException | IllegalAccessException | InvocationTargetException e) {
            Assert.fail();
        }
        DockerCube cube = (DockerCube)cubeRef.get();
        Assert.assertThat((Object)cube, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)cube.hasMetadata(IsContainerObject.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((IsContainerObject)cube.getMetadata(IsContainerObject.class)).getTestClass(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
        Collection links = cube.configuration().getLinks();
        Assert.assertThat((Object)links, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)links.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)links, (Matcher)Matchers.hasItem((Object)org.arquillian.cube.docker.impl.client.config.Link.valueOf((String)"inner:inner")));
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).create("containerWithNonAnnotatedLink");
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).start("containerWithNonAnnotatedLink");
        ((CubeContainerObjectTestEnricher)Mockito.verify((Object)this.cubeContainerObjectTestEnricher, (VerificationMode)Mockito.times((int)1))).enrich(ArgumentMatchers.any(TestContainerObjectWithNonAnnotatedLink.class));
    }

    @Test
    public void shouldStartAContainerObjectDefinedUsingImage() {
        AtomicReference cubeRef = new AtomicReference();
        try {
            TestContainerObjectDefinedUsingImage containerObject = (TestContainerObjectDefinedUsingImage)new DockerContainerObjectBuilder(this.dockerClientExecutor, this.cubeController, this.cubeRegistry).withContainerObjectClass(TestContainerObjectDefinedUsingImage.class).onCubeCreated(cubeRef::set).build();
            Assert.assertThat((Object)containerObject, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        }
        catch (IOException | IllegalAccessException | InvocationTargetException e) {
            Assert.fail();
        }
        DockerCube cube = (DockerCube)cubeRef.get();
        Assert.assertThat((Object)cube, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)cube.hasMetadata(IsContainerObject.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((IsContainerObject)cube.getMetadata(IsContainerObject.class)).getTestClass(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)cube.configuration().getImage().toImageRef(), (Matcher)Is.is((Object)BASE_IMAGE));
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).create("containerDefinedUsingImage");
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).start("containerDefinedUsingImage");
    }

    @Test
    public void shouldStartAContainerObjectDefinedUsingImageAndEnvironmentVariables() {
        AtomicReference cubeRef = new AtomicReference();
        try {
            CubeContainer ccconfig = new CubeContainer();
            ccconfig.setEnv(Collections.singleton("e=f"));
            CubeContainerObjectConfiguration ccoconfig = new CubeContainerObjectConfiguration(ccconfig);
            TestContainerObjectDefinedUsingImageAndEnvironmentVariables containerObject = (TestContainerObjectDefinedUsingImageAndEnvironmentVariables)new DockerContainerObjectBuilder(this.dockerClientExecutor, this.cubeController, this.cubeRegistry).withContainerObjectClass(TestContainerObjectDefinedUsingImageAndEnvironmentVariables.class).withContainerObjectConfiguration((ContainerObjectConfiguration)ccoconfig).onCubeCreated(cubeRef::set).build();
            Assert.assertThat((Object)containerObject, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        }
        catch (IOException | IllegalAccessException | InvocationTargetException e) {
            Assert.fail();
        }
        DockerCube cube = (DockerCube)cubeRef.get();
        Assert.assertThat((Object)cube, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)cube.hasMetadata(IsContainerObject.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((IsContainerObject)cube.getMetadata(IsContainerObject.class)).getTestClass(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)cube.configuration().getImage().toImageRef(), (Matcher)Is.is((Object)BASE_IMAGE));
        Assert.assertThat((Object)cube.configuration().getEnv(), (Matcher)Matchers.hasItems((Object[])new String[]{"a=b", "c=d", "e=f"}));
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).create("containerWithEnvironmentVariables");
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).start("containerWithEnvironmentVariables");
    }

    @Test
    public void shouldStartAContainerObjectDefinedUsingImageAndVolumes() {
        AtomicReference cubeRef = new AtomicReference();
        try {
            CubeContainer ccconfig = new CubeContainer();
            ccconfig.setBinds(Collections.singleton("/mypath3:/containerPath3:Z"));
            CubeContainerObjectConfiguration ccoconfig = new CubeContainerObjectConfiguration(ccconfig);
            TestContainerObjectDefinedUsingImageAndVolumes containerObject = (TestContainerObjectDefinedUsingImageAndVolumes)new DockerContainerObjectBuilder(this.dockerClientExecutor, this.cubeController, this.cubeRegistry).withContainerObjectClass(TestContainerObjectDefinedUsingImageAndVolumes.class).withContainerObjectConfiguration((ContainerObjectConfiguration)ccoconfig).onCubeCreated(cubeRef::set).build();
            Assert.assertThat((Object)containerObject, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        }
        catch (IOException | IllegalAccessException | InvocationTargetException e) {
            Assert.fail();
        }
        DockerCube cube = (DockerCube)cubeRef.get();
        Assert.assertThat((Object)cube, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)cube.hasMetadata(IsContainerObject.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((IsContainerObject)cube.getMetadata(IsContainerObject.class)).getTestClass(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)cube.configuration().getImage().toImageRef(), (Matcher)Is.is((Object)BASE_IMAGE));
        Assert.assertThat((Object)cube.configuration().getBinds(), (Matcher)Matchers.hasItems((Object[])new String[]{"/mypath:/containerPath:Z", "/mypath2:/containerPath2:Z", "/mypath3:/containerPath3:Z"}));
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).create("containerWithVolumes");
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).start("containerWithVolumes");
    }

    @Test
    public void shouldEnrichAContainerWithCubeIp() {
        AtomicReference cubeRef = new AtomicReference();
        ((CubeController)Mockito.doAnswer(invocation -> {
            DockerContainerObjectBuilderTest.initDockerCubeInternalIP((DockerCube)cubeRef.get(), "172.17.0.2");
            return null;
        }).when((Object)this.cubeController)).start("containerWithCubeIp");
        try {
            TestContainerObjectWithCubeIp containerObject = (TestContainerObjectWithCubeIp)new DockerContainerObjectBuilder(this.dockerClientExecutor, this.cubeController, this.cubeRegistry).withContainerObjectClass(TestContainerObjectWithCubeIp.class).onCubeCreated(cubeRef::set).build();
            Assert.assertThat((Object)containerObject, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
            Assert.assertThat((Object)containerObject.cubeIp, (Matcher)Is.is((Object)"172.17.0.2"));
        }
        catch (IOException | IllegalAccessException | InvocationTargetException e) {
            Assert.fail();
        }
        DockerCube cube = (DockerCube)cubeRef.get();
        Assert.assertThat((Object)cube, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)cube.hasMetadata(IsContainerObject.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((IsContainerObject)cube.getMetadata(IsContainerObject.class)).getTestClass(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)cube.hasMetadata(HasPortBindings.class), (Matcher)Is.is((Object)true));
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).create("containerWithCubeIp");
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).start("containerWithCubeIp");
    }

    @Test
    public void shouldEnrichAContainerWithHostPort() {
        AtomicReference cubeRef = new AtomicReference();
        ((CubeController)Mockito.doAnswer(invocation -> {
            DockerContainerObjectBuilderTest.initDockerCubeMappedPort((DockerCube)cubeRef.get(), "127.0.0.1", 8080, 8080);
            return null;
        }).when((Object)this.cubeController)).start("containerWithHostPort");
        try {
            TestContainerObjectWithHostPort containerObject = (TestContainerObjectWithHostPort)new DockerContainerObjectBuilder(this.dockerClientExecutor, this.cubeController, this.cubeRegistry).withContainerObjectClass(TestContainerObjectWithHostPort.class).onCubeCreated(cubeRef::set).build();
            Assert.assertThat((Object)containerObject, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
            Assert.assertThat((Object)containerObject.port, (Matcher)Is.is((Object)8080));
        }
        catch (IOException | IllegalAccessException | InvocationTargetException e) {
            Assert.fail();
        }
        DockerCube cube = (DockerCube)cubeRef.get();
        Assert.assertThat((Object)cube, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)cube.hasMetadata(IsContainerObject.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((IsContainerObject)cube.getMetadata(IsContainerObject.class)).getTestClass(), (Matcher)Is.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)cube.hasMetadata(HasPortBindings.class), (Matcher)Is.is((Object)true));
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).create("containerWithHostPort");
        ((CubeController)Mockito.verify((Object)this.cubeController, (VerificationMode)Mockito.times((int)1))).start("containerWithHostPort");
    }

    private static void deleteTestDirectory() {
        File[] testsDirectories;
        File tempDirectory = new File(System.getProperty("java.io.tmpdir"));
        for (File testDirectory : testsDirectories = tempDirectory.listFiles(DockerContainerObjectBuilderTest::testDirectoryFilter)) {
            try {
                FileUtils.deleteDirectory((File)testDirectory);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static File findGeneratedDirectory() {
        File tempDirectory = new File(System.getProperty("java.io.tmpdir"));
        File[] testsDirectories = tempDirectory.listFiles(DockerContainerObjectBuilderTest::testDirectoryFilter);
        if (testsDirectories.length > 0) {
            return testsDirectories[0];
        }
        return null;
    }

    private static boolean testDirectoryFilter(File dir, String name) {
        return dir.isDirectory() && name.startsWith("arquilliancube_") && name.endsWith(".build");
    }

    private static Void objectContainerEnricherMockEnrich(InvocationOnMock invocation) throws Throwable {
        Object containerObject = invocation.getArguments()[0];
        ReflectionUtil.getFieldsWithAnnotation(containerObject.getClass(), Cube.class).stream().forEach(field -> {
            try {
                field.set(containerObject, field.getType().newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        });
        return null;
    }

    private static void initDockerCubeInternalIP(DockerCube dockerCube, String internalIP) {
        PrivilegedExceptionAction<Void> action = () -> {
            Field dockerCubePortBindingsField = DockerCube.class.getDeclaredField("portBindings");
            dockerCubePortBindingsField.setAccessible(true);
            Class<?> dockerCubePortBindingsClass = dockerCubePortBindingsField.getType();
            Field dockerCubePortBindingsInternalIpField = dockerCubePortBindingsClass.getDeclaredField("internalIP");
            dockerCubePortBindingsInternalIpField.setAccessible(true);
            Object dockerCubePortBindings = dockerCubePortBindingsField.get(dockerCube);
            dockerCubePortBindingsInternalIpField.set(dockerCubePortBindings, internalIP);
            return null;
        };
        try {
            AccessController.doPrivileged(action);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void initDockerCubeMappedPort(DockerCube dockerCube, String containerIP, int exposedPort, int boundPort) {
        PrivilegedExceptionAction<Void> action = () -> {
            Field dockerCubePortBindingsField = DockerCube.class.getDeclaredField("portBindings");
            dockerCubePortBindingsField.setAccessible(true);
            Class<?> dockerCubePortBindingsClass = dockerCubePortBindingsField.getType();
            Field dockerCubePortBindingsMappedPortsField = dockerCubePortBindingsClass.getDeclaredField("mappedPorts");
            dockerCubePortBindingsMappedPortsField.setAccessible(true);
            Object dockerCubePortBindings = dockerCubePortBindingsField.get(dockerCube);
            Map mappedPorts = (Map)dockerCubePortBindingsMappedPortsField.get(dockerCubePortBindings);
            mappedPorts.put(exposedPort, new HasPortBindings.PortAddressImpl(containerIP, boundPort));
            return null;
        };
        try {
            AccessController.doPrivileged(action);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Cube(value="containerDefinedUsingDockerfile")
    @CubeDockerFile
    public static class TestContainerObjectDefinedUsingDockerfile {
    }

    @Cube(value="containerDefinedUsingDescriptor")
    public static class TestContainerObjectDefinedUsingDescriptor {
        @CubeDockerFile
        public static Archive<?> createDockerfile() {
            String dockerDescriptor = ((DockerDescriptor)Descriptors.create(DockerDescriptor.class)).from(DockerContainerObjectBuilderTest.BASE_IMAGE).exportAsString();
            return ((GenericArchive)ShrinkWrap.create(GenericArchive.class)).add((Asset)new StringAsset(dockerDescriptor), "Dockerfile");
        }
    }

    @Cube(value="containerWithAnnotatedLink")
    public static class TestContainerObjectWithAnnotatedLink {
        @Cube(value="inner")
        @Link(value="db:db")
        TestContainerObjectDefinedUsingDescriptor linkedContainerObject;

        @CubeDockerFile
        public static Archive<?> createDockerfile() {
            String dockerDescriptor = ((DockerDescriptor)Descriptors.create(DockerDescriptor.class)).from(DockerContainerObjectBuilderTest.BASE_IMAGE).exportAsString();
            return ((GenericArchive)ShrinkWrap.create(GenericArchive.class)).add((Asset)new StringAsset(dockerDescriptor), "Dockerfile");
        }
    }

    @Cube(value="containerWithNonAnnotatedLink")
    public static class TestContainerObjectWithNonAnnotatedLink {
        @Cube(value="inner")
        TestContainerObjectDefinedUsingDescriptor linkedContainerObject;

        @CubeDockerFile
        public static Archive<?> createDockerfile() {
            String dockerDescriptor = ((DockerDescriptor)Descriptors.create(DockerDescriptor.class)).from(DockerContainerObjectBuilderTest.BASE_IMAGE).exportAsString();
            return ((GenericArchive)ShrinkWrap.create(GenericArchive.class)).add((Asset)new StringAsset(dockerDescriptor), "Dockerfile");
        }
    }

    @Cube(value="containerDefinedUsingImage")
    @Image(value="tomee:8-jre-1.7.2-webprofile")
    public static class TestContainerObjectDefinedUsingImage {
    }

    @Cube(value="containerWithEnvironmentVariables")
    @Image(value="tomee:8-jre-1.7.2-webprofile")
    @Environments(value={@Environment(key="a", value="b"), @Environment(key="c", value="d")})
    public static class TestContainerObjectDefinedUsingImageAndEnvironmentVariables {
    }

    @Cube(value="containerWithVolumes")
    @Image(value="tomee:8-jre-1.7.2-webprofile")
    @Volumes(value={@Volume(hostPath="/mypath", containerPath="/containerPath"), @Volume(hostPath="/mypath2", containerPath="/containerPath2")})
    public static class TestContainerObjectDefinedUsingImageAndVolumes {
    }

    @Cube(value="containerWithCubeIp")
    @Image(value="tomee:8-jre-1.7.2-webprofile")
    public static class TestContainerObjectWithCubeIp {
        @CubeIp
        String cubeIp;
    }

    @Cube(value="containerWithHostPort", portBinding={"8080->8080/tcp"})
    @Image(value="tomee:8-jre-1.7.2-webprofile")
    public static class TestContainerObjectWithHostPort {
        @HostPort(value=8080)
        int port;
    }
}

