/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.model;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Ports;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.model.DockerCube;
import org.arquillian.cube.spi.event.lifecycle.AfterCreate;
import org.arquillian.cube.spi.event.lifecycle.AfterDestroy;
import org.arquillian.cube.spi.event.lifecycle.AfterStart;
import org.arquillian.cube.spi.event.lifecycle.AfterStop;
import org.arquillian.cube.spi.event.lifecycle.BeforeCreate;
import org.arquillian.cube.spi.event.lifecycle.BeforeDestroy;
import org.arquillian.cube.spi.event.lifecycle.BeforeStart;
import org.arquillian.cube.spi.event.lifecycle.BeforeStop;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.test.AbstractManagerTestBase;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DockerCubeTest
extends AbstractManagerTestBase {
    private static final String ID = "test";
    @Mock
    private DockerClientExecutor executor;
    @Mock
    private DockerClient dockerClient;
    @Mock
    private InspectContainerCmd inspectContainerCmd;
    @Mock
    private InspectContainerResponse inspectContainerResponse;
    @Inject
    private Instance<Injector> injectorInst;
    private DockerCube cube;

    @Before
    public void setup() {
        HostConfig hostConfig = new HostConfig();
        hostConfig.withPortBindings(new Ports());
        Mockito.when((Object)this.inspectContainerResponse.getHostConfig()).thenReturn((Object)hostConfig);
        Mockito.when((Object)this.inspectContainerCmd.exec()).thenReturn((Object)this.inspectContainerResponse);
        Mockito.when((Object)this.dockerClient.inspectContainerCmd(ArgumentMatchers.anyString())).thenReturn((Object)this.inspectContainerCmd);
        Mockito.when((Object)this.executor.getDockerClient()).thenReturn((Object)this.dockerClient);
        CubeContainer cubeContainer = new CubeContainer();
        cubeContainer.setRemoveVolumes(Boolean.valueOf(false));
        this.cube = (DockerCube)((Injector)this.injectorInst.get()).inject((Object)new DockerCube(ID, cubeContainer, this.executor));
    }

    @Test
    public void shouldFireLifecycleEventsDuringCreate() {
        this.cube.create();
        this.assertEventFired(BeforeCreate.class, 1);
        this.assertEventFired(AfterCreate.class, 1);
    }

    @Test
    public void shouldFireLifecycleEventsDuringCreateAfterDestroyed() {
        this.cube.create();
        this.cube.start();
        this.cube.stop();
        this.cube.destroy();
        this.cube.create();
        this.assertEventFired(BeforeCreate.class, 2);
        this.assertEventFired(AfterCreate.class, 2);
    }

    @Test
    public void shouldFireLifecycleEventsDuringStart() {
        this.cube.start();
        this.assertEventFired(BeforeStart.class, 1);
        this.assertEventFired(AfterStart.class, 1);
    }

    @Test
    public void shouldFireLifecycleEventsDuringStop() {
        this.cube.stop();
        this.assertEventFired(BeforeStop.class, 1);
        this.assertEventFired(AfterStop.class, 1);
    }

    @Test
    public void shouldFireLifecycleEventsDuringStopWhenContainerNotFound() {
        ((DockerClientExecutor)Mockito.doThrow((Throwable[])new Throwable[]{new NotFoundException("container not found")}).when((Object)this.executor)).stopContainer(ID);
        this.cube.stop();
        this.assertEventFired(BeforeStop.class, 1);
        this.assertEventFired(AfterStop.class, 1);
    }

    @Test
    public void shouldFireLifecycleEventsDuringDestroy() {
        this.cube.stop();
        this.cube.destroy();
        this.assertEventFired(BeforeDestroy.class, 1);
        this.assertEventFired(AfterDestroy.class, 1);
    }

    @Test
    public void shouldFireLifecycleEventsDuringDestroyWhenContainerNotFound() {
        ((DockerClientExecutor)Mockito.doThrow((Throwable[])new Throwable[]{new NotFoundException("container not found")}).when((Object)this.executor)).removeContainer(ID, false);
        this.cube.stop();
        this.cube.destroy();
        this.assertEventFired(BeforeDestroy.class, 1);
        this.assertEventFired(AfterDestroy.class, 1);
    }

    @Test
    public void shouldNotFireLifecycleEventsIfTryingToStopAlreadyDestroyedCube() {
        this.cube.stop();
        this.cube.destroy();
        this.cube.stop();
        this.assertEventFired(BeforeStop.class, 1);
        this.assertEventFired(AfterStop.class, 1);
    }

    @Test
    public void shouldNotFireLifecycleEventsIfTryingToStopAlreadyStoppedCube() {
        this.cube.stop();
        this.cube.stop();
        this.assertEventFired(BeforeStop.class, 1);
        this.assertEventFired(AfterStop.class, 1);
    }

    @Test
    public void shouldNotFireLifecycleEventsIfTryingToStopPreRunningCube() {
        this.cube.changeToPreRunning();
        this.cube.stop();
        this.assertEventFired(BeforeStop.class, 0);
        this.assertEventFired(AfterStop.class, 0);
    }
}

