/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import org.arquillian.cube.containerobject.CubeDockerFile;
import org.arquillian.cube.docker.impl.util.DockerFileUtil;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DockerFileUtilTest {
    @Rule
    public final TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void shouldCopyDockerfileFromDefaultLocation() throws IOException {
        File outputDir = this.folder.newFolder();
        DockerFileUtil.copyDockerfileDirectory(TestLocalDockerFile.class, (CubeDockerFile)TestLocalDockerFile.class.getAnnotation(CubeDockerFile.class), (File)outputDir);
        Assert.assertThat((Object)new File(outputDir, "Dockerfile").exists(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCopyDockerfileFromDefaultJar() throws IOException, ClassNotFoundException {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(TestJarDockerFile.class)).addClasses(new Class[]{CubeDockerFile.class})).addAsResource((Asset)new StringAsset("FROM java:8-jre"), "/org/arquillian/cube/docker/impl/util/DockerFileUtilTest/TestJarDockerFile/Dockerfile");
        File jarDirectory = this.folder.newFolder();
        File jarFile = new File(jarDirectory, "test.jar");
        ((ZipExporter)jar.as(ZipExporter.class)).exportTo(jarFile);
        URLClassLoader classloader = new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, null);
        Class<?> clazz = Class.forName("org.arquillian.cube.docker.impl.util.DockerFileUtilTest$TestJarDockerFile", true, classloader);
        File outputDir = this.folder.newFolder();
        DockerFileUtil.copyDockerfileDirectory(clazz, (CubeDockerFile)TestJarDockerFile.class.getAnnotation(CubeDockerFile.class), (File)outputDir);
        Assert.assertThat((Object)new File(outputDir, "Dockerfile").exists(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCopyDockerfileFromJarLocation() throws IOException, ClassNotFoundException {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(CustomTestJarDockerfiler.class)).addClasses(new Class[]{CubeDockerFile.class})).addAsResource((Asset)new StringAsset("FROM java:8-jre"), "/test/Dockerfile");
        File jarDirectory = this.folder.newFolder();
        File jarFile = new File(jarDirectory, "test.jar");
        ((ZipExporter)jar.as(ZipExporter.class)).exportTo(jarFile);
        URLClassLoader classloader = new URLClassLoader(new URL[]{jarFile.toURI().toURL()}, null);
        Class<?> clazz = Class.forName("org.arquillian.cube.docker.impl.util.DockerFileUtilTest$CustomTestJarDockerfiler", true, classloader);
        File outputDir = this.folder.newFolder();
        DockerFileUtil.copyDockerfileDirectory(clazz, (CubeDockerFile)CustomTestJarDockerfiler.class.getAnnotation(CubeDockerFile.class), (File)outputDir);
        Assert.assertThat((Object)new File(outputDir, "Dockerfile").exists(), (Matcher)Is.is((Object)true));
    }

    @CubeDockerFile
    public static class TestLocalDockerFile {
    }

    @CubeDockerFile
    public static class TestJarDockerFile {
    }

    @CubeDockerFile(value="test")
    public static class CustomTestJarDockerfiler {
    }
}

