/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.util;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.util.PingCommand;
import org.arquillian.cube.spi.CubeOutput;

public final class Ping {
    public static final String COMMAND_NOT_FOUND = "not found";

    private Ping() {
    }

    public static boolean ping(int totalIterations, long sleep, TimeUnit timeUnit, PingCommand command) {
        boolean result;
        boolean loop;
        int iteration = 0;
        do {
            result = command.call();
            boolean bl = loop = !result && ++iteration < totalIterations;
            if (!loop) continue;
            try {
                timeUnit.sleep(sleep);
            }
            catch (InterruptedException ignore) {
                break;
            }
        } while (loop);
        return result;
    }

    public static boolean ping(final DockerClientExecutor dockerClientExecutor, final String containerId, final String command, int totalIterations, long sleep, TimeUnit timeUnit) {
        return Ping.ping(totalIterations, sleep, timeUnit, new PingCommand(){

            @Override
            public boolean call() {
                return Ping.execContainerPing(dockerClientExecutor, containerId, command);
            }
        });
    }

    public static boolean ping(final String host, final int port, int totalIterations, long sleep, TimeUnit timeUnit) {
        return Ping.ping(totalIterations, sleep, timeUnit, new PingCommand(){

            @Override
            public boolean call() {
                return Ping.ping(host, port);
            }
        });
    }

    private static boolean execContainerPing(DockerClientExecutor dockerClientExecutor, String containerId, String command) {
        Object[] commands = new String[]{"sh", "-c", command};
        CubeOutput result = dockerClientExecutor.execStart(containerId, (String[])commands);
        if (result.getStandard() == null) {
            throw new IllegalArgumentException(String.format("Command %s in container %s has returned no value.", Arrays.toString(commands), containerId));
        }
        if (result.getStandard().contains(COMMAND_NOT_FOUND) || result.getError().contains(COMMAND_NOT_FOUND)) {
            throw new UnsupportedOperationException(String.format("Command %s is not available in container %s.", Arrays.toString(commands), containerId));
        }
        try {
            int numberOfListenConnectons = Integer.parseInt(result.getStandard().trim());
            return numberOfListenConnectons > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean ping(String host, int port) {
        Socket socket = null;
        try {
            socket = new Socket(host, port);
            boolean bl = true;
            return bl;
        }
        catch (UnknownHostException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

