/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.await;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.command.BuildImageResultCallback;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.arquillian.cube.docker.impl.await.DockerHealthAwaitStrategy;
import org.arquillian.cube.docker.impl.client.config.Await;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.spi.Cube;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.EnvironmentVariables;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DockerHealthAwaitStrategyTest {
    private static final String DOCKER_HOST = "DOCKER_HOST";
    private static DockerClient dockerClient;
    private static String healthSuccessImageId;
    private static String healthFailureImageId;
    @ClassRule
    public static final EnvironmentVariables environmentVariables;
    @Mock
    private DockerClientExecutor dockerClientExecutor;
    @Mock
    private Cube<?> cube;
    private List<String> containerIds;

    @BeforeClass
    public static void createDockerClient() {
        if (!System.getenv().containsKey(DOCKER_HOST) || System.getenv(DOCKER_HOST).equals("")) {
            environmentVariables.set(DOCKER_HOST, "unix:///var/run/docker.sock");
        }
        dockerClient = DockerClientBuilder.getInstance().build();
        healthSuccessImageId = DockerHealthAwaitStrategyTest.dockerBuild("DockerHealthAwait/HealthSuccess/Dockerfile");
        healthFailureImageId = DockerHealthAwaitStrategyTest.dockerBuild("DockerHealthAwait/HealthFailure/Dockerfile");
    }

    @Before
    public void setup() {
        this.containerIds = new ArrayList<String>();
    }

    @After
    public void cleanContainers() {
        for (String containerId : this.containerIds) {
            if (containerId == null) continue;
            DockerHealthAwaitStrategyTest.dockerRm(containerId);
        }
    }

    @AfterClass
    public static void cleanImages() {
        DockerHealthAwaitStrategyTest.dockerRmi(healthSuccessImageId);
        DockerHealthAwaitStrategyTest.dockerRmi(healthFailureImageId);
    }

    @Test
    public void shouldSuccessHealthCheck() {
        this.verifyDockerHealthCheckResult(healthSuccessImageId, true);
    }

    @Test
    public void shouldFailHealthcheck() {
        this.verifyDockerHealthCheckResult(healthFailureImageId, false);
    }

    @Test
    public void shouldSuccessCustomExec() {
        this.verifyAwait(healthFailureImageId, true, new String[]{"true"});
    }

    @Test
    public void shouldSuccessWithLongCommands() {
        this.verifyAwait(healthFailureImageId, true, new String[]{"sh", "-c", "echo start;sleep 2;echo stop"}, "3s");
    }

    @Test
    public void shouldFailCustomExecFailed() {
        this.verifyAwait(healthSuccessImageId, false, new String[]{"sh", "-c", "exit 1"});
    }

    @Test
    public void shouldFailNonExistingCommand() {
        this.verifyAwait(healthSuccessImageId, false, new String[]{"this command does not exist"});
    }

    private static String dockerBuild(String path) {
        URL url = DockerHealthAwaitStrategyTest.class.getClassLoader().getResource(path);
        return ((BuildImageResultCallback)dockerClient.buildImageCmd(new File(url.getFile()).getParentFile()).exec((ResultCallback)new BuildImageResultCallback())).awaitImageId();
    }

    private static void dockerRmi(String imageId) {
        if (imageId != null) {
            try {
                dockerClient.removeImageCmd(imageId).exec();
                System.out.printf("cleaned test image %s\n", imageId);
            }
            catch (Throwable t) {
                System.out.printf("Failed to clean test image %s: %s\n", imageId, t.toString());
            }
        }
    }

    private String dockerRun(String imageId) {
        String containerId = dockerClient.createContainerCmd(imageId).exec().getId();
        dockerClient.startContainerCmd(containerId).exec();
        return containerId;
    }

    private static void dockerRm(String containerId) {
        try {
            dockerClient.killContainerCmd(containerId).exec();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            dockerClient.removeContainerCmd(containerId).exec();
            System.out.printf("cleaned test container %s\n", containerId);
        }
        catch (Throwable t) {
            System.out.printf("Failed to clean test container %s: %s\n", containerId, t.toString());
        }
    }

    private void verifyDockerHealthCheckResult(String path, boolean status) {
        this.verifyAwait(path, status, null);
    }

    private void verifyAwait(String imageId, boolean status, String[] command) {
        this.verifyAwait(imageId, status, command, "500ms");
    }

    private void verifyAwait(String imageId, boolean status, String[] command, String timeout) {
        String containerId = this.dockerRun(imageId);
        this.containerIds.add(containerId);
        Mockito.when((Object)this.cube.getId()).thenReturn((Object)containerId);
        Mockito.when((Object)this.dockerClientExecutor.getDockerClient()).thenReturn((Object)dockerClient);
        Await params = new Await();
        params.setIterations(Integer.valueOf(2));
        params.setSleepPollingTime((Object)timeout);
        params.setCommand(command);
        DockerHealthAwaitStrategy dockerHealthAwaitStrategy = new DockerHealthAwaitStrategy(this.cube, this.dockerClientExecutor, params);
        Assert.assertEquals((Object)status, (Object)dockerHealthAwaitStrategy.await());
    }

    static {
        environmentVariables = new EnvironmentVariables();
    }
}

