/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.arquillian.cube.docker.impl.client.AutomaticResolutionNetworkAutoStartParser;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.client.DefinitionFormat;
import org.arquillian.cube.docker.impl.client.RegularExpressionAutoStartParser;
import org.arquillian.cube.spi.Node;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class AutomaticResolutionAutostartParserTest {
    @Test
    public void shouldStartNoneDeployableContainersWithRegisteredNetwork() {
        ArrayList<String> deployableContainer = new ArrayList<String>();
        deployableContainer.add("tomcat");
        String config = "networks:\n  mynetwork:\n    driver: bridge\ntomcat:\n  image: tomcat:10.1.30\n  exposedPorts: [8089/tcp]\n  env: [TOMCAT_PASS=mypass, \"CATALINA_OPTS=-Djava.security.egd=file:/dev/./urandom\", JAVA_OPTS=-Djava.rmi.server.hostname=dockerServerIp -Dcom.sun.management.jmxremote.rmi.port=8088 -Dcom.sun.management.jmxremote.port=8089 -Dcom.sun.management.jmxremote.ssl=false -Dcom.sun.management.jmxremote.authenticate=false]\n  portBindings: [8089/tcp, 8088/tcp, 8081->8080/tcp]\n  networkMode: mynetwork\npingpong:\n  image: tsongpon/pingpong\n  exposedPorts: [8080/tcp]\n  portBindings: [8080->8080/tcp]\n  networkMode: mynetwork";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", config);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        AutomaticResolutionNetworkAutoStartParser automaticResolutionNetworkAutoStartParser = new AutomaticResolutionNetworkAutoStartParser(deployableContainer, cubeConfiguration.getDockerContainersContent());
        Map parse = automaticResolutionNetworkAutoStartParser.parse();
        Assert.assertThat((Object)((Node)parse.get("pingpong")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)((Node)parse.get("tomcat")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldNotStartManualContainers() {
        String config = "tomcat:\n  image: tomcat:10.1.30\n  exposedPorts: [8089/tcp]\n  env: [TOMCAT_PASS=mypass, \"CATALINA_OPTS=-Djava.security.egd=file:/dev/./urandom\", JAVA_OPTS=-Djava.rmi.server.hostname=dockerServerIp -Dcom.sun.management.jmxremote.rmi.port=8088 -Dcom.sun.management.jmxremote.port=8089 -Dcom.sun.management.jmxremote.ssl=false -Dcom.sun.management.jmxremote.authenticate=false]\n  portBindings: [8089/tcp, 8088/tcp, 8081->8080/tcp]\npingpong:\n  image: tsongpon/pingpong\n  exposedPorts: [8080/tcp]\n  portBindings: [8080->8080/tcp]\n  manual: true";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("dockerContainers", config);
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        CubeDockerConfiguration cubeConfiguration = CubeDockerConfiguration.fromMap(parameters, null);
        RegularExpressionAutoStartParser regularExpressionAutoStartParser = new RegularExpressionAutoStartParser("regexp:.*", cubeConfiguration.getDockerContainersContent());
        Map parse = regularExpressionAutoStartParser.parse();
        Assert.assertThat((Object)((Node)parse.get("tomcat")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)((Node)parse.get("pingping")), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

