/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.arquillian.cube.docker.impl.client.BeforeStopContainerObserver;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.DockerCompositions;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.model.DockerCube;
import org.arquillian.cube.docker.impl.util.ConfigUtil;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.event.lifecycle.BeforeStop;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.test.AbstractManagerTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class BeforeStopContainerObserverTest
extends AbstractManagerTestBase {
    private static final String CUBE_CONTAINER_NAME = "test";
    private static final String CONTAINER_COPY_CONFIGURATION = "tomcat_default:\n  image: tomcat:10.1.30\n  beforeStop:\n    - copy:\n        from: /test\n        to: ";
    private static final String CONTAINER_LOG_CONFIGURATION = "tomcat_default:\n  image: tomcat:10.1.30\n  beforeStop:\n    - log:\n        to: ";
    private static final String CONTAINER_CUSTOM_BEFORE_STOP_ACTION_CONFIGURATION = "tomcat_default:\n  image: tomcat:10.1.30\n  beforeStop:\n    - customBeforeStopAction:\n        strategy: org.arquillian.cube.docker.impl.beforeStop.CustomBeforeStopActionImpl";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Mock
    private DockerCube cube;
    @Mock
    private CubeRegistry registry;
    @Mock
    private DockerClientExecutor dockerClientExecutor;

    @BeforeClass
    public static void startDockerStub() {
    }

    protected void addExtensions(List<Class<?>> extensions) {
        super.addExtensions(extensions);
        extensions.add(BeforeStopContainerObserver.class);
    }

    @Before
    public void setup() {
        this.bind(ApplicationScoped.class, DockerClientExecutor.class, this.dockerClientExecutor);
        Mockito.when((Object)((DockerCube)this.registry.getCube(CUBE_CONTAINER_NAME, DockerCube.class))).thenReturn((Object)this.cube);
        this.bind(ApplicationScoped.class, CubeRegistry.class, this.registry);
    }

    @Test
    public void shouldCopyFileFromContainer() throws IOException {
        File newFolder = this.temporaryFolder.newFolder();
        Object content = CONTAINER_COPY_CONFIGURATION;
        content = (String)content + newFolder.getAbsolutePath();
        DockerCompositions configuration = ConfigUtil.load((String)content);
        CubeContainer config = configuration.get("tomcat_default");
        Mockito.when((Object)this.cube.configuration()).thenReturn((Object)config);
        Mockito.when((Object)this.dockerClientExecutor.getFileOrDirectoryFromContainerAsTar((String)ArgumentMatchers.eq((Object)CUBE_CONTAINER_NAME), ArgumentMatchers.anyString())).thenReturn((Object)BeforeStopContainerObserverTest.class.getResourceAsStream("/hello.tar"));
        this.fire(new BeforeStop(CUBE_CONTAINER_NAME));
        ((DockerClientExecutor)Mockito.verify((Object)this.dockerClientExecutor)).getFileOrDirectoryFromContainerAsTar((String)ArgumentMatchers.eq((Object)CUBE_CONTAINER_NAME), (String)ArgumentMatchers.eq((Object)"/test"));
        Assert.assertThat((Object)new File(newFolder, "hello.txt").exists(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldGetLogFromContainer() throws IOException {
        File newFolder = this.temporaryFolder.newFolder();
        Object content = CONTAINER_LOG_CONFIGURATION;
        content = (String)content + newFolder.getAbsolutePath();
        content = (String)content + "mylog.log";
        DockerCompositions configuration = ConfigUtil.load((String)content);
        CubeContainer config = configuration.get("tomcat_default");
        Mockito.when((Object)this.cube.configuration()).thenReturn((Object)config);
        this.fire(new BeforeStop(CUBE_CONTAINER_NAME));
        ((DockerClientExecutor)Mockito.verify((Object)this.dockerClientExecutor, (VerificationMode)Mockito.times((int)1))).copyLog((String)ArgumentMatchers.eq((Object)CUBE_CONTAINER_NAME), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.eq((int)-1), (OutputStream)ArgumentMatchers.any(OutputStream.class));
    }

    @Test
    public void shouldExecuteCustomBeforeStopOperationForContainer() throws IOException {
        DockerCompositions configuration = ConfigUtil.load((String)CONTAINER_CUSTOM_BEFORE_STOP_ACTION_CONFIGURATION);
        CubeContainer config = configuration.get("tomcat_default");
        Mockito.when((Object)this.cube.configuration()).thenReturn((Object)config);
        this.fire(new BeforeStop(CUBE_CONTAINER_NAME));
        ((DockerClientExecutor)Mockito.verify((Object)this.dockerClientExecutor, (VerificationMode)Mockito.times((int)1))).getDockerUri();
    }
}

