/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import org.arquillian.cube.docker.impl.client.CubeDockerConfigurator;
import org.arquillian.cube.docker.impl.util.CommandLineExecutor;
import org.arquillian.cube.docker.impl.util.OperatingSystemFamily;
import org.arquillian.cube.docker.impl.util.OperatingSystemFamilyInterface;
import org.arquillian.cube.docker.impl.util.OperatingSystemInterface;
import org.arquillian.cube.docker.impl.util.Top;
import org.arquillian.cube.spi.CubeConfiguration;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.StringEndsWith;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.test.AbstractManagerTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.EnvironmentVariables;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CubeConfiguratorTest
extends AbstractManagerTestBase {
    @Rule
    public final EnvironmentVariables environmentVariables = new EnvironmentVariables();
    @Mock
    CommandLineExecutor commandLineExecutor;
    @Mock
    ArquillianDescriptor arquillianDescriptor;
    @Mock
    ExtensionDef extensionDef;
    @Mock
    OperatingSystemInterface operatingSystem;
    @Mock
    OperatingSystemFamilyInterface operatingSystemFamily;
    @Mock
    Top top;

    private static Matcher<String> pathEndsWith(String suffix) {
        return new PathStringEndsWithMatcher(suffix);
    }

    private void bindNonExistingDockerSocketOS() {
        Mockito.lenient().when((Object)this.operatingSystem.getDefaultFamily()).thenReturn((Object)this.operatingSystemFamily);
        Mockito.lenient().when((Object)this.operatingSystem.getFamily()).thenReturn((Object)OperatingSystemFamily.MAC);
        Mockito.when((Object)this.operatingSystemFamily.getServerUri()).thenReturn((Object)"non/existing/path");
        this.bind(ApplicationScoped.class, OperatingSystemInterface.class, this.operatingSystem);
    }

    protected void addExtensions(List<Class<?>> extensions) {
        extensions.add(CubeDockerConfigurator.class);
        super.addExtensions(extensions);
    }

    @Before
    public void setup() {
        this.bind(ApplicationScoped.class, ArquillianDescriptor.class, this.arquillianDescriptor);
        this.bind(ApplicationScoped.class, Top.class, this.top);
        Mockito.when((Object)this.top.isSpinning()).thenReturn((Object)false);
        this.environmentVariables.clear(new String[]{"DOCKER_HOST", "DOCKER_TLS_VERIFY", "DOCKER_CERT_PATH"});
    }

    @Test
    public void shouldChangeServerUriInCaseOfRunningDockerInsideDocker() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serverUri", "https://dockerHost:22222");
        Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
        Mockito.lenient().when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
        Mockito.when((Object)this.top.isSpinning()).thenReturn((Object)true);
        this.fire(new CubeConfiguration());
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"serverUri", (Object)OperatingSystemFamily.DIND.getServerUri()));
    }

    @Test
    public void tlsVerifyShouldBeTrueInCaseOfHttpsServerUri() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serverUri", "https://192.168.0.2:22222");
        Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
        Mockito.when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
        this.fire(new CubeConfiguration());
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"serverUri", (Object)"tcp://192.168.0.2:22222"));
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"tlsVerify", (Object)"true"));
    }

    @Test
    public void tlsVerifyShouldBeTrueInCaseOfSetToFalseAndHttpsServerUri() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serverUri", "https://192.168.0.2:22222");
        config.put("tlsVerify", "false");
        Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
        Mockito.when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
        this.fire(new CubeConfiguration());
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"serverUri", (Object)"tcp://192.168.0.2:22222"));
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"tlsVerify", (Object)"true"));
    }

    @Test
    public void tlsVerifyShouldBeFalseInCaseOfHttpServerUri() throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serverUri", "http://192.168.0.2:22222");
        Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
        Mockito.when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
        this.fire(new CubeConfiguration());
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"serverUri", (Object)"tcp://192.168.0.2:22222"));
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"tlsVerify", (Object)"false"));
        Assert.assertThat(config, (Matcher)CoreMatchers.not((Matcher)IsMapContaining.hasKey((Object)"certPath")));
    }

    @Test
    public void tlsVerifyShouldBeFalseInCaseOfSetToTrueAndHttpServerUri() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serverUri", "http://192.168.0.2:22222");
        config.put("tlsVerify", "true");
        Mockito.when((Object)this.extensionDef.getExtensionProperties()).thenReturn(config);
        Mockito.when((Object)this.arquillianDescriptor.extension("docker")).thenReturn((Object)this.extensionDef);
        this.fire(new CubeConfiguration());
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"serverUri", (Object)"tcp://192.168.0.2:22222"));
        Assert.assertThat(config, (Matcher)IsMapContaining.hasEntry((Object)"tlsVerify", (Object)"false"));
        Assert.assertThat(config, (Matcher)CoreMatchers.not((Matcher)IsMapContaining.hasKey((Object)"certPath")));
    }

    private static class PathStringEndsWithMatcher
    extends StringEndsWith {
        public PathStringEndsWithMatcher(String suffix) {
            super(suffix);
        }

        protected boolean evalSubstringOf(String s) {
            return Paths.get(s, new String[0]).endsWith(this.substring);
        }
    }
}

