/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import java.util.HashMap;
import java.util.List;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.client.CubeDockerRegistrar;
import org.arquillian.cube.docker.impl.client.DefinitionFormat;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.impl.model.LocalCubeRegistry;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeRegistry;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.test.AbstractManagerTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CubeRegistrarTestCase
extends AbstractManagerTestBase {
    private static final String CONTENT = "tomcat:\n  image: tomcat:10.1.30\n  exposedPorts: [8089/tcp]\n  await:\n    strategy: static\n    ip: localhost\n    ports: [8080, 8089]";
    @Mock
    private DockerClientExecutor executor;
    private CubeRegistry registry = new LocalCubeRegistry();

    protected void addExtensions(List<Class<?>> extensions) {
        extensions.add(CubeDockerRegistrar.class);
        super.addExtensions(extensions);
    }

    @Before
    public void setup() {
        this.bind(ApplicationScoped.class, CubeRegistry.class, this.registry);
    }

    @Test
    public void shouldExposeAndRegisterCubesFromConfiguration() {
        this.bind(ApplicationScoped.class, CubeDockerConfiguration.class, this.createConfig());
        this.fire(this.executor);
        Assert.assertEquals((long)1L, (long)this.registry.getCubes().size());
        Assert.assertEquals((Object)"tomcat", (Object)((Cube)this.registry.getCubes().get(0)).getId());
    }

    private CubeDockerConfiguration createConfig() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("serverVersion", "1.13");
        parameters.put("serverUri", "http://localhost:25123");
        parameters.put("definitionFormat", DefinitionFormat.CUBE.name());
        parameters.put("dockerContainers", CONTENT);
        return CubeDockerConfiguration.fromMap(parameters, null);
    }
}

