/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client;

import java.util.HashSet;
import org.arquillian.cube.docker.impl.client.SystemPropertiesCubeSetter;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.model.DockerCube;
import org.arquillian.cube.spi.Binding;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.event.lifecycle.AfterDestroy;
import org.arquillian.cube.spi.event.lifecycle.AfterStart;
import org.assertj.core.api.Assertions;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.RestoreSystemProperties;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SystemPropertiesCubeSetterTest {
    @Mock
    CubeRegistry cubeRegistry;
    @Mock
    DockerCube dockerCube;
    @Mock
    Binding binding;
    @Mock
    Binding.PortBinding portBinding;
    @Mock
    DockerClientExecutor dockerClientExecutor;
    @Rule
    public final RestoreSystemProperties restoreSystemProperties = new RestoreSystemProperties();

    @Before
    public void setupContainers() {
        Mockito.when((Object)this.dockerClientExecutor.getDockerServerIp()).thenReturn((Object)"192.168.99.100");
        Mockito.when((Object)((DockerCube)this.cubeRegistry.getCube("image", DockerCube.class))).thenReturn((Object)this.dockerCube);
        Mockito.when((Object)this.dockerCube.bindings()).thenReturn((Object)this.binding);
        Mockito.when((Object)this.binding.getIP()).thenReturn((Object)"192.168.99.100");
        Mockito.when((Object)this.binding.getInternalIP()).thenReturn((Object)"172.0.10.0");
        Mockito.when((Object)this.portBinding.getExposedPort()).thenReturn((Object)8080);
        Mockito.when((Object)this.portBinding.getBindingPort()).thenReturn((Object)8080);
        HashSet<Binding.PortBinding> portBindings = new HashSet<Binding.PortBinding>();
        portBindings.add(this.portBinding);
        Mockito.when((Object)this.binding.getPortBindings()).thenReturn(portBindings);
    }

    @Test
    public void should_set_cube_properties() {
        SystemPropertiesCubeSetter systemPropertiesCubeSetter = new SystemPropertiesCubeSetter();
        systemPropertiesCubeSetter.createCubeSystemProperties(new AfterStart("image"), this.cubeRegistry);
        Assertions.assertThat((String)System.getProperty("arq.cube.docker.image.ip")).isEqualTo("192.168.99.100");
        Assertions.assertThat((String)System.getProperty("arq.cube.docker.image.internal.ip")).isEqualTo("172.0.10.0");
        Assertions.assertThat((String)System.getProperty("arq.cube.docker.image.port.8080")).isEqualTo("8080");
    }

    @Test
    public void should_unset_cube_properties() {
        SystemPropertiesCubeSetter systemPropertiesCubeSetter = new SystemPropertiesCubeSetter();
        System.setProperty("arq.cube.docker.image.ip", "192.168.99.100");
        System.setProperty("arq.cube.docker.image.port.8080", "8080");
        systemPropertiesCubeSetter.removeCubeSystemProperties(new AfterDestroy("image"));
        Assertions.assertThat((String)System.getProperty("arq.cube.docker.image.ip")).isNull();
        Assertions.assertThat((String)System.getProperty("arq.cube.docker.image.port.8080")).isNull();
    }

    @Test
    public void should_set_docker_host_ip() {
        SystemPropertiesCubeSetter systemPropertiesCubeSetter = new SystemPropertiesCubeSetter();
        systemPropertiesCubeSetter.createDockerHostProperty(new BeforeSuite(), this.dockerClientExecutor);
        Assertions.assertThat((String)System.getProperty("arq.cube.docker.host")).isEqualTo("192.168.99.100");
    }

    @Test
    public void should_unset_docker_host_ip() {
        SystemPropertiesCubeSetter systemPropertiesCubeSetter = new SystemPropertiesCubeSetter();
        System.setProperty("arq.cube.docker.host", "192.168.99.100");
        systemPropertiesCubeSetter.removeDockerHostProperty(new AfterSuite());
        Assertions.assertThat((String)System.getProperty("arq.cube.docker.host")).isNull();
    }
}

