/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.config;

import java.util.Iterator;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.DockerCompositions;
import org.arquillian.cube.docker.impl.client.config.ExposedPort;
import org.arquillian.cube.docker.impl.client.config.PortBinding;
import org.arquillian.cube.docker.impl.util.ConfigUtil;
import org.junit.Assert;
import org.junit.Test;

public class ConfigParserTestCase {
    private static final String CONTENT = "tomcat:\n  image: tomcat:10.1.30\n  buildImage:\n      dockerfileLocation: src/test/resources/undertow\n  exposedPorts: [8089/tcp]\n  portBindings: [1521/tcp, 'localhost:8181->81/tcp']\n  await:\n    strategy: static\n    ip: localhost\n    ports: [8080, 8089]";

    @Test
    public void shouldBeAbleToLoadStrategy() throws Exception {
        DockerCompositions containers = ConfigUtil.load((String)CONTENT);
        CubeContainer container = containers.get("tomcat");
        Assert.assertEquals((Object)"tomcat", (Object)container.getImage().getName());
        Assert.assertEquals((Object)"10.1.30", (Object)container.getImage().getTag());
        Assert.assertEquals((long)1L, (long)container.getExposedPorts().size());
        ExposedPort exposedPort = (ExposedPort)container.getExposedPorts().iterator().next();
        Assert.assertEquals((long)8089L, (long)exposedPort.getExposed());
        Assert.assertEquals((Object)"tcp", (Object)exposedPort.getType());
        Assert.assertEquals((long)2L, (long)container.getPortBindings().size());
        Iterator portBindingIterator = container.getPortBindings().iterator();
        PortBinding portBinding1 = (PortBinding)portBindingIterator.next();
        PortBinding portBinding2 = (PortBinding)portBindingIterator.next();
        Assert.assertEquals((long)1521L, (long)portBinding1.getExposedPort().getExposed());
        Assert.assertEquals((Object)"tcp", (Object)portBinding1.getExposedPort().getType());
        Assert.assertEquals((long)8181L, (long)portBinding2.getBound());
        Assert.assertEquals((Object)"localhost", (Object)portBinding2.getHost());
        Assert.assertEquals((long)81L, (long)portBinding2.getExposedPort().getExposed());
        Assert.assertEquals((Object)"tcp", (Object)portBinding2.getExposedPort().getType());
        Assert.assertEquals((Object)"static", (Object)container.getAwait().getStrategy());
        Assert.assertEquals((Object)"localhost", (Object)container.getAwait().getIp());
        Assert.assertEquals((long)2L, (long)container.getAwait().getPorts().size());
        System.out.println(ConfigUtil.dump((DockerCompositions)containers));
    }
}

